/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.dto.UserSession;
import java.util.Calendar;

public class UserSessionImpl
implements UserSession {
    private String id;
    private User user;
    private Calendar expiration;
    private long expirationInterval = 0L;
    private String refreshToken;

    public UserSessionImpl(String id, User user, Calendar expiration) {
        this.id = id;
        this.user = user;
        this.expiration = expiration;
    }

    public UserSessionImpl(User user, Calendar expiration) {
        this.user = user;
        this.setExpiration(expiration);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isExpired() {
        if (this.expiration != null) {
            return this.expiration.getTime().before(Calendar.getInstance().getTime());
        }
        return false;
    }

    @Override
    public void refresh() {
        if (this.expiration != null) {
            Calendar newExpiration = Calendar.getInstance();
            newExpiration.setTimeInMillis(newExpiration.getTimeInMillis() + this.expirationInterval * 1000L);
            this.setExpiration(newExpiration);
        }
    }

    public void setExpiration(Calendar expiration) {
        this.expiration = expiration;
    }

    @Override
    public long getExpirationInterval() {
        return this.expirationInterval;
    }

    @Override
    public void setExpirationInterval(long expirationInterval) {
        this.expirationInterval = expirationInterval;
    }
}

