/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.password.PwEncoder;
import it.geosolutions.geostore.services.ServiceTestBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserServiceImplTest
extends ServiceTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void testInsertDeleteUser() throws Exception {
        long userId = this.createUser("test", Role.USER, "tesPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        UserServiceImplTest.assertTrue((String)"Could not delete user", (boolean)userService.delete(userId));
        UserServiceImplTest.assertEquals((long)0L, (long)userService.getCount(null));
    }

    @Test
    public void testUpdateLoadData() throws Exception {
        String NAME = "name1";
        long userId = this.createUser("name1", Role.USER, "testPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        User loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW"));
        UserServiceImplTest.assertEquals((Object)Role.USER, (Object)loaded.getRole());
        loaded.setNewPassword("testPW2");
        userService.update(loaded);
        loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW2"));
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        userService.delete(userId);
        UserServiceImplTest.assertEquals((long)0L, (long)userService.getCount(null));
    }

    @Test
    public void testGetByAttribute() throws Exception {
        UserAttribute attribute = new UserAttribute();
        String token = UUID.randomUUID().toString();
        attribute.setName("UUID");
        attribute.setValue(token);
        this.createUser("test", Role.USER, "tesPW", Arrays.asList(attribute));
        UserServiceImplTest.assertEquals((int)1, (int)userService.getByAttribute(attribute).size());
    }

    @Test
    public void testGetByGroupId() throws Exception {
        long groupId = this.createGroup("testgroup");
        this.createUser("test", Role.USER, "tesPW", groupId);
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        Collection users = userService.getByGroup(group);
        UserServiceImplTest.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void testGetByGroupName() throws Exception {
        long groupId = this.createGroup("testgroup");
        this.createUser("test", Role.USER, "tesPW", groupId);
        UserGroup group = new UserGroup();
        group.setGroupName("testgroup");
        Collection users = userService.getByGroup(group);
        UserServiceImplTest.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void testUpdateByUserId() throws Exception {
        String NAME = "name1";
        long userId = this.createUser("name1", Role.USER, "testPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        User loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW"));
        UserServiceImplTest.assertEquals((Object)Role.USER, (Object)loaded.getRole());
        loaded.setNewPassword("testPW2");
        userService.update(loaded);
        loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW2"));
    }

    @Test
    public void testUpdateWithGroups() throws Exception {
        String NAME = "name1";
        long userId = this.createUser("name1", Role.USER, "testPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        this.createUserGroup("testgroup", new long[]{userId});
        User loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW"));
        UserServiceImplTest.assertEquals((Object)Role.USER, (Object)loaded.getRole());
        UserServiceImplTest.assertEquals((int)1, (int)loaded.getGroups().size());
        loaded.setNewPassword("testPW2");
        userService.update(loaded);
        loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW2"));
        UserServiceImplTest.assertEquals((int)1, (int)loaded.getGroups().size());
    }

    @Test
    public void testUpdateWithGroupsAndEveryone() throws Exception {
        String NAME = "name1";
        this.createSpecialUserGroups();
        long userId = this.createUser("name1", Role.USER, "testPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        this.createUserGroup("testgroup", new long[]{userId});
        User loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW"));
        UserServiceImplTest.assertEquals((Object)Role.USER, (Object)loaded.getRole());
        UserServiceImplTest.assertEquals((int)2, (int)loaded.getGroups().size());
        loaded.setNewPassword("testPW2");
        userService.update(loaded);
        loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW2"));
        UserServiceImplTest.assertEquals((int)2, (int)loaded.getGroups().size());
    }

    @Test
    public void testUpdateByUserName() throws Exception {
        String NAME = "name1";
        long userId = this.createUser("name1", Role.USER, "testPW");
        UserServiceImplTest.assertEquals((long)1L, (long)userService.getCount(null));
        User loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertEquals((String)"name1", (String)loaded.getName());
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW"));
        UserServiceImplTest.assertEquals((Object)Role.USER, (Object)loaded.getRole());
        loaded.setNewPassword("testPW2");
        loaded.setId(Long.valueOf(-1L));
        userService.update(loaded);
        loaded = userService.get(userId);
        UserServiceImplTest.assertNotNull((Object)loaded);
        UserServiceImplTest.assertTrue((boolean)PwEncoder.isPasswordValid((String)loaded.getPassword(), (String)"testPW2"));
    }
}

