/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;

public class FavoriteServiceImplTest
extends ServiceTestBase {
    public void testAddFavorite() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        long userId = this.createUser("user", Role.USER, "password");
        favoriteService.addFavorite(userId, resourceId);
        User user = userService.get(userId);
        userService.fetchFavorites(user);
        Set resourceFavorites = user.getFavorites();
        FavoriteServiceImplTest.assertEquals((int)1, (int)resourceFavorites.size());
        Resource resourceFavorite = (Resource)resourceFavorites.stream().findFirst().orElseThrow();
        FavoriteServiceImplTest.assertEquals((long)resourceId, (long)resourceFavorite.getId());
    }

    public void testAddFavoriteNotFoundUser() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        Assert.assertThrows(NotFoundServiceEx.class, () -> favoriteService.addFavorite(0L, resourceId));
    }

    public void testAddFavoriteNotFoundResource() throws Exception {
        long userId = this.createUser("user", Role.USER, "password");
        Assert.assertThrows(NotFoundServiceEx.class, () -> favoriteService.addFavorite(userId, 0L));
    }

    public void testRemoveFavorite() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        long userId = this.createUser("user", Role.USER, "password");
        User user = userService.get(userId);
        Resource resource = resourceService.get(resourceId);
        user.setFavorites(Collections.singleton(resource));
        userService.update(user);
        userService.fetchFavorites(user);
        FavoriteServiceImplTest.assertFalse((boolean)user.getFavorites().isEmpty());
        favoriteService.removeFavorite(userId, resourceId);
        userService.fetchFavorites(user);
        FavoriteServiceImplTest.assertTrue((boolean)user.getFavorites().isEmpty());
    }

    public void testRemoveFromResourceNotFoundUser() throws Exception {
        long resourceId = this.createResource("resource", "description", "category");
        Assert.assertThrows(NotFoundServiceEx.class, () -> favoriteService.removeFavorite(0L, resourceId));
    }

    public void testRemoveFromResourceNotFoundResource() throws Exception {
        long userId = this.createUser("user", Role.USER, "password");
        Assert.assertThrows(NotFoundServiceEx.class, () -> favoriteService.removeFavorite(userId, 0L));
    }
}

