/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.dao.CategoryDAO;
import it.geosolutions.geostore.core.dao.SecurityDAO;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CategoryServiceImpl
implements CategoryService {
    private static final Logger LOGGER = LogManager.getLogger(CategoryServiceImpl.class);
    private CategoryDAO categoryDAO;
    private SecurityDAO securityDAO;

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public void setCategoryDAO(CategoryDAO categoryDAO) {
        this.categoryDAO = categoryDAO;
    }

    public long insert(Category category) throws BadRequestServiceEx, NotFoundServiceEx {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Persisting Category ... ");
        }
        if (category == null) {
            throw new BadRequestServiceEx("Category type must be specified !");
        }
        Category cat = new Category();
        cat.setName(category.getName());
        this.categoryDAO.persist((Object[])new Category[]{cat});
        return cat.getId();
    }

    public long update(Category category) throws BadRequestServiceEx {
        throw new BadRequestServiceEx("Category can not be updated !");
    }

    public Category get(long id) {
        Category category = (Category)this.categoryDAO.find(Long.valueOf(id));
        return category;
    }

    public Category get(String name) throws BadRequestServiceEx {
        if (name == null) {
            throw new BadRequestServiceEx("Category name must be specified !");
        }
        Search searchCriteria = new Search(Category.class);
        searchCriteria.addFilterEqual("name", (Object)name);
        List categories = this.categoryDAO.search((ISearch)searchCriteria);
        if (categories.size() > 1) {
            LOGGER.warn("Found " + categories.size() + " categories with name '" + name + "'");
        }
        return categories.isEmpty() ? null : (Category)categories.get(0);
    }

    public boolean delete(long id) {
        return this.categoryDAO.removeById(Long.valueOf(id));
    }

    public List<Category> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        if (page != null && entries == null || page == null && entries != null) {
            throw new BadRequestServiceEx("Page and entries params should be declared together.");
        }
        Search searchCriteria = new Search(Category.class);
        if (page != null) {
            searchCriteria.setMaxResults(entries.intValue());
            searchCriteria.setPage(page.intValue());
        }
        searchCriteria.addSortAsc("name");
        List found = this.categoryDAO.search((ISearch)searchCriteria);
        return found;
    }

    public long getCount(String nameLike) {
        Search searchCriteria = new Search(Category.class);
        if (nameLike != null) {
            searchCriteria.addFilterILike("name", nameLike);
        }
        return this.categoryDAO.count((ISearch)searchCriteria);
    }

    public List<SecurityRule> getUserSecurityRule(String userName, long categoryId) {
        return this.categoryDAO.findUserSecurityRule(userName, categoryId);
    }

    public List<SecurityRule> getGroupSecurityRule(List<String> userName, long categoryId) {
        return this.categoryDAO.findGroupSecurityRule(userName, categoryId);
    }
}

