/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionService;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePermissionServiceImpl
implements ResourcePermissionService {
    private static final Logger LOGGER = LogManager.getLogger(ResourcePermissionServiceImpl.class);
    private final BiPredicate<SecurityRule, User> resourceUserOwnership = (rule, user) -> rule.getUser() != null && (user.getId().equals(rule.getUser().getId()) || user.getName() != null && user.getName().equals(rule.getUsername()));
    private final BiPredicate<SecurityRule, UserGroup> resourceGroupOwnership = (rule, group) -> group.getId().equals(rule.getGroup().getId()) || group.getGroupName() != null && group.getGroupName().equals(rule.getGroupname());
    private final BiPredicate<SecurityRule, User> resourceUserIPAccess = (rule, user) -> this.isUserIPAllowed((User)user, rule.getIpRanges());
    private final BiPredicate<SecurityRule, User> resourceUserOwnershipWithReadPermission = (rule, user) -> this.resourceUserOwnership.test((SecurityRule)rule, (User)user) && rule.isCanRead();
    private final BiPredicate<SecurityRule, UserGroup> resourceGroupOwnershipWithReadPermission = (rule, group) -> rule.getGroup() != null && this.resourceGroupOwnership.test((SecurityRule)rule, (UserGroup)group) && rule.isCanRead();
    private final BiPredicate<SecurityRule, User> resourceUserIPAccessWithReadPermission = (rule, user) -> this.resourceUserIPAccess.test((SecurityRule)rule, (User)user) && rule.isCanRead();
    private final BiPredicate<SecurityRule, User> resourceUserOwnershipWithWritePermission = (rule, user) -> this.resourceUserOwnership.test((SecurityRule)rule, (User)user) && rule.isCanWrite();
    private final BiPredicate<SecurityRule, UserGroup> resourceGroupOwnershipWithWritePermission = (rule, group) -> rule.getGroup() != null && this.resourceGroupOwnership.test((SecurityRule)rule, (UserGroup)group) && rule.isCanWrite();
    private final BiPredicate<SecurityRule, User> resourceUserIPAccessWithWritePermission = (rule, user) -> this.resourceUserIPAccess.test((SecurityRule)rule, (User)user) && rule.isCanWrite();

    public boolean canResourceBeReadByUser(Resource resource, User user) {
        if (user.getRole().equals((Object)Role.ADMIN)) {
            return true;
        }
        this.checkResourceSecurityRules(resource);
        return this.canUserAccessWithReadPermission(resource, user);
    }

    private boolean canUserAccessWithReadPermission(Resource resource, User user) {
        return this.hasUserOwnershipWithReadPermission(user, resource) || this.haveUserGroupsOwnershipWithReadPermission(user, resource) || this.hasUserAccessByIpWithReadPermission(user, resource);
    }

    private boolean hasUserOwnershipWithReadPermission(User user, Resource resource) {
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserOwnershipWithReadPermission);
    }

    private boolean haveUserGroupsOwnershipWithReadPermission(User user, Resource resource) {
        return this.checkResourceSecurityRulesAgainstUserGroup(user, resource, this.resourceGroupOwnershipWithReadPermission);
    }

    private boolean hasUserAccessByIpWithReadPermission(User user, Resource resource) {
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserIPAccessWithReadPermission);
    }

    public boolean canResourceBeWrittenByUser(Resource resource, User user) {
        if (!user.getRole().equals((Object)Role.GUEST) && user.getRole().equals((Object)Role.ADMIN)) {
            return true;
        }
        this.checkResourceSecurityRules(resource);
        return this.canUserAccessWithWritePermission(resource, user);
    }

    private void checkResourceSecurityRules(Resource resource) {
        if (resource.getSecurity() == null) {
            throw new IllegalArgumentException("set resource security rules prior checking for permissions");
        }
    }

    private boolean canUserAccessWithWritePermission(Resource resource, User user) {
        return this.hasUserOwnershipWithWritePermission(user, resource) || this.haveUserGroupsOwnershipWithWritePermission(user, resource) || this.hasUserAccessByIpWithWritePermission(user, resource);
    }

    private boolean hasUserOwnershipWithWritePermission(User user, Resource resource) {
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserOwnershipWithWritePermission);
    }

    private boolean checkSecurityRulesAgainstUser(List<SecurityRule> rules, User user, BiPredicate<SecurityRule, User> check) {
        return rules.stream().anyMatch(rule -> check.test((SecurityRule)rule, user));
    }

    private boolean haveUserGroupsOwnershipWithWritePermission(User user, Resource resource) {
        return this.checkResourceSecurityRulesAgainstUserGroup(user, resource, this.resourceGroupOwnershipWithWritePermission);
    }

    private boolean checkResourceSecurityRulesAgainstUserGroup(User user, Resource resource, BiPredicate<SecurityRule, UserGroup> check) {
        if (user.getGroups() == null || user.getGroups().isEmpty()) {
            return false;
        }
        return user.getGroups().stream().anyMatch(group -> this.checkSecurityRulesAgainstUserGroup(resource.getSecurity(), (UserGroup)group, check));
    }

    private boolean checkSecurityRulesAgainstUserGroup(List<SecurityRule> rules, UserGroup group, BiPredicate<SecurityRule, UserGroup> check) {
        return rules.stream().anyMatch(rule -> check.test((SecurityRule)rule, group));
    }

    private boolean hasUserAccessByIpWithWritePermission(User user, Resource resource) {
        return this.checkSecurityRulesAgainstUser(resource.getSecurity(), user, this.resourceUserIPAccessWithWritePermission);
    }

    private boolean isUserIPAllowed(User user, Set<IPRange> ipRanges) {
        if (ipRanges == null || ipRanges.isEmpty()) {
            return false;
        }
        boolean userAllowed = ipRanges.stream().anyMatch(ipRange -> this.isUserIPInRange(user.getIpAddress(), (IPRange)ipRange));
        if (!userAllowed) {
            LOGGER.debug("User not allowed to access resource due to IP address restriction");
        }
        return userAllowed;
    }

    private boolean isUserIPInRange(IPAddress userIPAddress, IPRange ipRange) {
        if (userIPAddress == null) {
            throw new IllegalStateException("Missing IP address for the requesting user. Cannot proceed.");
        }
        IPAddress cidr = new IPAddressString(ipRange.getCidr()).getAddress().toPrefixBlock();
        return cidr.contains(userIPAddress);
    }
}

