/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.math.BigInteger;
import java.util.List;
import org.junit.Assert;

public class IPRangeServiceImplTest
extends ServiceTestBase {
    public void testInsert() throws Exception {
        BigInteger expectedIPRangeAIPLow = BigInteger.valueOf(0x7F000000L);
        BigInteger expectedIPRangeAIPHigh = BigInteger.valueOf(0x7F0000FFL);
        BigInteger expectedIPRangeBIPLow = BigInteger.valueOf(0x1000000L);
        BigInteger expectedIPRangeBIPHigh = BigInteger.valueOf(0x1FFFFFFL);
        IPRange ipRangeA = new IPRange();
        ipRangeA.setCidr("127.0.0.0/24");
        ipRangeA.setDescription("ip-range-A");
        IPRange ipRangeB = new IPRange();
        ipRangeB.setCidr("1.0.0.1/8");
        ipRangeB.setDescription("ip-range-B");
        ipRangeService.insert(ipRangeA);
        ipRangeService.insert(ipRangeB);
        List foundIPRanges = ipRangeDAO.findAll();
        IPRangeServiceImplTest.assertEquals((int)2, (int)foundIPRanges.size());
        IPRange insertedIPRangeA = foundIPRanges.stream().filter(f -> f.getId().equals(ipRangeA.getId())).findFirst().orElseThrow();
        IPRangeServiceImplTest.assertEquals((String)ipRangeA.getCidr(), (String)insertedIPRangeA.getCidr());
        IPRangeServiceImplTest.assertEquals((String)ipRangeA.getDescription(), (String)insertedIPRangeA.getDescription());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPRangeAIPLow, (Object)insertedIPRangeA.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPRangeAIPHigh, (Object)insertedIPRangeA.getIpHigh());
        IPRange insertedIPRangeB = foundIPRanges.stream().filter(f -> f.getId().equals(ipRangeB.getId())).findFirst().orElseThrow();
        IPRangeServiceImplTest.assertEquals((String)ipRangeB.getCidr(), (String)insertedIPRangeB.getCidr());
        IPRangeServiceImplTest.assertEquals((String)ipRangeB.getDescription(), (String)insertedIPRangeB.getDescription());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPRangeBIPLow, (Object)insertedIPRangeB.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPRangeBIPHigh, (Object)insertedIPRangeB.getIpHigh());
    }

    public void testInsertWithoutCidr() {
        IPRange ipRange = new IPRange();
        IPRange duplicateIPRange = new IPRange();
        duplicateIPRange.setCidr(ipRange.getCidr());
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(duplicateIPRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().contains("CIDR must be specified"));
    }

    public void testInsertWithMalformedCidrFormat() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.1.1.1");
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(ipRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid"));
    }

    public void testInsertWithInvalidCidr() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("666.555.444.333/222");
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(ipRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid"));
    }

    public void testInsertWithCidrMissingPrefix() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("192.165.1.5/");
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(ipRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid"));
    }

    public void testInsertWithInvalidCidrPrefix() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.1.1.1/555");
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(ipRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid"));
    }

    public void testInsertSanitizingCidr() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("008.08.8.080/024");
        ipRange.setDescription("sanitize");
        ipRangeService.insert(ipRange);
        IPRange foundIPRange = (IPRange)ipRangeDAO.find(ipRange.getId());
        IPRangeServiceImplTest.assertNotNull((Object)foundIPRange);
        IPRangeServiceImplTest.assertEquals((String)"8.8.8.80/24", (String)foundIPRange.getCidr());
    }

    public void testInsertNull() {
        Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.insert(null));
    }

    public void testGetAll() throws Exception {
        IPRange ipRangeA = new IPRange();
        ipRangeA.setCidr("127.0.0.0/24");
        IPRange ipRangeB = new IPRange();
        ipRangeB.setCidr("1.0.0.1/8");
        ipRangeDAO.persist((Object[])new IPRange[]{ipRangeA, ipRangeB});
        List foundIPRanges = ipRangeService.getAll();
        IPRangeServiceImplTest.assertEquals(List.of(ipRangeA, ipRangeB), (Object)foundIPRanges);
    }

    public void testGet() {
        IPRange ipRangeA = new IPRange();
        ipRangeA.setCidr("127.0.0.0/24");
        IPRange ipRangeB = new IPRange();
        ipRangeB.setCidr("1.0.0.1/8");
        ipRangeDAO.persist((Object[])new IPRange[]{ipRangeA, ipRangeB});
        IPRange foundIPRange = ipRangeService.get(ipRangeA.getId().longValue());
        IPRangeServiceImplTest.assertEquals((Object)ipRangeA, (Object)foundIPRange);
    }

    public void testUpdate() throws Exception {
        String expectedCidr = "127.1.2.3/8";
        String expectedDescription = "onetwothree";
        BigInteger expectedIPLow = BigInteger.valueOf(0x7F000000L);
        BigInteger expectedIPHigh = BigInteger.valueOf(Integer.MAX_VALUE);
        IPRange actualIPRange = new IPRange();
        actualIPRange.setCidr("5.5.5.0/32");
        actualIPRange.setDescription("fivefivefive");
        actualIPRange.setIpLow(BigInteger.ZERO);
        actualIPRange.setIpHigh(BigInteger.TEN);
        ipRangeDAO.persist((Object[])new IPRange[]{actualIPRange});
        IPRange ipRangeUpdate = new IPRange();
        ipRangeUpdate.setCidr(expectedCidr);
        ipRangeUpdate.setDescription(expectedDescription);
        ipRangeService.update(actualIPRange.getId().longValue(), ipRangeUpdate);
        IPRange updatedIPRange = (IPRange)ipRangeDAO.find(ipRangeUpdate.getId());
        IPRangeServiceImplTest.assertEquals((String)expectedCidr, (String)updatedIPRange.getCidr());
        IPRangeServiceImplTest.assertEquals((String)expectedDescription, (String)updatedIPRange.getDescription());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPLow, (Object)updatedIPRange.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPHigh, (Object)updatedIPRange.getIpHigh());
    }

    public void testPartialUpdate() throws Exception {
        String expectedCidr = "127.0.0.0/24";
        String expectedDescription = "clear";
        BigInteger expectedIPLow = BigInteger.valueOf(0x7F000000L);
        BigInteger expectedIPHigh = BigInteger.valueOf(0x7F0000FFL);
        IPRange actualIPRange = new IPRange();
        actualIPRange.setCidr(expectedCidr);
        actualIPRange.setIpLow(expectedIPLow);
        actualIPRange.setIpHigh(expectedIPHigh);
        ipRangeDAO.persist((Object[])new IPRange[]{actualIPRange});
        IPRange ipRangeUpdate = new IPRange();
        ipRangeUpdate.setCidr(expectedCidr);
        ipRangeUpdate.setDescription(expectedDescription);
        ipRangeService.update(actualIPRange.getId().longValue(), ipRangeUpdate);
        IPRange updatedIPRange = (IPRange)ipRangeDAO.find(actualIPRange.getId());
        IPRangeServiceImplTest.assertEquals((String)expectedCidr, (String)updatedIPRange.getCidr());
        IPRangeServiceImplTest.assertEquals((String)expectedDescription, (String)updatedIPRange.getDescription());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPLow, (Object)updatedIPRange.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)expectedIPHigh, (Object)updatedIPRange.getIpHigh());
    }

    public void testUpdateWithMalformedCidr() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("a.0.b.1.xx/s");
        ipRangeDAO.persist((Object[])new IPRange[]{ipRange});
        ipRange.setCidr(ipRange.getCidr());
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.update(ipRange.getId().longValue(), ipRange));
        IPRangeServiceImplTest.assertTrue((boolean)ex.getMessage().startsWith("Invalid"));
    }

    public void testUpdateWithNullCidr() {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("127.0.0.0/24");
        ipRangeDAO.persist((Object[])new IPRange[]{ipRange});
        ipRange.setCidr(null);
        BadRequestServiceEx ex = (BadRequestServiceEx)Assert.assertThrows(BadRequestServiceEx.class, () -> ipRangeService.update(ipRange.getId().longValue(), ipRange));
        IPRangeServiceImplTest.assertEquals((String)"CIDR must be specified", (String)ex.getMessage());
    }

    public void testUpdateNotFoundIPRange() {
        Assert.assertThrows(NotFoundServiceEx.class, () -> ipRangeService.update(0L, new IPRange()));
    }

    public void testDelete() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("127.0.0.0/24");
        ipRangeDAO.persist((Object[])new IPRange[]{ipRange});
        ipRangeService.delete(ipRange.getId().longValue());
        IPRange foundIPRange = (IPRange)ipRangeDAO.find(ipRange.getId());
        IPRangeServiceImplTest.assertNull((Object)foundIPRange);
    }

    public void testDeleteNotFoundIPRange() {
        Assert.assertThrows(NotFoundServiceEx.class, () -> ipRangeService.delete(0L));
    }

    public void testIPRangeBoundsCalculationOnInsertion() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("127.0.0.0/24");
        long ipRangeId = ipRangeService.insert(ipRange);
        IPRange foundIPRange = (IPRange)ipRangeDAO.find(Long.valueOf(ipRangeId));
        IPRangeServiceImplTest.assertNotNull((Object)foundIPRange);
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("2130706432"), (Object)ipRange.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("2130706687"), (Object)ipRange.getIpHigh());
    }

    public void testIPRangeBoundsCalculationOnUpdate() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("4.5.0.22/32");
        ipRange.setIpLow(BigInteger.ONE);
        ipRange.setIpHigh(BigInteger.TEN);
        ipRangeDAO.persist((Object[])new IPRange[]{ipRange});
        ipRange.setCidr("127.0.0.0/24");
        ipRangeService.update(ipRange.getId().longValue(), ipRange);
        IPRange updatedIPRange = (IPRange)ipRangeDAO.find(ipRange.getId());
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("2130706432"), (Object)updatedIPRange.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("2130706687"), (Object)updatedIPRange.getIpHigh());
    }

    public void testIPBlockCalculationFromCidr() throws Exception {
        IPRange ipRange = new IPRange();
        ipRange.setCidr("127.168.1.1/1");
        long ipRangeId = ipRangeService.insert(ipRange);
        IPRange foundIPRange = (IPRange)ipRangeDAO.find(Long.valueOf(ipRangeId));
        IPRangeServiceImplTest.assertNotNull((Object)foundIPRange);
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("0"), (Object)ipRange.getIpLow());
        IPRangeServiceImplTest.assertEquals((Object)new BigInteger("2147483647"), (Object)ipRange.getIpHigh());
    }
}

