/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services;

import inet.ipaddr.IPAddressString;
import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcePermissionServiceImplTest {
    private ResourcePermissionServiceImpl service;

    @Before
    public void setUp() {
        this.service = new ResourcePermissionServiceImpl();
    }

    @Test
    public void testCanReadByUsernameMatch() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setName("alice");
        user.setRole(Role.USER);
        SecurityRule rule = new SecurityRule();
        User ruleUser = new User();
        ruleUser.setId(Long.valueOf(999L));
        rule.setUser(ruleUser);
        rule.setUsername("alice");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via username match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }

    @Test
    public void testCanReadByGroupnameMatch() {
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(10L));
        group.setGroupName("editors");
        User user = new User();
        user.setId(Long.valueOf(200L));
        user.setName("bob");
        user.setRole(Role.USER);
        user.setGroups(Collections.singleton(group));
        SecurityRule rule = new SecurityRule();
        UserGroup ruleGroup = new UserGroup();
        ruleGroup.setId(Long.valueOf(888L));
        rule.setGroup(ruleGroup);
        rule.setGroupname("editors");
        rule.setCanRead(true);
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((String)"User should have read access via groupname match", (boolean)this.service.canResourceBeReadByUser(resource, user));
    }

    @Test
    public void testUserCanAccessByIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("1.2.3.4").getAddress());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.0/24");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserCannotAccessByIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("127.0.0.1").getAddress());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.4/32");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertFalse((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertFalse((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserCannotAccessIfIPAddressIsMissing() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(null);
        IPRange ipRange = new IPRange();
        ipRange.setCidr("101.102.103.104/32");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        IllegalStateException readException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)readException.getMessage().contains("Missing IP address"));
        IllegalStateException writeException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.service.canResourceBeWrittenByUser(resource, user));
        Assert.assertTrue((boolean)writeException.getMessage().contains("Missing IP address"));
    }

    @Test
    public void testUserCanAccessIfIPRangeAppliesToAdditionalRule() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("127.0.0.1").getAddress());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("1.2.3.4/32");
        SecurityRule ruleWithIPRange = new SecurityRule();
        ruleWithIPRange.setIpRanges(Set.of(ipRange));
        SecurityRule ruleWithoutIPRange = new SecurityRule();
        ruleWithoutIPRange.setUser(user);
        ruleWithoutIPRange.setCanRead(true);
        ruleWithoutIPRange.setCanWrite(true);
        Resource resource = new Resource();
        resource.setSecurity(List.of(ruleWithIPRange, ruleWithoutIPRange));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testUserCanAccessIfRulesHaveConflictingIPRanges() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("127.0.0.1").getAddress());
        IPRange inclusiveIpRange = new IPRange();
        inclusiveIpRange.setCidr("127.0.0.0/24");
        IPRange exclusiveIpRange = new IPRange();
        exclusiveIpRange.setCidr("1.2.3.4/32");
        SecurityRule inclusiveSecurityRule = new SecurityRule();
        inclusiveSecurityRule.setCanRead(true);
        inclusiveSecurityRule.setCanWrite(true);
        inclusiveSecurityRule.setIpRanges(Set.of(inclusiveIpRange));
        SecurityRule exclusiveSecurityRule = new SecurityRule();
        exclusiveSecurityRule.setCanRead(true);
        exclusiveSecurityRule.setCanWrite(true);
        exclusiveSecurityRule.setIpRanges(Set.of(exclusiveIpRange));
        Resource resource = new Resource();
        resource.setSecurity(List.of(inclusiveSecurityRule, exclusiveSecurityRule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithDefaultNetworkIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("15.222.30.111").getAddress());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("0.0.0.0/0");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithCidrEqualsIPAddress() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("192.168.1.0").getAddress());
        IPRange ipRange = new IPRange();
        ipRange.setCidr("192.168.1.0/32");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRange));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }

    @Test
    public void testPermissionsWithMultipleConflictingCidrs() {
        User user = new User();
        user.setId(Long.valueOf(100L));
        user.setRole(Role.USER);
        user.setIpAddress(new IPAddressString("122.15.55.34").getAddress());
        IPRange ipRangeExclusive = new IPRange();
        ipRangeExclusive.setCidr("192.168.1.0/12");
        IPRange ipRangeInclusive = new IPRange();
        ipRangeInclusive.setCidr("122.15.0.0/16");
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setIpRanges(Set.of(ipRangeExclusive, ipRangeInclusive));
        Resource resource = new Resource();
        resource.setSecurity(Collections.singletonList(rule));
        Assert.assertTrue((boolean)this.service.canResourceBeReadByUser(resource, user));
        Assert.assertTrue((boolean)this.service.canResourceBeWrittenByUser(resource, user));
    }
}

