/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.services.UserService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class BaseAuthenticationTest
extends TestCase {
    protected final Logger LOGGER = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected UserService userService;
    protected static ClassPathXmlApplicationContext context = null;

    protected void setUp() throws Exception {
        super.setUp();
        File securityTempFolder = new File(System.getProperty("java.io.tmpdir"), "apacheds-spring-security");
        int i = 0;
        for (i = 0; i < 10; ++i) {
            try {
                if (!securityTempFolder.exists() || !securityTempFolder.isDirectory() || !securityTempFolder.canWrite()) break;
                FileDeleteStrategy.FORCE.delete(securityTempFolder);
                FileUtils.forceDelete((File)securityTempFolder);
                break;
            }
            catch (Exception e) {
                this.LOGGER.info(i * 10 + "... ");
                Thread.sleep(1000L);
                continue;
            }
        }
        this.LOGGER.info((Object)100);
        String[] paths = new String[]{"classpath*:applicationContext-test.xml"};
        context = new ClassPathXmlApplicationContext(paths);
        this.LOGGER.info("Built test context: " + String.valueOf(context));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void doAutoLogin(String username, String password, HttpServletRequest request) {
        try {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            Authentication authentication = ((AuthenticationProvider)context.getBean("geostoreLdapProvider")).authenticate((Authentication)token);
            this.LOGGER.info("Logging in with [{" + String.valueOf(authentication.getPrincipal()) + "}]");
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (Exception e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            this.LOGGER.error("Failure in autoLogin", (Throwable)e);
        }
    }

    protected String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    protected String base64Encode(String value) {
        return Base64Utility.encode((byte[])value.getBytes());
    }
}

