/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;

public class Start {
    private static final Logger log = Logger.getLogger(Start.class.getName());

    public static void main(String[] args) {
        block6: {
            final Server jettyServer = new Server();
            try {
                SocketConnector conn = new SocketConnector();
                String portVariable = System.getProperty("jetty.port");
                int port = Start.parsePort(portVariable);
                if (port <= 0) {
                    port = 8280;
                }
                conn.setPort(port);
                conn.setAcceptQueueSize(100);
                conn.setMaxIdleTime(3600000);
                conn.setSoLingerTime(-1);
                jettyServer.setConnectors(new Connector[]{conn});
                WebAppContext wah = new WebAppContext();
                wah.setContextPath("/geostore");
                wah.setWar("src/main/webapp");
                jettyServer.setHandler((Handler)wah);
                wah.setTempDirectory(new File("target/work"));
                wah.getServletContext().getContextHandler().setMaxFormContentSize(0x200000);
                String jettyConfigFile = System.getProperty("jetty.config.file");
                if (jettyConfigFile != null) {
                    log.info("Loading Jetty config from file: " + jettyConfigFile);
                    new XmlConfiguration((InputStream)new FileInputStream(jettyConfigFile)).configure((Object)jettyServer);
                }
                jettyServer.start();
                Thread stopThread = new Thread(){

                    @Override
                    public void run() {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                        try {
                            while (true) {
                                String line;
                                if (!"stop".equals(line = reader.readLine())) {
                                    continue;
                                }
                                jettyServer.stop();
                                System.exit(0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                            return;
                        }
                    }
                };
                stopThread.setDaemon(true);
                stopThread.run();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not start the Jetty server: " + e.getMessage(), e);
                if (jettyServer == null) break block6;
                try {
                    jettyServer.stop();
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Unable to stop the Jetty server:" + e1.getMessage(), e1);
                }
            }
        }
    }

    private static int parsePort(String portVariable) {
        if (portVariable == null) {
            return -1;
        }
        try {
            return Integer.valueOf(portVariable);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

