/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.BaseAuthenticationTest;
import it.geosolutions.geostore.services.rest.impl.RESTCategoryServiceImpl;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.junit.Test;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;

public class SecurityTest
extends BaseAuthenticationTest {
    private static final String ENDPOINT_ADDRESS = "http://localhost:9000/rest/categories";
    private static final String WADL_ADDRESS = "http://localhost:9000/rest/categories?_wadl&_type=xml";
    private boolean serverStarted = false;

    @Override
    protected void setUp() throws Exception {
        if (!SecurityTest.portIsBusy("localhost", 33389) && !SecurityTest.portIsBusy("localhost", 9000)) {
            try {
                super.setUp();
                this.serverStarted = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean portIsBusy(String host, int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testSuite() {
        if (this.serverStarted) {
            this.springAuthenticationTest();
            this.webClientAccessTest();
            this.proxyAccessTest();
        }
    }

    protected void springAuthenticationTest() {
        this.doAutoLogin("admin", "admin", null);
        SecurityTest.assertNotNull((Object)SecurityContextHolder.getContext());
        SecurityTest.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        authentication.getName();
        SecurityTest.assertEquals((Object)"admin", (Object)authentication.getCredentials());
        Object principal = authentication.getPrincipal();
        SecurityTest.assertNotNull((Object)principal);
        if (principal instanceof User) {
            User user = (User)principal;
            SecurityTest.assertEquals((String)"admin", (String)user.getName());
        } else if (principal instanceof LdapUserDetailsImpl) {
            LdapUserDetailsImpl userDetails = (LdapUserDetailsImpl)principal;
            SecurityTest.assertEquals((String)"uid=admin,ou=people,dc=geosolutions,dc=it", (String)userDetails.getDn());
        }
        SecurityTest.assertEquals((int)authentication.getAuthorities().size(), (int)1);
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            SecurityTest.assertEquals((String)"ROLE_ADMIN", (String)authority.getAuthority());
        }
    }

    protected void webClientAccessTest() {
        WebClient client = WebClient.create((String)ENDPOINT_ADDRESS, (String)"admin", (String)"admin", null);
        client.accept(new String[]{"application/json"});
        client.path((Object)"category/1");
        SecurityTest.assertNotNull((Object)client);
    }

    protected void proxyAccessTest() {
        this.doAutoLogin("admin", "admin", null);
        RESTCategoryServiceImpl client = (RESTCategoryServiceImpl)JAXRSClientFactory.create((String)ENDPOINT_ADDRESS, RESTCategoryServiceImpl.class);
        SecurityTest.assertNotNull((Object)client);
    }
}

