/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.util.logging.Logger;
import org.junit.Test;

public class AbstractGDALTest {
    protected static final boolean isGDALAvailable = GDALUtilities.isGDALAvailable();
    public static final String GDAL_DATA = "GDAL_DATA";
    protected static final boolean isGDALDATAEnvSet;
    protected static final String MISSING_DRIVER_MESSAGE = " Driver is not Available. Tests will be skipped\n Make sure GDAL has been built with support for this format and the required native libs are in the path ";
    protected static final Logger LOGGER;

    @Test
    public void setUp() throws Exception {
        if (!isGDALAvailable) {
            LOGGER.warning("GDAL Library is not Available");
            return;
        }
    }

    public static final void missingDriverMessage(String format) {
        LOGGER.warning(format + MISSING_DRIVER_MESSAGE);
    }

    public static final void warningMessage() {
        LOGGER.info("Test file not available");
    }

    public static final void warningMessage(String customMessage) {
        LOGGER.info(customMessage);
    }

    static {
        String gdalData = System.getenv(GDAL_DATA);
        isGDALDATAEnvSet = gdalData != null && gdalData.trim().length() > 0;
        LOGGER = Logger.getLogger(AbstractGDALTest.class.toString());
    }
}

