/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.GCP;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageWriteParam;
import it.geosolutions.imageio.gdalframework.GDALImageWriterSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.gdalframework.GDALWritableCommonIIOImageMetadata;
import it.geosolutions.imageio.stream.AccessibleStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import org.eclipse.imagen.PlanarImage;
import org.gdal.gdal.Band;
import org.gdal.gdal.ColorTable;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public abstract class GDALImageWriter
extends ImageWriter {
    private static final Logger LOGGER = Logger.getLogger(GDALImageWriter.class.toString());
    private static final int DEFAULT_GDALMEMORYRASTER_MAXSIZE = 0x2000000;
    protected File outputFile;
    private static ThreadLocalMemoryDriver memDriver = new ThreadLocalMemoryDriver();

    protected static final int getMaxMemorySizeForGDALMemoryDataset() {
        int size = 0x2000000;
        Integer maxSize = Integer.getInteger("it.geosolutions.gdalmemoryrastermaxsize");
        if (maxSize != null) {
            size = maxSize;
        } else {
            String maxSizes = System.getProperty("it.geosolutions.gdalmemoryrastermaxsize");
            if (maxSizes != null) {
                int length = maxSizes.length();
                String value = maxSizes.substring(0, length - 1);
                String suffix = maxSizes.substring(length - 1, length);
                if (suffix.equalsIgnoreCase("M") || suffix.equalsIgnoreCase("K")) {
                    try {
                        int val = Integer.parseInt(value);
                        val = suffix.equalsIgnoreCase("M") ? (val *= 0x100000) : (val *= 1024);
                        size = val;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return size;
    }

    protected static Driver getMemoryDriver() {
        return (Driver)memDriver.get();
    }

    public GDALImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        throw new UnsupportedOperationException("getDefaultStreamMetadata not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        Driver driver;
        block27: {
            String driverName;
            GDALUtilities.DriverCreateCapabilities writingCapabilities;
            if (this.outputFile == null) {
                throw new IllegalStateException("the output is null!");
            }
            if (param == null) {
                param = this.getDefaultWriteParam();
            }
            if ((writingCapabilities = GDALUtilities.formatWritingCapabilities(driverName = (String)((GDALImageWriterSpi)this.originatingProvider).getSupportedFormats().get(0))) == GDALUtilities.DriverCreateCapabilities.READ_ONLY) {
                throw new IllegalStateException("This writer seems to not support either create or create copy");
            }
            if (image == null) {
                throw new IllegalArgumentException("The provided input image is invalid.");
            }
            PlanarImage inputRenderedImage = PlanarImage.wrapRenderedImage((RenderedImage)image.getRenderedImage());
            int sourceWidth = inputRenderedImage.getWidth();
            int sourceHeight = inputRenderedImage.getHeight();
            int sourceMinX = inputRenderedImage.getMinX();
            int sourceMinY = inputRenderedImage.getMinY();
            int dataType = GDALUtilities.retrieveGDALDataBufferType(inputRenderedImage.getSampleModel().getDataType());
            int nBands = inputRenderedImage.getNumBands();
            int xSubsamplingFactor = param.getSourceXSubsampling();
            int ySubsamplingFactor = param.getSourceYSubsampling();
            Vector myOptions = (Vector)((GDALImageWriteParam)param).getCreateOptionsHandler().getCreateOptions();
            Rectangle imageBounds = new Rectangle(sourceMinX, sourceMinY, sourceWidth, sourceHeight);
            Dimension destSize = new Dimension();
            GDALImageWriter.computeRegions(imageBounds, destSize, param);
            int destinationWidth = destSize.width;
            int destinationHeight = destSize.height;
            IIOMetadata metadata = image.getMetadata();
            GDALCommonIIOImageMetadata imageMetadata = null;
            if (metadata != null && metadata instanceof GDALCommonIIOImageMetadata) {
                imageMetadata = (GDALCommonIIOImageMetadata)((Object)metadata);
            }
            Dataset writeDataset = null;
            driver = null;
            try {
                if (writingCapabilities == GDALUtilities.DriverCreateCapabilities.CREATE) {
                    String fileName = this.outputFile.getAbsolutePath();
                    driver = gdal.GetDriverByName((String)driverName);
                    writeDataset = driver.Create(fileName, destinationWidth, destinationHeight, nBands, dataType, myOptions);
                    writeDataset = this.writeData(writeDataset, (RenderedImage)inputRenderedImage, imageBounds, nBands, dataType, xSubsamplingFactor, ySubsamplingFactor);
                    if (imageMetadata != null) {
                        this.setMetadata(writeDataset, imageMetadata);
                    }
                } else {
                    File tempFile;
                    block26: {
                        driver = gdal.GetDriverByName((String)driverName);
                        tempFile = File.createTempFile("datasetTemp", ".ds", null);
                        Dataset tempDataset = null;
                        try {
                            tempDataset = this.createDatasetFromImage((RenderedImage)inputRenderedImage, tempFile.getAbsolutePath(), imageBounds, nBands, dataType, destinationWidth, destinationHeight, xSubsamplingFactor, ySubsamplingFactor);
                            tempDataset.FlushCache();
                            if (imageMetadata != null) {
                                this.setMetadata(tempDataset, imageMetadata);
                            }
                            writeDataset = driver.CreateCopy(this.outputFile.getPath(), tempDataset, 0, myOptions);
                            if (tempDataset == null) break block26;
                        }
                        catch (Throwable throwable) {
                            if (tempDataset == null) throw throwable;
                            try {
                                GDALUtilities.closeDataSet(tempDataset);
                                throw throwable;
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                            throw throwable;
                        }
                        try {
                            GDALUtilities.closeDataSet(tempDataset);
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block26;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    tempFile.delete();
                }
                writeDataset.FlushCache();
                if (writeDataset == null) break block27;
            }
            catch (Throwable throwable) {
                block28: {
                    if (writeDataset != null) {
                        try {
                            GDALUtilities.closeDataSet(writeDataset);
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block28;
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                }
                if (driver == null) throw throwable;
                try {
                    driver.delete();
                    throw throwable;
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
                throw throwable;
            }
            try {
                GDALUtilities.closeDataSet(writeDataset);
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block27;
                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            }
        }
        if (driver == null) return;
        try {
            driver.delete();
            return;
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINEST)) return;
            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            return;
        }
    }

    private void setMetadata(Dataset dataset, GDALCommonIIOImageMetadata imageMetadata) {
        int gcpNum;
        String projection;
        double[] geoTransformation = imageMetadata.getGeoTransformation();
        if (geoTransformation != null) {
            dataset.SetGeoTransform(geoTransformation);
        }
        if ((projection = imageMetadata.getProjection()) != null && projection.trim().length() != 0) {
            dataset.SetProjection(projection);
        }
        if ((gcpNum = imageMetadata.getGcpNumber()) != 0) {
            String gcpProj = imageMetadata.getGcpProjection();
            List<GCP> list = imageMetadata.getGCPs();
        }
        int nBands = imageMetadata.getNumBands();
        for (int i = 0; i < nBands; ++i) {
            ColorModel cm;
            Band band = dataset.GetRasterBand(i + 1);
            int colorInterpretation = imageMetadata.getColorInterpretations(i);
            band.SetRasterColorInterpretation(colorInterpretation);
            if (i == 0 && nBands == 1 && colorInterpretation == gdalconstConstants.GCI_PaletteIndex && (cm = imageMetadata.getColorModel()) instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int size = icm.getMapSize();
                ColorTable ct = new ColorTable(gdalconstConstants.GPI_RGB);
                for (int j = 0; j < size; ++j) {
                    ct.SetColorEntry(j, new Color(icm.getRGB(j)));
                }
                band.SetRasterColorTable(ct);
            }
            try {
                double noData = imageMetadata.getNoDataValue(i);
                if (Double.isNaN(noData)) continue;
                band.SetNoDataValue(noData);
                continue;
            }
            catch (IllegalArgumentException noData) {
                // empty catch block
            }
        }
        List<String> domains = imageMetadata.getGdalMetadataDomainsList();
        int nDomains = domains.size();
        for (int i = 0; i < nDomains; ++i) {
            String domain = domains.get(i);
            Map metadataMap = imageMetadata.getGdalMetadataDomain(domain);
            if (metadataMap == null) continue;
            for (String key : metadataMap.keySet()) {
                String value = (String)metadataMap.get(key);
                dataset.SetMetadataItem(key, value, domain);
            }
        }
    }

    private Dataset writeData(Dataset dataset, RenderedImage inputRenderedImage, Rectangle sourceRegion, int nBands, int dataType, int xSubsamplingFactor, int ySubsamplingFactor) {
        int typeSizeInBytes = gdal.GetDataTypeSize((int)dataType) / 8;
        int srcRegionXOffset = sourceRegion.x;
        int srcRegionYOffset = sourceRegion.y;
        int srcRegionWidth = sourceRegion.width;
        int srcRegionHeight = sourceRegion.height;
        int srcRegionXEnd = srcRegionWidth + srcRegionXOffset;
        int srcRegionYEnd = srcRegionHeight + srcRegionYOffset;
        int minx_ = inputRenderedImage.getMinX();
        int miny_ = inputRenderedImage.getMinY();
        int srcW_ = inputRenderedImage.getWidth();
        int srcH_ = inputRenderedImage.getHeight();
        int maxx_ = minx_ + srcW_;
        int maxy_ = miny_ + srcH_;
        int minTileX = inputRenderedImage.getMinTileX();
        int minTileY = inputRenderedImage.getMinTileY();
        int maxTileX = minTileX + inputRenderedImage.getNumXTiles();
        int maxTileY = minTileY + inputRenderedImage.getNumYTiles();
        int tileW = inputRenderedImage.getTileWidth();
        int tileH = inputRenderedImage.getTileHeight();
        tileW = tileW < srcW_ ? tileW : srcW_;
        tileH = tileH < srcH_ ? tileH : srcH_;
        boolean splitBands = false;
        boolean isSubSampled = ySubsamplingFactor > 1 || xSubsamplingFactor > 1;
        int dstWidth = 0;
        int dstHeight = 0;
        int xOff = 0;
        int yOff = 0;
        for (int ty = minTileY; ty < maxTileY; ++ty) {
            xOff = 0;
            for (int tx = minTileX; tx < maxTileX; ++tx) {
                int i;
                int[] bands;
                int capacity;
                Raster raster = inputRenderedImage.getTile(tx, ty);
                int minx = raster.getMinX();
                int miny = raster.getMinY();
                minx = minx < minx_ ? minx_ : minx;
                miny = miny < miny_ ? miny_ : miny;
                int maxx = minx + tileW;
                int maxy = miny + tileH;
                maxx = maxx > maxx_ ? maxx_ : maxx;
                maxy = maxy > maxy_ ? maxy_ : maxy;
                int offsetX = minx;
                int offsetY = miny;
                int newWidth = maxx - minx;
                int newHeight = maxy - miny;
                if (minx < srcRegionXOffset) {
                    if (maxx <= srcRegionXOffset) continue;
                    offsetX = srcRegionXOffset;
                    newWidth = srcRegionXEnd <= maxx ? srcRegionWidth : tileW - (offsetX - minx);
                } else {
                    if (minx >= srcRegionXEnd) break;
                    if (maxx >= srcRegionXEnd) {
                        newWidth = srcRegionXEnd - minx;
                    }
                }
                if (miny < srcRegionYOffset) {
                    if (maxy <= srcRegionYOffset) continue;
                    offsetY = srcRegionYOffset;
                    newHeight = srcRegionYEnd <= maxy ? srcRegionHeight : tileH - (offsetY - miny);
                } else {
                    if (miny >= srcRegionYEnd) break;
                    if (maxy >= srcRegionYEnd) {
                        newHeight = srcRegionYEnd - miny;
                    }
                }
                int endX = offsetX + newWidth;
                int endY = offsetY + newHeight;
                dstWidth = 0;
                dstHeight = 0;
                if (ySubsamplingFactor > 1) {
                    for (int j = offsetY; j < endY; ++j) {
                        if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                        ++dstHeight;
                    }
                } else {
                    dstHeight = newHeight;
                }
                if (xSubsamplingFactor > 1) {
                    for (int i2 = offsetX; i2 < endX; ++i2) {
                        if ((i2 - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                        ++dstWidth;
                    }
                } else {
                    dstWidth = newWidth;
                }
                if ((capacity = dstWidth * dstHeight * typeSizeInBytes * nBands) < 0) {
                    splitBands = true;
                    capacity = dstWidth * dstHeight * typeSizeInBytes;
                }
                ByteBuffer[] bandsBuffer = !isSubSampled ? this.getDataRegion(raster, offsetX, offsetY, endX - 1, endY - 1, dataType, nBands, splitBands, capacity) : this.getSubSampledDataRegion(raster, offsetX, offsetY, endX - 1, endY - 1, srcRegionXOffset, srcRegionYOffset, xSubsamplingFactor, ySubsamplingFactor, dataType, nBands, splitBands, capacity);
                if (!splitBands) {
                    bands = new int[nBands];
                    for (i = 0; i < nBands; ++i) {
                        bands[i] = i + 1;
                    }
                    dataset.WriteRaster_Direct(xOff, yOff, dstWidth, dstHeight, dstWidth, dstHeight, dataType, bandsBuffer[0], bands, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, 1);
                } else {
                    bands = new int[nBands];
                    for (i = 0; i < nBands; ++i) {
                        dataset.GetRasterBand(i + 1).WriteRaster_Direct(xOff, yOff, dstWidth, dstHeight, dstWidth, dstHeight, dataType, bandsBuffer[i]);
                    }
                }
                xOff += dstWidth;
            }
            yOff += dstHeight;
        }
        return dataset;
    }

    private ByteBuffer[] getSubSampledDataRegion(Raster raster, int firstX, int firstY, int lastX, int lastY, int srcRegionXOffset, int srcRegionYOffset, int xSubsamplingFactor, int ySubsamplingFactor, int dataType, int nBands, boolean splitBands, int capacity) {
        ByteBuffer[] bandsBuffer;
        block32: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                if (firstX < srcRegionXOffset || firstX < srcRegionYOffset || firstX > lastX || firstY > lastY) {
                                    throw new IllegalArgumentException("The requested region is not valid");
                                }
                                bandsBuffer = splitBands ? new ByteBuffer[nBands] : new ByteBuffer[1];
                                if (dataType != gdalconstConstants.GDT_Byte) break block31;
                                for (int k = 0; k < nBands; ++k) {
                                    bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                                    if (!splitBands) break;
                                }
                                byte[] data = new byte[nBands];
                                for (int j = firstY; j <= lastY; ++j) {
                                    if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                                    for (int i = firstX; i <= lastX; ++i) {
                                        if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                                        data = (byte[])raster.getDataElements(i, j, data);
                                        if (splitBands) {
                                            for (int k = 0; k < nBands; ++k) {
                                                bandsBuffer[k].put(data, k, 1);
                                            }
                                            continue;
                                        }
                                        bandsBuffer[0].put(data, 0, nBands);
                                    }
                                }
                                break block32;
                            }
                            if (dataType != gdalconstConstants.GDT_Int16) break block33;
                            ShortBuffer[] buf = new ShortBuffer[nBands];
                            for (int k = 0; k < nBands; ++k) {
                                bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                                bandsBuffer[k].order(ByteOrder.nativeOrder());
                                buf[k] = bandsBuffer[k].asShortBuffer();
                                if (!splitBands) break;
                            }
                            short[] data = new short[nBands];
                            for (int j = firstY; j <= lastY; ++j) {
                                if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                                for (int i = firstX; i <= lastX; ++i) {
                                    if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                                    data = (short[])raster.getDataElements(i, j, data);
                                    if (splitBands) {
                                        for (int k = 0; k < nBands; ++k) {
                                            buf[k].put(data, k, 1);
                                        }
                                        continue;
                                    }
                                    buf[0].put(data, 0, nBands);
                                }
                            }
                            break block32;
                        }
                        if (dataType != gdalconstConstants.GDT_UInt16) break block34;
                        ShortBuffer[] buf = new ShortBuffer[nBands];
                        for (int k = 0; k < nBands; ++k) {
                            bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                            bandsBuffer[k].order(ByteOrder.nativeOrder());
                            buf[k] = bandsBuffer[k].asShortBuffer();
                            if (!splitBands) break;
                        }
                        short[] data = new short[nBands];
                        for (int j = firstY; j <= lastY; ++j) {
                            if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                            for (int i = firstX; i <= lastX; ++i) {
                                if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                                data = (short[])raster.getDataElements(i, j, data);
                                if (splitBands) {
                                    for (int k = 0; k < nBands; ++k) {
                                        buf[k].put(data, k, 1);
                                    }
                                    continue;
                                }
                                buf[0].put(data, 0, nBands);
                            }
                        }
                        break block32;
                    }
                    if (dataType != gdalconstConstants.GDT_Int32) break block35;
                    IntBuffer[] buf = new IntBuffer[nBands];
                    for (int k = 0; k < nBands; ++k) {
                        bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                        bandsBuffer[k].order(ByteOrder.nativeOrder());
                        buf[k] = bandsBuffer[k].asIntBuffer();
                        if (!splitBands) break;
                    }
                    int[] data = new int[nBands];
                    for (int j = firstY; j <= lastY; ++j) {
                        if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                        for (int i = firstX; i <= lastX; ++i) {
                            if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                            data = (int[])raster.getDataElements(i, j, data);
                            if (splitBands) {
                                for (int k = 0; k < nBands; ++k) {
                                    buf[k].put(data, k, 1);
                                }
                                continue;
                            }
                            buf[0].put(data, 0, nBands);
                        }
                    }
                    break block32;
                }
                if (dataType != gdalconstConstants.GDT_Float32) break block36;
                FloatBuffer[] buf = new FloatBuffer[nBands];
                for (int k = 0; k < nBands; ++k) {
                    bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                    bandsBuffer[k].order(ByteOrder.nativeOrder());
                    buf[k] = bandsBuffer[k].asFloatBuffer();
                    if (!splitBands) break;
                }
                float[] data = new float[nBands];
                for (int j = firstY; j <= lastY; ++j) {
                    if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                    for (int i = firstX; i <= lastX; ++i) {
                        if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                        data = (float[])raster.getDataElements(i, j, data);
                        if (splitBands) {
                            for (int k = 0; k < nBands; ++k) {
                                buf[k].put(data, k, 1);
                            }
                            continue;
                        }
                        buf[0].put(data, 0, nBands);
                    }
                }
                break block32;
            }
            if (dataType != gdalconstConstants.GDT_Float64) break block32;
            DoubleBuffer[] buf = new DoubleBuffer[nBands];
            for (int k = 0; k < nBands; ++k) {
                bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                bandsBuffer[k].order(ByteOrder.nativeOrder());
                buf[k] = bandsBuffer[k].asDoubleBuffer();
                if (!splitBands) break;
            }
            double[] data = new double[nBands];
            for (int j = firstY; j <= lastY; ++j) {
                if ((j - srcRegionYOffset) % ySubsamplingFactor != 0) continue;
                for (int i = firstX; i <= lastX; ++i) {
                    if ((i - srcRegionXOffset) % xSubsamplingFactor != 0) continue;
                    data = (double[])raster.getDataElements(i, j, data);
                    if (splitBands) {
                        for (int k = 0; k < nBands; ++k) {
                            buf[k].put(data, k, 1);
                        }
                        continue;
                    }
                    buf[0].put(data, 0, nBands);
                }
            }
        }
        return bandsBuffer;
    }

    private ByteBuffer[] getDataRegion(Raster raster, int firstX, int firstY, int lastX, int lastY, int dataType, int nBands, boolean splitBands, int capacity) {
        ByteBuffer[] bandsBuffer;
        block32: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                if (firstX > lastX || firstY > lastY) {
                                    throw new IllegalArgumentException("The requested region is not valid");
                                }
                                bandsBuffer = splitBands ? new ByteBuffer[nBands] : new ByteBuffer[1];
                                if (dataType != gdalconstConstants.GDT_Byte) break block31;
                                for (int k = 0; k < nBands; ++k) {
                                    bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                                    if (!splitBands) break;
                                }
                                byte[] data = new byte[nBands];
                                for (int j = firstY; j <= lastY; ++j) {
                                    for (int i = firstX; i <= lastX; ++i) {
                                        data = (byte[])raster.getDataElements(i, j, data);
                                        if (splitBands) {
                                            for (int k = 0; k < nBands; ++k) {
                                                bandsBuffer[k].put(data, k, 1);
                                            }
                                            continue;
                                        }
                                        bandsBuffer[0].put(data, 0, nBands);
                                    }
                                }
                                break block32;
                            }
                            if (dataType != gdalconstConstants.GDT_Int16) break block33;
                            ShortBuffer[] buf = new ShortBuffer[nBands];
                            for (int k = 0; k < nBands; ++k) {
                                bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                                bandsBuffer[k].order(ByteOrder.nativeOrder());
                                buf[k] = bandsBuffer[k].asShortBuffer();
                                if (!splitBands) break;
                            }
                            short[] data = new short[nBands];
                            for (int j = firstY; j <= lastY; ++j) {
                                for (int i = firstX; i <= lastX; ++i) {
                                    data = (short[])raster.getDataElements(i, j, data);
                                    if (splitBands) {
                                        for (int k = 0; k < nBands; ++k) {
                                            buf[k].put(data, k, 1);
                                        }
                                        continue;
                                    }
                                    buf[0].put(data, 0, nBands);
                                }
                            }
                            break block32;
                        }
                        if (dataType != gdalconstConstants.GDT_UInt16) break block34;
                        ShortBuffer[] buf = new ShortBuffer[nBands];
                        for (int k = 0; k < nBands; ++k) {
                            bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                            bandsBuffer[k].order(ByteOrder.nativeOrder());
                            buf[k] = bandsBuffer[k].asShortBuffer();
                            if (!splitBands) break;
                        }
                        short[] data = new short[nBands];
                        for (int j = firstY; j <= lastY; ++j) {
                            for (int i = firstX; i <= lastX; ++i) {
                                data = (short[])raster.getDataElements(i, j, data);
                                if (splitBands) {
                                    for (int k = 0; k < nBands; ++k) {
                                        buf[k].put(data, k, 1);
                                    }
                                    continue;
                                }
                                buf[0].put(data, 0, nBands);
                            }
                        }
                        break block32;
                    }
                    if (dataType != gdalconstConstants.GDT_Int32) break block35;
                    IntBuffer[] buf = new IntBuffer[nBands];
                    for (int k = 0; k < nBands; ++k) {
                        bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                        bandsBuffer[k].order(ByteOrder.nativeOrder());
                        buf[k] = bandsBuffer[k].asIntBuffer();
                        if (!splitBands) break;
                    }
                    int[] data = new int[nBands];
                    for (int j = firstY; j <= lastY; ++j) {
                        for (int i = firstX; i <= lastX; ++i) {
                            data = (int[])raster.getDataElements(i, j, data);
                            if (splitBands) {
                                for (int k = 0; k < nBands; ++k) {
                                    buf[k].put(data, k, 1);
                                }
                                continue;
                            }
                            buf[0].put(data, 0, nBands);
                        }
                    }
                    break block32;
                }
                if (dataType != gdalconstConstants.GDT_Float32) break block36;
                FloatBuffer[] buf = new FloatBuffer[nBands];
                for (int k = 0; k < nBands; ++k) {
                    bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                    bandsBuffer[k].order(ByteOrder.nativeOrder());
                    buf[k] = bandsBuffer[k].asFloatBuffer();
                    if (!splitBands) break;
                }
                float[] data = new float[nBands];
                for (int j = firstY; j <= lastY; ++j) {
                    for (int i = firstX; i <= lastX; ++i) {
                        data = (float[])raster.getDataElements(i, j, data);
                        if (splitBands) {
                            for (int k = 0; k < nBands; ++k) {
                                buf[k].put(data, k, 1);
                            }
                            continue;
                        }
                        buf[0].put(data, 0, nBands);
                    }
                }
                break block32;
            }
            if (dataType != gdalconstConstants.GDT_Float64) break block32;
            DoubleBuffer[] buf = new DoubleBuffer[nBands];
            for (int k = 0; k < nBands; ++k) {
                bandsBuffer[k] = ByteBuffer.allocateDirect(capacity);
                bandsBuffer[k].order(ByteOrder.nativeOrder());
                buf[k] = bandsBuffer[k].asDoubleBuffer();
                if (!splitBands) break;
            }
            double[] data = new double[nBands];
            for (int j = firstY; j <= lastY; ++j) {
                for (int i = firstX; i <= lastX; ++i) {
                    data = (double[])raster.getDataElements(i, j, data);
                    if (splitBands) {
                        for (int k = 0; k < nBands; ++k) {
                            buf[k].put(data, k, 1);
                        }
                        continue;
                    }
                    buf[0].put(data, 0, nBands);
                }
            }
        }
        return bandsBuffer;
    }

    private Dataset createDatasetFromImage(RenderedImage inputRenderedImage, String tempFile, Rectangle sourceRegion, int nBands, int dataType, int width, int height, int xSubsamplingFactor, int ySubsamplingFactor) {
        Dataset tempDs = null;
        int threshold = GDALImageWriter.getMaxMemorySizeForGDALMemoryDataset();
        int neededMemory = width * height * nBands * gdal.GetDataTypeSize((int)dataType) / 8;
        if (neededMemory <= threshold) {
            tempDs = GDALImageWriter.getMemoryDriver().Create(tempFile, width, height, nBands, dataType, (String[])null);
        }
        if (tempDs == null) {
            Driver driver = gdal.GetDriverByName((String)"GTiff");
            tempDs = driver.Create(tempFile, width, height, nBands, dataType, (String[])null);
        }
        return this.writeData(tempDs, inputRenderedImage, sourceRegion, nBands, dataType, xSubsamplingFactor, ySubsamplingFactor);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        GDALWritableCommonIIOImageMetadata imageMetadata = new GDALWritableCommonIIOImageMetadata();
        SampleModel sm = imageType.getSampleModel();
        int sourceWidth = sm.getWidth();
        int sourceHeight = sm.getHeight();
        boolean sourceMinX = false;
        boolean sourceMinY = false;
        int dataType = GDALUtilities.retrieveGDALDataBufferType(sm.getDataType());
        int nBands = sm.getNumBands();
        Rectangle imageBounds = new Rectangle(0, 0, sourceWidth, sourceHeight);
        Dimension destSize = new Dimension();
        GDALImageWriter.computeRegions(imageBounds, destSize, param);
        imageMetadata.setBasicInfo(destSize.width, destSize.height, nBands);
        return imageMetadata;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        throw new UnsupportedOperationException("convertStreamMetadata not supported yet.");
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        throw new UnsupportedOperationException("convertImageMetadata not supported yet. Create a new GDALWritableCommonIIOImageMetadata and set required fields");
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (output instanceof File) {
            this.outputFile = (File)output;
        } else if (output instanceof AccessibleStream) {
            this.outputFile = (File)((AccessibleStream)output).getTarget();
        } else if (output instanceof URL) {
            URL tempURL = (URL)output;
            if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                this.outputFile = ImageIOUtilities.urlToFile((URL)tempURL);
            } else {
                throw new IllegalArgumentException("Not a Valid Input");
            }
        }
    }

    @Override
    public void write(IIOImage image) throws IOException {
        this.write(null, image, null);
    }

    @Override
    public void write(RenderedImage image) throws IOException {
        this.write(null, new IIOImage(image, null, null), null);
    }

    private static void computeRegions(Rectangle sourceBounds, Dimension destSize, ImageWriteParam p) {
        int periodX = 1;
        int periodY = 1;
        if (p != null) {
            int[] sourceBands = p.getSourceBands();
            if (sourceBands != null && (sourceBands.length != 1 || sourceBands[0] != 0)) {
                throw new IllegalArgumentException("Cannot sub-band image!");
            }
            Rectangle sourceRegion = p.getSourceRegion();
            if (sourceRegion != null) {
                sourceRegion = sourceRegion.intersection(sourceBounds);
                sourceBounds.setBounds(sourceRegion);
            }
            periodX = p.getSourceXSubsampling();
            periodY = p.getSourceYSubsampling();
            int gridX = p.getSubsamplingXOffset();
            int gridY = p.getSubsamplingYOffset();
            sourceBounds.x += gridX;
            sourceBounds.y += gridY;
            sourceBounds.width -= gridX;
            sourceBounds.height -= gridY;
        }
        destSize.setSize((sourceBounds.width + periodX - 1) / periodX, (sourceBounds.height + periodY - 1) / periodY);
        if (destSize.width <= 0 || destSize.height <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
    }

    private static class ThreadLocalMemoryDriver
    extends ThreadLocal<Driver> {
        private ThreadLocalMemoryDriver() {
        }

        @Override
        public Driver initialValue() {
            return gdal.GetDriverByName((String)"MEM");
        }
    }
}

