/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class HDF4Products
implements List<HDF4Product> {
    private ArrayList<HDF4Product> productList;
    private int nProducts;

    @Override
    public boolean add(HDF4Product o) {
        return false;
    }

    @Override
    public void add(int index, HDF4Product element) {
        this.productList.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends HDF4Product> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends HDF4Product> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (this.productList != null) {
            return this.productList.contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HDF4Product get(int productIndex) {
        if (productIndex > this.nProducts) {
            throw new ArrayIndexOutOfBoundsException("Specified product index is out of range");
        }
        return this.productList.get(productIndex);
    }

    @Override
    public int indexOf(Object o) {
        return this.productList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.productList.isEmpty();
    }

    @Override
    public Iterator<HDF4Product> iterator() {
        return new HDF4ProductsIterator(this.productList.iterator());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.productList.lastIndexOf(o);
    }

    @Override
    public ListIterator<HDF4Product> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<HDF4Product> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HDF4Product remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HDF4Product set(int productIndex, HDF4Product product) {
        if (productIndex > this.nProducts) {
            throw new ArrayIndexOutOfBoundsException("Specified product index is out of range");
        }
        this.productList.set(productIndex, product);
        return this.productList.get(productIndex);
    }

    @Override
    public int size() {
        return this.productList.size();
    }

    @Override
    public List<HDF4Product> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public HDF4Products(int nProducts) {
        this.productList = new ArrayList(nProducts);
        this.nProducts = nProducts;
    }

    public HDF4Product get(String productName) {
        int prodNum = this.nProducts;
        for (int i = 0; i < prodNum; ++i) {
            HDF4Product product = this.productList.get(i);
            if (!product.getProductName().equals(productName)) continue;
            return product;
        }
        return null;
    }

    public int getNProducts() {
        return this.nProducts;
    }

    public class HDF4Product {
        private String productName;
        private int nBands;

        public HDF4Product(String productName, int nBands) {
            this.productName = productName;
            this.nBands = nBands;
        }

        public int getNBands() {
            return this.nBands;
        }

        public String getProductName() {
            return this.productName;
        }
    }

    private class HDF4ProductsIterator
    implements Iterator<HDF4Product> {
        private Iterator<HDF4Product> it;

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public HDF4Product next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public HDF4ProductsIterator(Iterator<HDF4Product> it) {
            this.it = it;
        }
    }
}

