/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KTreeChecker;
import it.geosolutions.imageio.plugins.jp2k.LazyJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.ColorSpecificationBox;
import it.geosolutions.imageio.plugins.jp2k.box.FileTypeBox;
import it.geosolutions.imageio.plugins.jp2k.box.ImageHeaderBox;
import it.geosolutions.imageio.plugins.jp2k.box.JP2KFileBox;
import it.geosolutions.imageio.plugins.jp2k.box.ReaderRequirementsBox;
import it.geosolutions.imageio.plugins.jp2k.box.SignatureBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JP2KTreeController
implements JP2KTreeChecker,
TreeModelListener {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.jp2k");
    private Map<FileTypeBox.JPEG2000FileType, PolicyCheck> policies = new HashMap<FileTypeBox.JPEG2000FileType, PolicyCheck>();
    private DefaultTreeModel model;
    private FileTypeBox.JPEG2000FileType fileType = FileTypeBox.JPEG2000FileType.UNSPECIFIED;
    private Set<FileTypeBox.JPEG2000FileType> compatibilitySet;

    private static Throwable checkCauses(Collection<Throwable> causes) {
        if (causes == null || causes.size() == 0) {
            throw new IllegalArgumentException("Causes cannot be null or empty for this MultiCauseIllegalStateException");
        }
        return causes.iterator().next();
    }

    public JP2KTreeController(DefaultTreeModel model) {
        this.policies.put(FileTypeBox.JPEG2000FileType.JP2, new JP2Policy());
        this.policies.put(FileTypeBox.JPEG2000FileType.JPX, new JPXPolicy());
        this.policies.put(FileTypeBox.JPEG2000FileType.JPXB, new JPXPolicy());
        this.policies.put(FileTypeBox.JPEG2000FileType.UNSPECIFIED, new UnspecifiedPolicy());
        this.model = model;
    }

    int getChildIndex(JP2KBox parentBox, int boxType) {
        if (parentBox == null) {
            throw new IllegalArgumentException("Specified Parent box is null");
        }
        int numRootChildren = parentBox.getChildCount();
        for (int childN = 0; childN < numRootChildren; ++childN) {
            JP2KBox childBox;
            TreeNode childNode = parentBox.getChildAt(childN);
            if (childNode == null || !(childNode instanceof JP2KBox) || (childBox = (JP2KBox)parentBox.getChildAt(childN)).getType() != boxType) continue;
            return childN;
        }
        return -1;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        System.out.println(e.toString());
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (e == null) {
            return;
        }
        TreePath path = e.getTreePath();
        Object root = path.getLastPathComponent();
        if (!(root instanceof JP2KBox)) {
            throw new IllegalStateException("Node is not a jp2k node");
        }
        JP2KBox node = (JP2KBox)root;
        int[] childrenIndices = e.getChildIndices();
        Object[] children = e.getChildren();
        if (childrenIndices == null || children == null) {
            return;
        }
        List<? extends Throwable> exceptions = this.policies.get((Object)this.fileType).checkNodesInserted(node, childrenIndices, children);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            for (Throwable throwable : exceptions) {
                LOGGER.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new IllegalStateException("Check failed on this nodes insertion");
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        System.out.println(e.toString());
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        System.out.println(e.toString());
    }

    @Override
    public void checkTreeConsistency() {
        List<? extends Throwable> exceptions = this.policies.get((Object)this.fileType).checkTreeConsistency();
        if (LOGGER.isLoggable(Level.SEVERE)) {
            for (Throwable throwable : exceptions) {
                LOGGER.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new IllegalStateException("Check failed on tree consistency");
        }
    }

    class JP2Policy
    extends PolicyCheck {
        JP2Policy() {
        }

        @Override
        List<? extends Throwable> checkNodesInserted(JP2KBox node, int[] childrenIndices, Object[] children) {
            ArrayList<IllegalStateException> errors = new ArrayList<IllegalStateException>();
            Object root = JP2KTreeController.this.model.getRoot();
            if (root == null || !(root instanceof JP2KFileBox)) {
                throw new IllegalStateException("Root node unavailable");
            }
            JP2KFileBox fileBox = (JP2KFileBox)root;
            switch (node.getType()) {
                case 1: {
                    Object child;
                    int index;
                    int i;
                    if (childrenIndices.length >= 1 && children != null) {
                        block9: for (i = 0; i < childrenIndices.length; ++i) {
                            index = childrenIndices[i];
                            child = children[i];
                            if (child == null) continue;
                            JP2KBox candidate = (JP2KBox)child;
                            int childType = candidate.getType();
                            switch (childType) {
                                case 1785737832: {
                                    int contiguousCodestreamBoxIndex = JP2KTreeController.this.getChildIndex(node, 1785737827);
                                    if (contiguousCodestreamBoxIndex == -1 || contiguousCodestreamBoxIndex > index) continue block9;
                                    errors.add(new IllegalStateException("ContiguousCodestream Box must appear after the JP2Header Box"));
                                    continue block9;
                                }
                                case 1785737827: {
                                    int jp2HeaderBoxIndex = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HeaderBoxIndex == -1 || jp2HeaderBoxIndex < index) continue block9;
                                    errors.add(new IllegalStateException("JP2Header Box must appear before the ContiguousCodestream"));
                                    continue block9;
                                }
                                case 1785737833: {
                                    JP2KBox ihBox;
                                    ImageHeaderBox imageHeaderBox;
                                    JP2KBox jp2HeaderBox;
                                    int imageHeaderBoxIndex;
                                    int jp2HeaderIndex = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HeaderIndex == -1 || (imageHeaderBoxIndex = JP2KTreeController.this.getChildIndex(jp2HeaderBox = (JP2KBox)node.getChildAt(jp2HeaderIndex), 1768449138)) == -1 || (imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(ihBox = (JP2KBox)jp2HeaderBox.getChildAt(imageHeaderBoxIndex))).getIntellectualProperty() == 1) continue block9;
                                    errors.add(new IllegalStateException("IPRBox needs ImageHeaderBox's IP flag set to 1"));
                                }
                            }
                        }
                    }
                }
                case 1785737832: {
                    Object child;
                    int index;
                    int i;
                    if (childrenIndices.length < 1 || children == null) break;
                    for (i = 0; i < childrenIndices.length; ++i) {
                        index = childrenIndices[i];
                        child = children[i];
                        if (child == null) continue;
                        JP2KBox childBox = (JP2KBox)child;
                        int boxType = childBox.getType();
                        if (index == 0) {
                            int childBoxIndex;
                            byte bitDepth;
                            int childBoxIndex2;
                            if (boxType != 1768449138) {
                                throw new IllegalStateException("First box of a JP2 Header Box must be the ImageHeaderBox");
                            }
                            ImageHeaderBox imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(childBox);
                            byte ip = imageHeaderBox.getIntellectualProperty();
                            if (ip == 0 && (childBoxIndex2 = JP2KTreeController.this.getChildIndex(fileBox, 1785737833)) != -1) {
                                errors.add(new IllegalStateException("IntellectualProperty Box shall not be defined when ImageHeaderBox has IP=0"));
                            }
                            if ((bitDepth = imageHeaderBox.getBitDepth()) == 255 || (childBoxIndex = JP2KTreeController.this.getChildIndex(fileBox, 1651532643)) == -1) continue;
                            errors.add(new IllegalStateException("BitsPerComponent Box shall not be defined when ImageHeaderBox has BitDepth != 0xFF"));
                            continue;
                        }
                        if (boxType == 1651532643) {
                            JP2KBox ihBox;
                            ImageHeaderBox imageHeaderBox;
                            int imageHeaderBoxIndex = JP2KTreeController.this.getChildIndex(node, 1768449138);
                            if (imageHeaderBoxIndex == -1 || (imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(ihBox = (JP2KBox)node.getChildAt(imageHeaderBoxIndex))).getBitDepth() == 255) continue;
                            errors.add(new IllegalStateException("BitsPerComponent Box shall not be defined when ImageHeaderBox has BitDepth != 0xFF"));
                            continue;
                        }
                        if (boxType == 1668246642) {
                            ColorSpecificationBox csBox = (ColorSpecificationBox)LazyJP2KBox.getAsOriginalBox(childBox);
                            byte method = csBox.getMethod();
                            if (method == 1) {
                                int ecs;
                                if (csBox.getICCProfile() != null) {
                                    errors.add(new IllegalStateException("ColorSpecification Box with method = 1 should have a NULL ICP"));
                                }
                                if ((ecs = csBox.getEnumeratedColorSpace()) == 17 || ecs == 16 || ecs == 18) continue;
                                errors.add(new IllegalStateException("Unsupported Enumerated Color Space in ColorSpecification Box"));
                                continue;
                            }
                            if (method == 2) {
                                if (csBox.getEnumeratedColorSpace() == -1) continue;
                                errors.add(new IllegalStateException("ColorSpecification Box with method = 2 shouldn't have an Enumerated Color Space defined"));
                                continue;
                            }
                            errors.add(new IllegalStateException("ColorSpecification Box only supports value 1 and 2 for the M parameter"));
                            continue;
                        }
                        if (boxType != 1668112752 && boxType != 1919251232) continue;
                    }
                    break;
                }
            }
            if (errors.size() == 0) {
                return super.checkNodesInserted(node, childrenIndices, children);
            }
            return errors;
        }

        @Override
        List<? extends Throwable> checkTreeConsistency() {
            ArrayList<IllegalStateException> errors = new ArrayList<IllegalStateException>();
            Object root = JP2KTreeController.this.model.getRoot();
            if (root != null && root instanceof JP2KFileBox) {
                boolean signatureBoxOk = false;
                boolean fileTypeBoxOk = false;
                boolean jp2HeaderBoxIsPresent = false;
                boolean contiguousCodestreamBoxIsPresent = false;
                boolean iprBoxIsPresent = false;
                boolean iprBoxIsRequired = false;
                JP2KFileBox fileBox = (JP2KFileBox)root;
                int rootChildrenCount = fileBox.getChildCount();
                int jp2HeaderBoxIndex = -1;
                for (int i = 0; i < rootChildrenCount; ++i) {
                    JP2KBox child = (JP2KBox)fileBox.getChildAt(i);
                    int boxType = child.getType();
                    if (boxType == 1783636000) {
                        signatureBoxOk = true;
                        continue;
                    }
                    if (boxType == 1718909296) {
                        fileTypeBoxOk = true;
                        continue;
                    }
                    if (boxType == 1785737833) {
                        iprBoxIsPresent = true;
                        continue;
                    }
                    if (boxType == 1785737832) {
                        jp2HeaderBoxIsPresent = true;
                        jp2HeaderBoxIndex = i;
                        continue;
                    }
                    if (boxType != 1785737827) continue;
                    contiguousCodestreamBoxIsPresent = true;
                }
                if (!signatureBoxOk) {
                    errors.add(new IllegalStateException("Missing SignatureBox"));
                }
                if (!fileTypeBoxOk) {
                    errors.add(new IllegalStateException("Missing FileTypeBox"));
                }
                if (!jp2HeaderBoxIsPresent) {
                    errors.add(new IllegalStateException("Missing Jp2HeaderBox"));
                } else {
                    JP2KBox jp2header = (JP2KBox)fileBox.getChildAt(jp2HeaderBoxIndex);
                    int jp2HeaderChildrenCount = jp2header.getChildCount();
                    boolean imageHeaderBoxOk = false;
                    boolean bitsPerComponentBoxIsPresent = false;
                    boolean colorSpecificationBoxOk = false;
                    boolean paletteBoxIsPresent = false;
                    boolean componentMappingBoxIsPresent = false;
                    boolean resolutionBoxIsPresent = false;
                    boolean resolutionBoxIsOk = false;
                    int b = 0;
                    for (int k = 0; k < jp2HeaderChildrenCount; ++k) {
                        JP2KBox jp2HeaderChild = (JP2KBox)jp2header.getChildAt(k);
                        int childboxType = jp2HeaderChild.getType();
                        if (childboxType == 1768449138) {
                            imageHeaderBoxOk = true;
                            ImageHeaderBox imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(jp2HeaderChild);
                            b = imageHeaderBox.getBitDepth();
                            iprBoxIsRequired = imageHeaderBox.getIntellectualProperty() == 1;
                            continue;
                        }
                        if (childboxType == 1651532643) {
                            bitsPerComponentBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType == 1668246642) {
                            colorSpecificationBoxOk = true;
                            continue;
                        }
                        if (childboxType == 1885564018) {
                            paletteBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType == 1668112752) {
                            componentMappingBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType != 1919251232) continue;
                        resolutionBoxIsPresent = true;
                        resolutionBoxIsOk = jp2HeaderChild.getChildCount() > 0;
                    }
                    if (!imageHeaderBoxOk) {
                        errors.add(new IllegalStateException("Missing ImageHeaderBox"));
                    }
                    if (b != 255 && bitsPerComponentBoxIsPresent) {
                        errors.add(new IllegalStateException("BitsPerComponentBox shall not be defined when Bit-Depth in ImageHeaderBox is not 0xFF"));
                    }
                    if (!colorSpecificationBoxOk) {
                        errors.add(new IllegalStateException("Missing ColorSpecificationBox"));
                    }
                    if (resolutionBoxIsPresent && !resolutionBoxIsOk) {
                        errors.add(new IllegalStateException("ResolutionBox superbox doesn't contain any child"));
                    }
                    if (paletteBoxIsPresent ^ componentMappingBoxIsPresent) {
                        errors.add(new IllegalStateException("PaletteBox requires a ComponentMappingBox and viceversa"));
                    }
                }
                if (iprBoxIsRequired ^ iprBoxIsPresent) {
                    errors.add(new IllegalStateException("IPRBox is inconsistent with the ImageHeaderBox IP parameter"));
                }
                if (!contiguousCodestreamBoxIsPresent) {
                    errors.add(new IllegalStateException("ContiguousCodeStreamBox is missing"));
                }
            }
            if (errors.isEmpty()) {
                return Collections.emptyList();
            }
            return errors;
        }
    }

    class JPXPolicy
    extends PolicyCheck {
        JPXPolicy() {
        }

        @Override
        List<? extends Throwable> checkTreeConsistency() {
            ArrayList<IllegalStateException> errors = new ArrayList<IllegalStateException>();
            Object root = JP2KTreeController.this.model.getRoot();
            if (root != null && root instanceof JP2KFileBox) {
                boolean signatureBoxOk = false;
                boolean fileTypeBoxOk = false;
                boolean jp2HeaderBoxIsPresent = false;
                boolean readerRequirementsBoxIsPresent = false;
                boolean iprBoxIsPresent = false;
                boolean iprBoxIsRequired = false;
                boolean imageHeaderBoxIsPresent = false;
                int codestreamHeaderBoxes = 0;
                int numCodestreams = 0;
                int compositingLayerHeaderBoxes = 0;
                JP2KFileBox fileBox = (JP2KFileBox)root;
                int rootChildrenCount = fileBox.getChildCount();
                int jp2HeaderBoxIndex = -1;
                int firstCompositingLayerHeaderBoxIndex = -1;
                int firstCodestreamHeaderBoxIndex = -1;
                int firstCodestreamBoxIndex = -1;
                for (int i = 0; i < rootChildrenCount; ++i) {
                    JP2KBox child = (JP2KBox)fileBox.getChildAt(i);
                    int boxType = child.getType();
                    if (boxType == 1783636000) {
                        signatureBoxOk = true;
                        continue;
                    }
                    if (boxType == 1718909296) {
                        fileTypeBoxOk = true;
                        continue;
                    }
                    if (boxType == 1785737833) {
                        iprBoxIsPresent = true;
                        continue;
                    }
                    if (boxType == 1920099697) {
                        readerRequirementsBoxIsPresent = true;
                        continue;
                    }
                    if (boxType == 1785737832) {
                        jp2HeaderBoxIsPresent = true;
                        jp2HeaderBoxIndex = i;
                        continue;
                    }
                    if (boxType == 1785752680) {
                        if (firstCompositingLayerHeaderBoxIndex == -1) {
                            firstCompositingLayerHeaderBoxIndex = i;
                        }
                        ++compositingLayerHeaderBoxes;
                        continue;
                    }
                    if (boxType == 1785750376) {
                        if (firstCodestreamHeaderBoxIndex == -1) {
                            firstCodestreamHeaderBoxIndex = i;
                        }
                        ++codestreamHeaderBoxes;
                        continue;
                    }
                    if (boxType != 1785737827) continue;
                    if (firstCodestreamBoxIndex == -1) {
                        firstCodestreamBoxIndex = i;
                    }
                    ++numCodestreams;
                }
                if (!signatureBoxOk) {
                    errors.add(new IllegalStateException("Missing SignatureBox"));
                }
                if (!readerRequirementsBoxIsPresent) {
                    errors.add(new IllegalStateException("Missing ReaderRequirementsBox"));
                }
                if (!fileTypeBoxOk) {
                    errors.add(new IllegalStateException("Missing FileTypeBox"));
                }
                if (!jp2HeaderBoxIsPresent) {
                    if (firstCodestreamHeaderBoxIndex != -1) {
                        JP2KBox codestreamHeaderBox = (JP2KBox)fileBox.getChildAt(firstCodestreamHeaderBoxIndex);
                        int codestreamChildrenCount = fileBox.getChildCount();
                        for (int i = 0; i < codestreamChildrenCount; ++i) {
                            JP2KBox child = (JP2KBox)codestreamHeaderBox.getChildAt(i);
                            int boxType = child.getType();
                            if (boxType != 1768449138) continue;
                            imageHeaderBoxIsPresent = true;
                            break;
                        }
                    } else {
                        errors.add(new IllegalStateException("Missing both JP2HeaderBox and CodeStreamHeaderBox"));
                    }
                    if (firstCompositingLayerHeaderBoxIndex != -1) {
                        // empty if block
                    }
                } else {
                    JP2KBox jp2header = (JP2KBox)fileBox.getChildAt(jp2HeaderBoxIndex);
                    int jp2HeaderChildrenCount = jp2header.getChildCount();
                    boolean bitsPerComponentBoxIsPresent = false;
                    boolean colourSpecificationBoxOk = false;
                    boolean paletteBoxIsPresent = false;
                    boolean componentMappingBoxIsPresent = false;
                    boolean resolutionBoxIsPresent = false;
                    boolean resolutionBoxIsOk = false;
                    int b = 0;
                    for (int k = 0; k < jp2HeaderChildrenCount; ++k) {
                        JP2KBox jp2HeaderChild = (JP2KBox)jp2header.getChildAt(k);
                        int childboxType = jp2HeaderChild.getType();
                        if (childboxType == 1768449138) {
                            imageHeaderBoxIsPresent = true;
                            ImageHeaderBox imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(jp2HeaderChild);
                            b = imageHeaderBox.getBitDepth();
                            iprBoxIsRequired = imageHeaderBox.getIntellectualProperty() == 1;
                            continue;
                        }
                        if (childboxType == 1651532643) {
                            bitsPerComponentBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType == 1668246642) {
                            colourSpecificationBoxOk = true;
                            continue;
                        }
                        if (childboxType == 1885564018) {
                            paletteBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType == 1668112752) {
                            componentMappingBoxIsPresent = true;
                            continue;
                        }
                        if (childboxType != 1919251232) continue;
                        resolutionBoxIsPresent = true;
                        resolutionBoxIsOk = jp2HeaderChild.getChildCount() > 0;
                    }
                    if (b != 255 && bitsPerComponentBoxIsPresent) {
                        errors.add(new IllegalStateException("BitsPerComponentBox shall not be defined when Bit-Depth in ImageHeaderBox is not 0xFF"));
                    }
                    if (!colourSpecificationBoxOk) {
                        errors.add(new IllegalStateException("Missing ColorSpecificationBox"));
                    }
                    if (resolutionBoxIsPresent && !resolutionBoxIsOk) {
                        errors.add(new IllegalStateException("ResolutionBox superbox doesn't contain any child"));
                    }
                    if (paletteBoxIsPresent ^ componentMappingBoxIsPresent) {
                        errors.add(new IllegalStateException("PaletteBox requires a ComponentMappingBox and viceversa"));
                    }
                }
                if (jp2HeaderBoxIsPresent) {
                    if (firstCodestreamHeaderBoxIndex != -1 && jp2HeaderBoxIndex >= firstCodestreamHeaderBoxIndex) {
                        errors.add(new IllegalStateException("CodestreamHeader Box must appear after the JP2Header Box"));
                    }
                    if (firstCompositingLayerHeaderBoxIndex != -1 && jp2HeaderBoxIndex >= firstCompositingLayerHeaderBoxIndex) {
                        errors.add(new IllegalStateException("CompositingLayerHeader Box must appear after the JP2Header Box"));
                    }
                    if (firstCodestreamBoxIndex != -1 && jp2HeaderBoxIndex >= firstCodestreamBoxIndex) {
                        errors.add(new IllegalStateException("Codestream Box must appear after the JP2Header Box"));
                    }
                }
                if (!imageHeaderBoxIsPresent) {
                    errors.add(new IllegalStateException("Missing ImageHeaderBox"));
                }
                if (iprBoxIsRequired ^ iprBoxIsPresent) {
                    errors.add(new IllegalStateException("IPRBox is inconsistent with the ImageHeaderBox IP parameter"));
                }
                if (codestreamHeaderBoxes != 0 && codestreamHeaderBoxes != numCodestreams) {
                    errors.add(new IllegalStateException("The number of codestreams and codestreamHeaderBox shall match"));
                }
            }
            if (errors.isEmpty()) {
                return Collections.emptyList();
            }
            return errors;
        }

        @Override
        List<? extends Throwable> checkNodesInserted(JP2KBox node, int[] childrenIndices, Object[] children) {
            ArrayList<IllegalStateException> errors = new ArrayList<IllegalStateException>();
            Object root = JP2KTreeController.this.model.getRoot();
            if (root == null || !(root instanceof JP2KFileBox)) {
                throw new IllegalStateException("Root node unavailable");
            }
            JP2KFileBox fileBox = (JP2KFileBox)root;
            switch (node.getType()) {
                case 1: {
                    Object child;
                    int index;
                    int i;
                    if (childrenIndices.length >= 1 && children != null) {
                        block12: for (i = 0; i < childrenIndices.length; ++i) {
                            index = childrenIndices[i];
                            child = children[i];
                            if (child == null) continue;
                            JP2KBox candidate = (JP2KBox)child;
                            int childType = candidate.getType();
                            switch (childType) {
                                case 1920099697: {
                                    int fileTypeBoxIndex = JP2KTreeController.this.getChildIndex(node, 1718909296);
                                    if (fileTypeBoxIndex != -1 && fileTypeBoxIndex >= index) {
                                        errors.add(new IllegalStateException("ReaderRequirements Box must appear after the FileType Box"));
                                    }
                                    ReaderRequirementsBox rreqbox = (ReaderRequirementsBox)LazyJP2KBox.getAsOriginalBox(candidate);
                                    continue block12;
                                }
                                case 1785737832: {
                                    int compositingLayerHeaderBox;
                                    int codestreamHeaderBoxIndex;
                                    int contiguousCodestreamBoxIndex = JP2KTreeController.this.getChildIndex(node, 1785737827);
                                    if (contiguousCodestreamBoxIndex != -1 && contiguousCodestreamBoxIndex <= index) {
                                        errors.add(new IllegalStateException("ContiguousCodestream Box must appear after the JP2Header Box"));
                                    }
                                    if ((codestreamHeaderBoxIndex = JP2KTreeController.this.getChildIndex(node, 1785750376)) != -1 && codestreamHeaderBoxIndex <= index) {
                                        errors.add(new IllegalStateException("CodestreamHeader Box must appear after the JP2Header Box"));
                                    }
                                    if ((compositingLayerHeaderBox = JP2KTreeController.this.getChildIndex(node, 1785752680)) == -1 || compositingLayerHeaderBox > index) continue block12;
                                    errors.add(new IllegalStateException("CompositingLayerHeader Box must appear after the JP2Header Box"));
                                    continue block12;
                                }
                                case 1785752680: {
                                    int jp2HBoxIndex = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HBoxIndex == -1 || jp2HBoxIndex < index) continue block12;
                                    errors.add(new IllegalStateException("CompositingLayerHeader Box must appear after the JP2Header Box"));
                                    continue block12;
                                }
                                case 1785750376: {
                                    int jp2HBoxIndex1 = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HBoxIndex1 == -1 || jp2HBoxIndex1 < index) continue block12;
                                    errors.add(new IllegalStateException("CodestreamHeader Box must appear after the JP2Header Box"));
                                    continue block12;
                                }
                                case 1785737827: {
                                    int jp2HBoxIndex2 = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HBoxIndex2 == -1 || jp2HBoxIndex2 < index) continue block12;
                                    errors.add(new IllegalStateException("JP2Header Box must appear before the ContiguousCodestream"));
                                    continue block12;
                                }
                                case 1785737833: {
                                    JP2KBox ihBox;
                                    ImageHeaderBox imageHeaderBox;
                                    JP2KBox jp2HeaderBox;
                                    int imageHeaderBoxIndex;
                                    int jp2HeaderIndex = JP2KTreeController.this.getChildIndex(node, 1785737832);
                                    if (jp2HeaderIndex == -1 || (imageHeaderBoxIndex = JP2KTreeController.this.getChildIndex(jp2HeaderBox = (JP2KBox)node.getChildAt(jp2HeaderIndex), 1768449138)) == -1 || (imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(ihBox = (JP2KBox)jp2HeaderBox.getChildAt(imageHeaderBoxIndex))).getIntellectualProperty() == 1) continue block12;
                                    errors.add(new IllegalStateException("IPRBox needs ImageHeaderBox's IP flag set to 1"));
                                }
                            }
                        }
                    }
                }
                case 1785737832: {
                    Object child;
                    int index;
                    int i;
                    if (childrenIndices.length < 1 || children == null) break;
                    for (i = 0; i < childrenIndices.length; ++i) {
                        index = childrenIndices[i];
                        child = children[i];
                        if (child == null) continue;
                        JP2KBox childBox = (JP2KBox)child;
                        int boxType = childBox.getType();
                        if (index == 0) {
                            int childBoxIndex;
                            byte bitDepth;
                            int childBoxIndex2;
                            if (boxType != 1768449138) {
                                throw new IllegalStateException("First box of a JP2 Header Box must be the ImageHeaderBox");
                            }
                            ImageHeaderBox imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(childBox);
                            byte ip = imageHeaderBox.getIntellectualProperty();
                            if (ip == 0 && (childBoxIndex2 = JP2KTreeController.this.getChildIndex(fileBox, 1785737833)) != -1) {
                                errors.add(new IllegalStateException("IntellectualProperty Box shall not be defined when ImageHeaderBox has IP=0"));
                            }
                            if ((bitDepth = imageHeaderBox.getBitDepth()) == 255 || (childBoxIndex = JP2KTreeController.this.getChildIndex(fileBox, 1651532643)) == -1) continue;
                            errors.add(new IllegalStateException("BitsPerComponent Box shall not be defined when ImageHeaderBox has BitDepth != 0xFF"));
                            continue;
                        }
                        if (boxType == 1651532643) {
                            JP2KBox ihBox;
                            ImageHeaderBox imageHeaderBox;
                            int imageHeaderBoxIndex = JP2KTreeController.this.getChildIndex(node, 1768449138);
                            if (imageHeaderBoxIndex == -1 || (imageHeaderBox = (ImageHeaderBox)LazyJP2KBox.getAsOriginalBox(ihBox = (JP2KBox)node.getChildAt(imageHeaderBoxIndex))).getBitDepth() == 255) continue;
                            errors.add(new IllegalStateException("BitsPerComponent Box shall not be defined when ImageHeaderBox has BitDepth != 0xFF"));
                            continue;
                        }
                        if (boxType == 1668246642) {
                            ColorSpecificationBox csBox = (ColorSpecificationBox)LazyJP2KBox.getAsOriginalBox(childBox);
                            byte method = csBox.getMethod();
                            if (method == 1) {
                                int ecs;
                                if (csBox.getICCProfile() != null) {
                                    errors.add(new IllegalStateException("ColorSpecification Box with method = 1 should have a NULL ICP"));
                                }
                                if ((ecs = csBox.getEnumeratedColorSpace()) == 17 || ecs == 16 || ecs == 18) continue;
                                errors.add(new IllegalStateException("Unsupported Enumerated Color Space in ColorSpecification Box"));
                                continue;
                            }
                            if (method == 2) {
                                if (csBox.getEnumeratedColorSpace() == -1) continue;
                                errors.add(new IllegalStateException("ColorSpecification Box with method = 2 shouldn't have an Enumerated Color Space defined"));
                                continue;
                            }
                            errors.add(new IllegalStateException("ColorSpecification Box only supports value 1 and 2 for the M parameter"));
                            continue;
                        }
                        if (boxType != 1668112752 && boxType != 1919251232) continue;
                    }
                    break;
                }
            }
            if (errors.size() == 0) {
                return super.checkNodesInserted(node, childrenIndices, children);
            }
            return errors;
        }
    }

    class UnspecifiedPolicy
    extends PolicyCheck {
        UnspecifiedPolicy() {
        }

        @Override
        List<? extends Throwable> checkNodesInserted(JP2KBox node, int[] childrenIndices, Object[] children) {
            switch (node.getType()) {
                case 1: {
                    if (childrenIndices.length < 1 || children == null) break;
                    for (int i = 0; i < childrenIndices.length; ++i) {
                        int index = childrenIndices[i];
                        Object child = children[i];
                        if (child == null) continue;
                        switch (index) {
                            case 0: {
                                JP2KBox signature = (JP2KBox)child;
                                if (signature.getType() != 1783636000) {
                                    return Arrays.asList(new IllegalStateException("First box of a JPEG2000 file must be the SignatureBox"));
                                }
                                byte[] expectedContent = SignatureBox.LOCAL_DATA;
                                byte[] content = signature.getContent();
                                if (expectedContent.length != content.length) {
                                    return Arrays.asList(new IllegalStateException("SignatureBox content incorrect"));
                                }
                                for (int j = 0; j < expectedContent.length; ++j) {
                                    if (expectedContent[j] == content[j]) continue;
                                    return Arrays.asList(new IllegalStateException("SignatureBox content incorrect"));
                                }
                                return super.checkNodesInserted(node, childrenIndices, children);
                            }
                            case 1: {
                                JP2KBox box = (JP2KBox)child;
                                if (box.getType() != 1718909296) {
                                    return Arrays.asList(new IllegalStateException("Second box of a JPEG2000 file must be the FileTypeBox"));
                                }
                                if (box instanceof LazyJP2KBox) {
                                    box = ((LazyJP2KBox)box).getOriginalBox();
                                }
                                JP2KTreeController.this.fileType = ((FileTypeBox)box).getBrand();
                                JP2KTreeController.this.compatibilitySet = ((FileTypeBox)box).getCompatibilitySet();
                                if (!JP2KTreeController.this.compatibilitySet.contains((Object)FileTypeBox.JPEG2000FileType.JP2)) {
                                    return Arrays.asList(new IllegalStateException("We are only able to serve JP2 compatible files"));
                                }
                                return super.checkNodesInserted(node, childrenIndices, children);
                            }
                        }
                    }
                    break;
                }
            }
            return Arrays.asList(new IllegalStateException("This node should not be inserted while the file type is still unspecified"));
        }
    }

    abstract class PolicyCheck {
        PolicyCheck() {
        }

        List<? extends Throwable> checkNodesInserted(JP2KBox node, int[] childrenIndices, Object[] children) {
            return Collections.emptyList();
        }

        List<? extends Throwable> checkTreeConsistency() {
            return Collections.emptyList();
        }
    }

    public final class MultiCauseIllegalStateException
    extends IllegalStateException {
        private static final long serialVersionUID = 8965184317402766015L;
        private ArrayList<Throwable> causes;

        public MultiCauseIllegalStateException(String message, Collection<Throwable> causes) {
            super(message, JP2KTreeController.checkCauses(causes));
            this.causes = new ArrayList<Throwable>(causes);
        }

        public MultiCauseIllegalStateException(Collection<Throwable> causes) {
            super(JP2KTreeController.checkCauses(causes));
            this.causes = new ArrayList<Throwable>(causes);
        }

        public List<Throwable> getCauses() {
            return Collections.unmodifiableList(this.causes);
        }
    }
}

