/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.ComponentMappingBox;
import javax.imageio.metadata.IIOMetadataNode;

public class ComponentMappingBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private int nComponents;
    private String[] component;
    private String[] type;
    private String[] map;

    public ComponentMappingBoxMetadataNode(ComponentMappingBox box) {
        super(box);
        short[] comps = box.getComponent();
        byte[] types = box.getComponentType();
        byte[] assoc = box.getComponentAssociation();
        this.nComponents = comps.length;
        this.component = new String[this.nComponents];
        this.type = new String[this.nComponents];
        this.map = new String[this.nComponents];
        for (int i = 0; i < this.nComponents; ++i) {
            IIOMetadataNode child = new IIOMetadataNode("Component");
            child.setUserObject(new Short(comps[i]));
            this.component[i] = Short.toString(comps[i]);
            child.setNodeValue(this.component[i]);
            this.appendChild(child);
            child = new IIOMetadataNode("ComponentType");
            child.setUserObject(new Byte(types[i]));
            this.type[i] = Byte.toString(types[i]);
            child.setNodeValue(this.type[i]);
            this.appendChild(child);
            child = new IIOMetadataNode("ComponentAssociation");
            this.map[i] = Byte.toString(assoc[i]);
            child.setUserObject(new Byte(assoc[i]));
            child.setNodeValue(this.map[i]);
            this.appendChild(child);
        }
    }

    public String getComponentType(int index) {
        if (index > this.nComponents - 1) {
            throw new IllegalArgumentException("Number of Component is " + this.nComponents);
        }
        return this.type[index];
    }

    public String getComponentAssociation(int index) {
        if (index > this.nComponents - 1) {
            throw new IllegalArgumentException("Number of Component is " + this.nComponents);
        }
        return this.map[index];
    }

    public String getComponent(int index) {
        if (index > this.nComponents - 1) {
            throw new IllegalArgumentException("Number of Component is " + this.nComponents);
        }
        return this.component[index];
    }
}

