/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageIOUtils {
    private static final Log log = LogFactory.getLog(ImageIOUtils.class);

    private ImageIOUtils() {
    }

    public static ImageReader getImageReader(String filename) throws IOException {
        return ImageIOUtils.getImageReader(new File(filename));
    }

    public static ImageReader getImageReader(File file) throws IOException {
        String ext = FilenameUtils.getExtension((String)file.getName().toLowerCase());
        ImageReader reader = null;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersBySuffix(ext);
        if (imageReaders.hasNext()) {
            reader = imageReaders.next();
            ImageInputStream stream = ImageIO.createImageInputStream(file);
            reader.setInput(stream);
        }
        return reader;
    }

    public static ImageReader getImageReader(String format, Object input) throws IOException {
        ImageReader reader = null;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByFormatName(format);
        if (imageReaders.hasNext()) {
            reader = imageReaders.next();
            reader.setInput(input);
        }
        return reader;
    }

    public static ImageWriter getImageWriter(String filename) throws IOException {
        return ImageIOUtils.getImageWriter(new File(filename));
    }

    public static ImageWriter getImageWriter(File file) throws IOException {
        String ext = FilenameUtils.getExtension((String)file.getName().toLowerCase());
        ImageWriter writer = null;
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersBySuffix(ext);
        if (imageWriters.hasNext()) {
            writer = imageWriters.next();
            ImageOutputStream stream = ImageIO.createImageOutputStream(file);
            writer.setOutput(stream);
        }
        return writer;
    }

    public static String getPackageName(Class clazz) {
        return FilenameUtils.removeExtension((String)clazz.getCanonicalName());
    }

    public static boolean canDisplay(BufferedImage image) {
        log.info((Object)("Data Type: " + image.getSampleModel().getDataType()));
        log.info((Object)("Pixel Size: " + image.getColorModel().getPixelSize()));
        if (image.getSampleModel().getDataType() == 4 && image.getColorModel().getPixelSize() == 64) {
            return false;
        }
        return !GraphicsEnvironment.isHeadless();
    }

    public static List<File> getFiles(String[] filesOrDirs, String[] extensions) {
        ArrayList<File> files = new ArrayList<File>();
        final String[] exts = extensions;
        for (int i = 0; i < filesOrDirs.length; ++i) {
            String arg = filesOrDirs[i];
            File file = new File(arg);
            if (file.isDirectory() && file.exists()) {
                files.addAll(Arrays.asList(file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return ArrayUtils.contains((Object[])exts, (Object)FilenameUtils.getExtension((String)name.toLowerCase()));
                    }
                })));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public static JFrame showImage(BufferedImage image, String title) {
        return ImageIOUtils.showImage(image, title, true);
    }

    public static JFrame showImage(BufferedImage image, String title, boolean fitToScreen) {
        JFrame frame = new JFrame(title != null ? title : "");
        frame.setDefaultCloseOperation(2);
        Image im = image;
        if (fitToScreen) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int imageHeight = image.getHeight();
            int imageWidth = image.getWidth();
            if (imageHeight > screen.height || imageWidth > screen.width) {
                double hRatio = (imageHeight - screen.height) / screen.height;
                double wRatio = (imageWidth - screen.width) / screen.width;
                int w = -1;
                int h = -1;
                if (hRatio > wRatio) {
                    h = screen.height;
                } else {
                    w = screen.width;
                }
                im = image.getScaledInstance(w, h, 1);
            }
        }
        JLabel label = new JLabel(new ImageIcon(im));
        frame.getContentPane().add((Component)label, "Center");
        frame.pack();
        ImageIOUtils.centerWindow(frame);
        frame.setVisible(true);
        return frame;
    }

    public static void centerWindow(Window w) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = w.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screen.width / 2 - window.width / 2;
        int top = (screen.height - window.height) / 4;
        if (top < 0) {
            top = 0;
        }
        w.setLocation(left, top);
    }

    public static ColorModel createGrayscaleColorModel(boolean invert) {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        if (invert) {
            for (int i = 0; i < 256; ++i) {
                rLUT[255 - i] = (byte)i;
                gLUT[255 - i] = (byte)i;
                bLUT[255 - i] = (byte)i;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
            }
        }
        return new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }

    public static float[] findMinAndMax(float[] buffer, int pixelStride, int numBands) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < buffer.length; i += numBands) {
            for (int j = 0; j < pixelStride; ++j) {
                float value = buffer[i + j];
                if (Float.isInfinite(value)) continue;
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        return new float[]{min, max};
    }

    public static double[] findMinAndMax(double[] buffer, int pixelStride, int numBands) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < buffer.length; i += numBands) {
            for (int j = 0; j < pixelStride; ++j) {
                double value = buffer[i + j];
                if (Double.isInfinite(value)) continue;
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        return new double[]{min, max};
    }

    public static int[] findMinAndMax(short[] buffer, int pixelStride, int numBands) {
        int min = 65535;
        int max = 0;
        for (int i = 0; i < buffer.length; i += numBands) {
            for (int j = 0; j < pixelStride; ++j) {
                int value = buffer[i + j];
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
        }
        return new int[]{min, max};
    }

    public static WritableRaster makeGenericBandedWritableRaster(int numElems, int numLines, int numBands, int dataType) {
        int[] bandOffsets = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bandOffsets[i] = i;
        }
        DataBuffer d = null;
        if (dataType == 0) {
            d = new DataBufferByte(numElems * numLines * numBands);
        } else if (dataType == 4) {
            d = new DataBufferFloat(numElems * numLines * numBands);
        } else {
            throw new IllegalArgumentException("Invalid datatype: " + dataType);
        }
        BandedSampleModel bsm = new BandedSampleModel(dataType, numElems, numLines, bandOffsets.length, bandOffsets, bandOffsets);
        WritableRaster ras = Raster.createWritableRaster(bsm, d, new Point(0, 0));
        return ras;
    }

    public static WritableRaster makeGenericPixelInterleavedWritableRaster(int numElems, int numLines, int numBands, int dataType) {
        int[] bandOffsets = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bandOffsets[i] = i;
        }
        DataBuffer d = null;
        if (dataType == 0) {
            d = new DataBufferByte(numElems * numLines * numBands);
        } else if (dataType == 2) {
            d = new DataBufferShort(numElems * numLines * numBands);
        } else if (dataType == 1) {
            d = new DataBufferUShort(numElems * numLines * numBands);
        } else if (dataType == 4) {
            d = new DataBufferFloat(numElems * numLines * numBands);
        } else if (dataType == 5) {
            d = new DataBufferDouble(numElems * numLines * numBands);
        } else {
            throw new IllegalArgumentException("Invalid datatype: " + dataType);
        }
        PixelInterleavedSampleModel pism = new PixelInterleavedSampleModel(dataType, numElems, numLines, bandOffsets.length, numElems * bandOffsets.length, bandOffsets);
        WritableRaster ras = Raster.createWritableRaster(pism, d, new Point(0, 0));
        return ras;
    }

    public static void floatToByteBuffer(float[] floatData, byte[] byteData, int pixelStride, int numBands) {
        float[] minMax = ImageIOUtils.findMinAndMax(floatData, pixelStride, numBands);
        float scale = 255.0f / (minMax[1] - minMax[0]);
        int i = 0;
        int j = 0;
        while (i < floatData.length) {
            int iVal;
            float val = floatData[i] - minMax[0];
            if (val < 0.0f) {
                val = 0.0f;
            }
            if ((iVal = (int)(val * scale)) > 255) {
                iVal = 255;
            }
            byteData[j] = (byte)iVal;
            i += numBands;
            ++j;
        }
    }

    public static void doubleToByteBuffer(double[] doubleData, byte[] byteData, int pixelStride, int numBands) {
        double[] minMax = ImageIOUtils.findMinAndMax(doubleData, pixelStride, numBands);
        double scale = 255.0 / (minMax[1] - minMax[0]);
        int i = 0;
        int j = 0;
        while (i < doubleData.length) {
            int iVal;
            double val = doubleData[i] - minMax[0];
            if (val < 0.0) {
                val = 0.0;
            }
            if ((iVal = (int)(val * scale)) > 255) {
                iVal = 255;
            }
            byteData[j] = (byte)iVal;
            i += numBands;
            ++j;
        }
    }

    public static void shortToByteBuffer(short[] shortData, byte[] byteData, int pixelStride, int numBands) {
        int[] minMax = ImageIOUtils.findMinAndMax(shortData, pixelStride, numBands);
        double scale = 1.0;
        if (minMax[1] != minMax[0]) {
            scale = 256.0 / (double)(minMax[1] - minMax[0]);
        }
        int i = 0;
        int j = 0;
        while (i < shortData.length) {
            int value = (shortData[i] & 0xFFFF) - minMax[0];
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * scale)) > 255) {
                value = 255;
            }
            byteData[j] = (byte)value;
            i += numBands;
            ++j;
        }
    }

    public static BufferedImage rasterToBufferedImage(Raster raster, ImageTypeSpecifier imageType) {
        if (imageType == null) {
            if (raster.getDataBuffer().getDataType() == 0) {
                imageType = ImageTypeSpecifier.createGrayscale(8, 0, false);
            } else {
                throw new IllegalArgumentException("unable to dynamically determine the imageType");
            }
        }
        BufferedImage bufImage = imageType.createBufferedImage(raster.getWidth(), raster.getHeight());
        if (raster.getDataBuffer().getDataType() == 1 && bufImage.getRaster().getDataBuffer().getDataType() == 0) {
            short[] shortData = ((DataBufferUShort)raster.getDataBuffer()).getData();
            byte[] byteData = ((DataBufferByte)bufImage.getWritableTile(0, 0).getDataBuffer()).getData();
            ImageIOUtils.shortToByteBuffer(shortData, byteData, 1, raster.getNumBands());
        } else if (raster.getDataBuffer().getDataType() == 4 && bufImage.getRaster().getDataBuffer().getDataType() == 0) {
            float[] floatData = ((DataBufferFloat)raster.getDataBuffer()).getData();
            byte[] byteData = ((DataBufferByte)bufImage.getWritableTile(0, 0).getDataBuffer()).getData();
            ImageIOUtils.floatToByteBuffer(floatData, byteData, 1, raster.getNumBands());
        } else if (raster.getDataBuffer().getDataType() == 5 && bufImage.getRaster().getDataBuffer().getDataType() == 0) {
            double[] doubleData = ((DataBufferDouble)raster.getDataBuffer()).getData();
            byte[] byteData = ((DataBufferByte)bufImage.getWritableTile(0, 0).getDataBuffer()).getData();
            ImageIOUtils.doubleToByteBuffer(doubleData, byteData, 1, raster.getNumBands());
        } else if (raster.getDataBuffer().getDataType() == 0 && bufImage.getRaster().getDataBuffer().getDataType() == 0 || raster.getDataBuffer().getDataType() == 1 && bufImage.getRaster().getDataBuffer().getDataType() == 1 || raster.getDataBuffer().getDataType() == 2 && bufImage.getRaster().getDataBuffer().getDataType() == 2) {
            bufImage.setData(raster);
        } else {
            throw new UnsupportedOperationException("Unable to convert raster type to bufferedImage type: " + raster.getDataBuffer().getDataType() + " ==> " + bufImage.getRaster().getDataBuffer().getDataType());
        }
        return bufImage;
    }

    public static int makeUnsigned(byte b) {
        return b >= 0 ? b : 255 + b + 1;
    }

    public static void main(String[] args) {
        List<File> files = ImageIOUtils.getFiles(new String[]{"c:/", "c:/dev/"}, new String[]{"jpg"});
        for (File file : files) {
            log.info((Object)file.getAbsolutePath());
        }
    }
}

