/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.stream.AccessibleStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import nitf.IOInterface;
import nitf.NITFException;

public class IOFileInputStream
extends IOInterface {
    private ImageInputStream stream;
    private File file;
    long size = 0L;

    public IOFileInputStream(ImageInputStream stream) {
        this.stream = stream;
        this.file = (File)((AccessibleStream)stream).getTarget();
        this.size = this.file.length();
    }

    public void read(byte[] buf) throws NITFException {
        try {
            this.stream.read(buf);
        }
        catch (IOException e) {
            throw new NITFException((Throwable)e);
        }
    }

    public byte[] read(int size) throws NITFException {
        byte[] b = new byte[size];
        this.read(b);
        return b;
    }

    public void close() throws NITFException {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new NITFException((Throwable)e);
        }
    }

    public long getSize() throws NITFException {
        return this.size;
    }

    public int getMode() throws NITFException {
        return 1;
    }

    public void read(byte[] buf, int size) throws NITFException {
        try {
            this.stream.read(buf, 0, size);
        }
        catch (IOException e) {
            throw new NITFException((Throwable)e);
        }
    }

    public boolean canSeek() {
        return true;
    }

    public long seek(long offset, int whence) throws NITFException {
        try {
            long pos = this.stream.getStreamPosition();
            switch (whence) {
                case 10: {
                    if (offset + pos > this.size) {
                        throw new NITFException("Attempting to seek past buffer boundary.");
                    }
                    this.stream.seek((int)(pos + offset));
                    break;
                }
                case 30: {
                    throw new NITFException("SEEK_END is unsupported with MemoryIO.");
                }
                case 20: {
                    if (offset > this.size) {
                        throw new NITFException("Attempting to seek past buffer boundary.");
                    }
                    this.stream.seek((int)offset);
                }
            }
            return this.stream.getStreamPosition();
        }
        catch (IOException ioe) {
            throw new NITFException((Throwable)ioe);
        }
    }

    public long tell() throws NITFException {
        try {
            return this.stream.getStreamPosition();
        }
        catch (IOException e) {
            throw new NITFException((Throwable)e);
        }
    }

    public void write(byte[] buf, int size) throws NITFException {
        throw new UnsupportedOperationException();
    }
}

