/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.plugins.netcdf.NetCDFConverterUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class INGVConverter {
    private static String[] depthNames = new String[]{"depth", "deptht", "depthu", "depthv", "depthw"};
    public final String NAV_LON = "nav_lon";
    public final String NAV_LAT = "nav_lat";
    private static final ArrayList<String> VARIABLES = new ArrayList(7);
    private static final String fileNameIn = "E:\\Work\\data\\rixen\\lsvc08\\UNIBO\\HOPS2\\20080929\\HOPS1km_H_080929_T.nc";
    private static final String fileNameOut = "E:/work/data/rixen/converted/converted_HOPS1km_H_080929_T.nc";
    static final int NUMVARS;

    public static void main(String[] args) throws IOException {
        INGVConverter converter = new INGVConverter();
        String fileNameIn = fileNameIn;
        String fileNameOut = fileNameOut;
        converter.run(fileNameIn, fileNameOut);
    }

    private void run(String fileNameIn, String fileNameOut) {
        block26: {
            try {
                File fileIn = new File(fileNameIn);
                NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
                File fileOut = new File(fileNameOut);
                File outputFile = File.createTempFile(fileIn.getName(), ".tmp");
                NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)outputFile.getAbsolutePath());
                boolean hasDepth = false;
                String timeName = "time_counter";
                Dimension timeOriginalDim = ncFileIn.findDimension(timeName);
                if (timeOriginalDim == null) {
                    timeOriginalDim = ncFileIn.findDimension("time");
                    timeName = "time";
                }
                Dimension yDim = ncFileIn.findDimension("y");
                Dimension xDim = ncFileIn.findDimension("x");
                Variable timeOriginalVar = ncFileIn.findVariable(timeName);
                Array timeOriginalData = timeOriginalVar.read();
                DataType timeDataType = timeOriginalVar.getDataType();
                Variable navLat = ncFileIn.findVariable("nav_lat");
                DataType navLatDataType = navLat.getDataType();
                Variable navLon = ncFileIn.findVariable("nav_lon");
                DataType navLonDataType = navLon.getDataType();
                int nLat = yDim.getLength();
                int nLon = xDim.getLength();
                int nTimes = timeOriginalDim.getLength();
                Array latOriginalData = navLat.read("0:" + (nLat - 1) + ":1, 0:0:1").reduce();
                Array lonOriginalData = navLon.read("0:0:1, 0:" + (nLon - 1) + ":1").reduce();
                Array depthOriginalData = null;
                DataType depthDataType = null;
                int nDepths = 0;
                Array depthDestData = null;
                Dimension depthDim = null;
                String depthName = "depth";
                Variable depthOriginalVar = null;
                int dName = 0;
                while (depthOriginalVar == null && dName != depthNames.length) {
                    String name = depthNames[dName++];
                    depthOriginalVar = ncFileIn.findVariable(name);
                }
                if (depthOriginalVar != null) {
                    depthName = depthNames[dName - 1];
                    nDepths = depthOriginalVar.getDimension(0).getLength();
                    depthOriginalData = depthOriginalVar.read();
                    hasDepth = true;
                }
                Dimension timeDim = ncFileOut.addDimension("time", nTimes);
                Dimension latDim = ncFileOut.addDimension("lat", nLat);
                Dimension lonDim = ncFileOut.addDimension("lon", nLon);
                if (hasDepth) {
                    depthDim = ncFileOut.addDimension("depth", nDepths);
                }
                NetCDFConverterUtilities.copyGlobalAttributes(ncFileOut, ncFileIn.getGlobalAttributes());
                Variable timeVar = ncFileOut.addVariable("time", timeDataType, new Dimension[]{timeDim});
                NetCDFConverterUtilities.setVariableAttributes(timeOriginalVar, ncFileOut, "time");
                ncFileOut.addVariable("lat", navLatDataType, new Dimension[]{latDim});
                NetCDFConverterUtilities.setVariableAttributes(navLat, ncFileOut, "lat");
                ncFileOut.addVariable("lon", navLonDataType, new Dimension[]{lonDim});
                NetCDFConverterUtilities.setVariableAttributes(navLon, ncFileOut, "lon");
                Array lat1Data = NetCDFConverterUtilities.getArray(nLat, navLatDataType);
                NetCDFConverterUtilities.setData1D(latOriginalData, lat1Data, navLatDataType, nLat, true);
                Array lon1Data = NetCDFConverterUtilities.getArray(nLon, navLonDataType);
                NetCDFConverterUtilities.setData1D(lonOriginalData, lon1Data, navLonDataType, nLon, false);
                if (hasDepth) {
                    depthDataType = depthOriginalVar.getDataType();
                    ncFileOut.addVariable("depth", depthDataType, new Dimension[]{depthDim});
                    NetCDFConverterUtilities.setVariableAttributes(depthOriginalVar, ncFileOut, "depth");
                }
                if (hasDepth) {
                    depthDestData = NetCDFConverterUtilities.getArray(nDepths, depthDataType);
                    NetCDFConverterUtilities.setData1D(depthOriginalData, depthDestData, depthDataType, nDepths, false);
                }
                ArrayList<String> variables = new ArrayList<String>(5);
                HashMap<String, String> updatingValidRange = new HashMap<String, String>(5);
                HashMap<String, String> updatingFilLValue = new HashMap<String, String>(5);
                int numVars = 0;
                for (int i = 0; i < NUMVARS; ++i) {
                    String varName = VARIABLES.get(i);
                    Variable var = ncFileIn.findVariable(varName);
                    if (var == null) continue;
                    variables.add(varName);
                    boolean hasLocalDepth = NetCDFConverterUtilities.hasThisDimension(var, depthName);
                    if (hasDepth && hasLocalDepth) {
                        ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, depthDim, latDim, lonDim});
                    } else {
                        ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, latDim, lonDim});
                    }
                    boolean hasMinMax = false;
                    Attribute validMax = var.findAttribute("valid_max");
                    Attribute validMin = var.findAttribute("valid_min");
                    Attribute fillValue = var.findAttribute("_FillValue");
                    boolean hasMissingValue = false;
                    boolean hasFillValue = true;
                    if (fillValue == null) {
                        hasFillValue = false;
                        fillValue = var.findAttribute("missing_value");
                        if (fillValue != null) {
                            hasMissingValue = true;
                        }
                    }
                    Attribute validRange = var.findAttribute("valid_range");
                    boolean hasValidRange = false;
                    boolean rewriteAttribute = false;
                    if (validMin != null && validMax != null && fillValue != null) {
                        rewriteAttribute = !NetCDFConverterUtilities.isFillValueOutsideValidRange(validMax, validMin, fillValue, var.getDataType());
                        hasMinMax = true;
                    } else if (validRange != null && fillValue != null) {
                        rewriteAttribute = !NetCDFConverterUtilities.isFillValueOutsideValidRange(validRange, fillValue, var.getDataType());
                        hasValidRange = true;
                    } else {
                        rewriteAttribute = true;
                    }
                    if (rewriteAttribute) {
                        updatingValidRange.put(varName, "");
                        DataType varDatatype = var.getDataType();
                        Array range = NetCDFConverterUtilities.getRangeArray(varDatatype);
                        ncFileOut.addVariableAttribute(varName, "valid_range", range);
                        if (hasMissingValue && !hasFillValue) {
                            updatingFilLValue.put(varName, "");
                            Number fillVal = NetCDFConverterUtilities.getNumber(varDatatype);
                            ncFileOut.addVariableAttribute(varName, "_FillValue", fillVal);
                        }
                    }
                    String[] exceptions = null;
                    if (hasMinMax) {
                        exceptions = hasMissingValue ? new String[]{"valid_max", "valid_min", "missing_value"} : new String[]{"valid_max", "valid_min"};
                    } else if (hasValidRange) {
                        exceptions = hasMissingValue ? new String[]{"valid_range", "missing_value"} : new String[]{"valid_range"};
                    } else if (hasMissingValue) {
                        exceptions = new String[]{"missing_value"};
                    }
                    NetCDFConverterUtilities.setVariableAttributes(var, ncFileOut, exceptions);
                    ++numVars;
                }
                ncFileOut.create();
                Array timeData = NetCDFConverterUtilities.getArray(nTimes, timeDataType);
                NetCDFConverterUtilities.setData1D(timeOriginalData, timeData, timeDataType, nTimes, false);
                ncFileOut.write("time", timeData);
                timeVar = ncFileOut.findVariable("time");
                timeDim.addCoordinateVariable(timeVar);
                ncFileOut.write("lat", lat1Data);
                ncFileOut.write("lon", lon1Data);
                if (hasDepth) {
                    Variable depthVar = ncFileOut.findVariable("depth");
                    depthDim.addCoordinateVariable(depthVar);
                    ncFileOut.write("depth", depthDestData);
                }
                for (int i = 0; i < numVars; ++i) {
                    String varName = (String)variables.get(i);
                    Variable var = ncFileIn.findVariable(varName);
                    boolean hasLocalDepth = NetCDFConverterUtilities.hasThisDimension(var, depthName);
                    Array originalVarArray = var.read();
                    DataType varDataType = var.getDataType();
                    Array destArray = null;
                    int[] dimensions = null;
                    boolean setDepth = hasDepth && hasLocalDepth;
                    dimensions = setDepth ? new int[]{timeDim.getLength(), depthDim.getLength(), latDim.getLength(), lonDim.getLength()} : new int[]{timeDim.getLength(), latDim.getLength(), lonDim.getLength()};
                    destArray = NetCDFConverterUtilities.getArray(dimensions, varDataType);
                    boolean findNewRange = updatingValidRange.containsKey(varName);
                    boolean updateFillValue = updatingFilLValue.containsKey(varName);
                    int[] loopLengths = setDepth ? new int[]{nTimes, nDepths, nLat, nLon} : new int[]{nTimes, nLat, nLon};
                    NetCDFConverterUtilities.writeData(ncFileOut, varName, var, originalVarArray, destArray, findNewRange, updateFillValue, loopLengths, true);
                }
                ncFileOut.close();
                outputFile.renameTo(fileOut);
            }
            catch (Exception e) {
                if (!NetCDFConverterUtilities.LOGGER.isLoggable(Level.INFO)) break block26;
                NetCDFConverterUtilities.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
        }
    }

    static {
        VARIABLES.add("sohefldo");
        VARIABLES.add("soshfldo");
        VARIABLES.add("sossheig");
        VARIABLES.add("sowaflup");
        VARIABLES.add("vosaline");
        VARIABLES.add("votemper");
        VARIABLES.add("sozotaux");
        VARIABLES.add("vozocrtx");
        VARIABLES.add("vomecrty");
        VARIABLES.add("sometauy");
        NUMVARS = VARIABLES.size();
    }
}

