/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class NetCDFConverterUtilities {
    public static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.netcdf");
    public static int JGREG = 588829;
    public static double HALFSECOND = 0.5;

    private NetCDFConverterUtilities() {
    }

    public static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String newVarName, String[] exceptions) {
        List attributes = variable.getAttributes();
        String name = newVarName;
        if (attributes != null) {
            for (Attribute att : attributes) {
                String attribName = att.getName();
                boolean skip = false;
                if (exceptions != null) {
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (!exceptions[i].equalsIgnoreCase(attribName)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                if (att.isArray()) {
                    writableFile.addVariableAttribute(name, attribName, att.getValues());
                    continue;
                }
                if (att.isString()) {
                    writableFile.addVariableAttribute(name, attribName, att.getStringValue());
                    continue;
                }
                writableFile.addVariableAttribute(name, attribName, att.getNumericValue());
            }
        }
    }

    public static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile) {
        NetCDFConverterUtilities.setVariableAttributes(variable, writableFile, variable.getName(), null);
    }

    public static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String newVarName) {
        NetCDFConverterUtilities.setVariableAttributes(variable, writableFile, newVarName, null);
    }

    public static void setVariableAttributes(Variable variable, NetcdfFileWriteable writableFile, String[] exceptions) {
        NetCDFConverterUtilities.setVariableAttributes(variable, writableFile, variable.getName(), exceptions);
    }

    public static void copyGlobalAttributes(NetcdfFileWriteable writableFile, List<Attribute> attributes) {
        if (!attributes.isEmpty()) {
            for (Attribute attrib : attributes) {
                if (attrib.isArray()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getValues());
                    continue;
                }
                if (attrib.isString()) {
                    writableFile.addGlobalAttribute(attrib.getName(), attrib.getStringValue());
                    continue;
                }
                writableFile.addGlobalAttribute(attrib.getName(), attrib.getNumericValue());
            }
        }
    }

    public static GregorianCalendar fromJulian(double injulian) {
        double julian = injulian + HALFSECOND / 86400.0;
        int ja = (int)injulian;
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    public static GregorianCalendar fromModifiedJulian(double injulian, String long_name, String units) {
        Date startDate;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        sdf.setDateFormatSymbols(new DateFormatSymbols(Locale.US));
        try {
            startDate = sdf.parse(long_name.substring(long_name.length() - "dd-MMM-yyyy HH:mm:ss".length(), long_name.length()));
        }
        catch (ParseException e) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        if (units.equalsIgnoreCase("days")) {
            int jdi;
            double jd = Math.floor(injulian);
            double jdf = jd - (double)(jdi = (int)Math.floor(jd)) + 0.5;
            if (jdf >= 1.0) {
                jdf -= 1.0;
                ++jdi;
            }
            int hour = (int)(jdf * 24.0);
            calendar.setTime(startDate);
            calendar.add(5, jdi);
            calendar.add(10, hour);
        }
        return calendar;
    }

    public static Array getArray(int dimension, DataType navLatDataType) {
        if (dimension < 1) {
            throw new IllegalArgumentException("dimension should be greater than zero");
        }
        int[] dim = new int[]{dimension};
        if (navLatDataType == DataType.FLOAT) {
            return new ArrayFloat(dim);
        }
        if (navLatDataType == DataType.DOUBLE) {
            return new ArrayDouble(dim);
        }
        if (navLatDataType == DataType.BYTE) {
            return new ArrayByte(dim);
        }
        if (navLatDataType == DataType.SHORT) {
            return new ArrayShort(dim);
        }
        if (navLatDataType == DataType.INT) {
            return new ArrayInt(dim);
        }
        throw new IllegalArgumentException("Actually unsupported Datatype");
    }

    public static void setData1D(Array originalData, Array destinationData, DataType navLatDataType, int maxIndex, boolean flipData) {
        block11: {
            Index destinationDataIndex;
            Index originalDataIndex;
            block14: {
                block13: {
                    block12: {
                        block10: {
                            originalDataIndex = originalData.getIndex();
                            Index index = destinationDataIndex = flipData ? destinationData.getIndex() : originalDataIndex;
                            if (navLatDataType != DataType.FLOAT) break block10;
                            for (int pos = 0; pos < maxIndex; ++pos) {
                                float f = originalData.getFloat(originalDataIndex.set(pos));
                                if (flipData) {
                                    destinationDataIndex.set(maxIndex - pos - 1);
                                }
                                destinationData.setFloat(destinationDataIndex, f);
                            }
                            break block11;
                        }
                        if (navLatDataType != DataType.DOUBLE) break block12;
                        for (int pos = 0; pos < maxIndex; ++pos) {
                            double d = originalData.getDouble(originalDataIndex.set(pos));
                            if (flipData) {
                                destinationDataIndex.set(maxIndex - pos - 1);
                            }
                            destinationData.setDouble(destinationDataIndex, d);
                        }
                        break block11;
                    }
                    if (navLatDataType != DataType.BYTE) break block13;
                    for (int pos = 0; pos < maxIndex; ++pos) {
                        byte b = originalData.getByte(originalDataIndex.set(pos));
                        if (flipData) {
                            destinationDataIndex.set(maxIndex - pos - 1);
                        }
                        destinationData.setByte(destinationDataIndex, b);
                    }
                    break block11;
                }
                if (navLatDataType != DataType.SHORT) break block14;
                for (int pos = 0; pos < maxIndex; ++pos) {
                    short s = originalData.getShort(originalDataIndex.set(pos));
                    if (flipData) {
                        destinationDataIndex.set(maxIndex - pos - 1);
                    }
                    destinationData.setShort(destinationDataIndex, s);
                }
                break block11;
            }
            if (navLatDataType != DataType.INT) break block11;
            for (int pos = 0; pos < maxIndex; ++pos) {
                int i = originalData.getInt(originalDataIndex.set(pos));
                if (flipData) {
                    destinationDataIndex.set(maxIndex - pos - 1);
                }
                destinationData.setInt(destinationDataIndex, i);
            }
        }
    }

    public static Array getRangeArray(DataType varDataType) {
        int[] dim = new int[]{2};
        if (varDataType == DataType.FLOAT) {
            ArrayFloat array = new ArrayFloat(dim);
            Index index = array.getIndex();
            array.setFloat(index.set(0), Float.MIN_VALUE);
            array.setFloat(index.set(1), Float.MAX_VALUE);
            return array;
        }
        if (varDataType == DataType.DOUBLE) {
            ArrayDouble array = new ArrayDouble(dim);
            Index index = array.getIndex();
            array.setDouble(index.set(0), Double.MIN_VALUE);
            array.setDouble(index.set(1), Double.MAX_VALUE);
            return array;
        }
        if (varDataType == DataType.BYTE) {
            ArrayByte array = new ArrayByte(dim);
            Index index = array.getIndex();
            array.setByte(index.set(0), (byte)-128);
            array.setByte(index.set(1), (byte)127);
            return array;
        }
        if (varDataType == DataType.SHORT) {
            ArrayShort array = new ArrayShort(dim);
            Index index = array.getIndex();
            array.setShort(index.set(0), (short)Short.MIN_VALUE);
            array.setShort(index.set(1), (short)Short.MAX_VALUE);
            return array;
        }
        if (varDataType == DataType.INT) {
            ArrayInt array = new ArrayInt(dim);
            Index index = array.getIndex();
            array.setInt(index.set(0), Integer.MIN_VALUE);
            array.setInt(index.set(1), Integer.MAX_VALUE);
            return array;
        }
        throw new IllegalArgumentException("Actually unsupported Datatype");
    }

    public static Array getArray(int[] dimensions, DataType varDataType) {
        if (dimensions == null) {
            throw new IllegalArgumentException("Illegal dimensions");
        }
        int nDims = dimensions.length;
        switch (nDims) {
            case 4: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D4(dimensions[0], dimensions[1], dimensions[2], dimensions[3]);
                }
                throw new IllegalArgumentException("Actually unsupported Datatype");
            }
            case 3: {
                if (varDataType == DataType.FLOAT) {
                    return new ArrayFloat.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.DOUBLE) {
                    return new ArrayDouble.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.BYTE) {
                    return new ArrayByte.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.SHORT) {
                    return new ArrayShort.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                if (varDataType == DataType.INT) {
                    return new ArrayInt.D3(dimensions[0], dimensions[1], dimensions[2]);
                }
                throw new IllegalArgumentException("Actually unsupported Datatype");
            }
        }
        throw new IllegalArgumentException("Unable to create a proper array unsupported Datatype");
    }

    public static void writeData(NetcdfFileWriteable ncFileOut, String varName, Variable var, Array originalVarData, Array destArray, boolean findNewRange, boolean updateFillValue, int[] loopLengths, boolean flipY) throws IOException, InvalidRangeException {
        int lonPositions;
        int latPositions;
        int depthPositions;
        int nestedLoops = loopLengths.length;
        boolean setDepth = nestedLoops > 3;
        int timePositions = loopLengths[0];
        if (setDepth) {
            depthPositions = loopLengths[1];
            latPositions = loopLengths[2];
            lonPositions = loopLengths[3];
        } else {
            depthPositions = -1;
            latPositions = loopLengths[1];
            lonPositions = loopLengths[2];
        }
        DataType varDataType = var.getDataType();
        Attribute fv = null;
        fv = updateFillValue ? var.findAttribute("missing_value") : var.findAttribute("_FillValue");
        Index varIndex = originalVarData.getIndex();
        Index destIndex = destArray.getIndex();
        if (varDataType == DataType.FLOAT) {
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            float fillValue = Float.MAX_VALUE;
            if (fv != null) {
                fillValue = fv.getNumericValue().floatValue();
            }
            if (setDepth) {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int levelPos = 0; levelPos < depthPositions; ++levelPos) {
                        for (int yPos = 0; yPos < latPositions; ++yPos) {
                            for (int xPos = 0; xPos < lonPositions; ++xPos) {
                                float sVal = originalVarData.getFloat(varIndex.set(tPos, levelPos, yPos, xPos));
                                if (findNewRange) {
                                    if (sVal >= max && sVal != fillValue) {
                                        max = sVal;
                                    }
                                    if (sVal <= min && sVal != fillValue) {
                                        min = sVal;
                                    }
                                }
                                int newYpos = yPos;
                                if (flipY) {
                                    newYpos = latPositions - yPos - 1;
                                }
                                destArray.setFloat(destIndex.set(tPos, levelPos, newYpos, xPos), sVal);
                            }
                        }
                    }
                }
            } else {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int yPos = 0; yPos < latPositions; ++yPos) {
                        for (int xPos = 0; xPos < lonPositions; ++xPos) {
                            float sVal = originalVarData.getFloat(varIndex.set(tPos, yPos, xPos));
                            if (findNewRange) {
                                if (sVal >= max && sVal != fillValue) {
                                    max = sVal;
                                }
                                if (sVal <= min && sVal != fillValue) {
                                    min = sVal;
                                }
                            }
                            int newYpos = yPos;
                            if (flipY) {
                                newYpos = latPositions - yPos - 1;
                            }
                            destArray.setFloat(destIndex.set(tPos, newYpos, xPos), sVal);
                        }
                    }
                }
            }
            ncFileOut.write(varName, destArray);
            if (findNewRange) {
                Array range = NetCDFConverterUtilities.getRangeArray(varDataType);
                Index index = range.getIndex();
                range.setFloat(index.set(0), min);
                range.setFloat(index.set(1), max);
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("valid_range", range));
            }
            if (updateFillValue) {
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("_FillValue", (Number)new Float(fillValue)));
            }
        } else if (varDataType == DataType.DOUBLE) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double fillValue = Double.MAX_VALUE;
            if (fv != null) {
                fillValue = fv.getNumericValue().doubleValue();
            }
            if (setDepth) {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int levelPos = 0; levelPos < depthPositions; ++levelPos) {
                        for (int yPos = 0; yPos < latPositions; ++yPos) {
                            for (int xPos = 0; xPos < lonPositions; ++xPos) {
                                double sVal = originalVarData.getDouble(varIndex.set(tPos, levelPos, yPos, xPos));
                                if (findNewRange) {
                                    if (sVal >= max && sVal != fillValue) {
                                        max = sVal;
                                    }
                                    if (sVal <= min && sVal != fillValue) {
                                        min = sVal;
                                    }
                                }
                                int newYpos = yPos;
                                if (flipY) {
                                    newYpos = latPositions - yPos - 1;
                                }
                                destArray.setDouble(destIndex.set(tPos, levelPos, newYpos, xPos), sVal);
                            }
                        }
                    }
                }
            } else {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int yPos = 0; yPos < latPositions; ++yPos) {
                        for (int xPos = 0; xPos < lonPositions; ++xPos) {
                            double sVal = originalVarData.getDouble(varIndex.set(tPos, yPos, xPos));
                            if (findNewRange) {
                                if (sVal >= max && sVal != fillValue) {
                                    max = sVal;
                                }
                                if (sVal <= min && sVal != fillValue) {
                                    min = sVal;
                                }
                            }
                            int newYpos = yPos;
                            if (flipY) {
                                newYpos = latPositions - yPos - 1;
                            }
                            destArray.setDouble(destIndex.set(tPos, newYpos, xPos), sVal);
                        }
                    }
                }
            }
            ncFileOut.write(varName, destArray);
            if (findNewRange) {
                Array range = NetCDFConverterUtilities.getRangeArray(varDataType);
                Index index = range.getIndex();
                range.setDouble(index.set(0), min);
                range.setDouble(index.set(1), max);
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("valid_range", range));
            }
            if (updateFillValue) {
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("_FillValue", (Number)new Double(fillValue)));
            }
        } else if (varDataType == DataType.BYTE) {
            byte min = 127;
            byte max = -128;
            byte fillValue = 127;
            if (fv != null) {
                fillValue = fv.getNumericValue().byteValue();
            }
            if (setDepth) {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int levelPos = 0; levelPos < depthPositions; ++levelPos) {
                        for (int yPos = 0; yPos < latPositions; ++yPos) {
                            for (int xPos = 0; xPos < lonPositions; ++xPos) {
                                byte sVal = originalVarData.getByte(varIndex.set(tPos, levelPos, yPos, xPos));
                                if (findNewRange) {
                                    if (sVal >= max && sVal != fillValue) {
                                        max = sVal;
                                    }
                                    if (sVal <= min && sVal != fillValue) {
                                        min = sVal;
                                    }
                                }
                                int newYpos = yPos;
                                if (flipY) {
                                    newYpos = latPositions - yPos - 1;
                                }
                                destArray.setByte(destIndex.set(tPos, levelPos, newYpos, xPos), sVal);
                            }
                        }
                    }
                }
            } else {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int yPos = 0; yPos < latPositions; ++yPos) {
                        for (int xPos = 0; xPos < lonPositions; ++xPos) {
                            byte sVal = originalVarData.getByte(varIndex.set(tPos, yPos, xPos));
                            if (findNewRange) {
                                if (sVal >= max && sVal != fillValue) {
                                    max = sVal;
                                }
                                if (sVal <= min && sVal != fillValue) {
                                    min = sVal;
                                }
                            }
                            int newYpos = yPos;
                            if (flipY) {
                                newYpos = latPositions - yPos - 1;
                            }
                            destArray.setByte(destIndex.set(tPos, newYpos, xPos), sVal);
                        }
                    }
                }
            }
            ncFileOut.write(varName, destArray);
            if (findNewRange) {
                Array range = NetCDFConverterUtilities.getRangeArray(varDataType);
                Index index = range.getIndex();
                range.setByte(index.set(0), min);
                range.setByte(index.set(1), max);
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("valid_range", range));
            }
            if (updateFillValue) {
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("_FillValue", (Number)new Byte(fillValue)));
            }
        } else if (varDataType == DataType.SHORT) {
            short min = Short.MAX_VALUE;
            short max = Short.MIN_VALUE;
            short fillValue = Short.MAX_VALUE;
            if (fv != null) {
                fillValue = fv.getNumericValue().shortValue();
            }
            if (setDepth) {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int levelPos = 0; levelPos < depthPositions; ++levelPos) {
                        for (int yPos = 0; yPos < latPositions; ++yPos) {
                            for (int xPos = 0; xPos < lonPositions; ++xPos) {
                                short sVal = originalVarData.getShort(varIndex.set(tPos, levelPos, yPos, xPos));
                                if (findNewRange) {
                                    if (sVal >= max && sVal != fillValue) {
                                        max = sVal;
                                    }
                                    if (sVal <= min && sVal != fillValue) {
                                        min = sVal;
                                    }
                                }
                                int newYpos = yPos;
                                if (flipY) {
                                    newYpos = latPositions - yPos - 1;
                                }
                                destArray.setShort(destIndex.set(tPos, levelPos, newYpos, xPos), sVal);
                            }
                        }
                    }
                }
            } else {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int yPos = 0; yPos < latPositions; ++yPos) {
                        for (int xPos = 0; xPos < lonPositions; ++xPos) {
                            short sVal = originalVarData.getShort(varIndex.set(tPos, yPos, xPos));
                            if (findNewRange) {
                                if (sVal >= max && sVal != fillValue) {
                                    max = sVal;
                                }
                                if (sVal <= min && sVal != fillValue) {
                                    min = sVal;
                                }
                            }
                            int newYpos = yPos;
                            if (flipY) {
                                newYpos = latPositions - yPos - 1;
                            }
                            destArray.setShort(destIndex.set(tPos, newYpos, xPos), sVal);
                        }
                    }
                }
            }
            ncFileOut.write(varName, destArray);
            if (findNewRange) {
                Array range = NetCDFConverterUtilities.getRangeArray(varDataType);
                Index index = range.getIndex();
                range.setShort(index.set(0), min);
                range.setShort(index.set(1), max);
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("valid_range", range));
            }
            if (updateFillValue) {
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("_FillValue", (Number)new Short(fillValue)));
            }
        } else if (varDataType == DataType.INT) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int fillValue = Integer.MAX_VALUE;
            if (fv != null) {
                fillValue = fv.getNumericValue().intValue();
            }
            if (setDepth) {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int levelPos = 0; levelPos < depthPositions; ++levelPos) {
                        for (int yPos = 0; yPos < latPositions; ++yPos) {
                            for (int xPos = 0; xPos < lonPositions; ++xPos) {
                                int sVal = originalVarData.getInt(varIndex.set(tPos, levelPos, yPos, xPos));
                                if (findNewRange) {
                                    if (sVal >= max && sVal != fillValue) {
                                        max = sVal;
                                    }
                                    if (sVal <= min && sVal != fillValue) {
                                        min = sVal;
                                    }
                                }
                                int newYpos = yPos;
                                if (flipY) {
                                    newYpos = latPositions - yPos - 1;
                                }
                                destArray.setInt(destIndex.set(tPos, levelPos, newYpos, xPos), sVal);
                            }
                        }
                    }
                }
            } else {
                for (tPos = 0; tPos < timePositions; ++tPos) {
                    for (int yPos = 0; yPos < latPositions; ++yPos) {
                        for (int xPos = 0; xPos < lonPositions; ++xPos) {
                            int sVal = originalVarData.getInt(varIndex.set(tPos, yPos, xPos));
                            if (findNewRange) {
                                if (sVal >= max && sVal != fillValue) {
                                    max = sVal;
                                }
                                if (sVal <= min && sVal != fillValue) {
                                    min = sVal;
                                }
                            }
                            int newYpos = yPos;
                            if (flipY) {
                                newYpos = latPositions - yPos - 1;
                            }
                            destArray.setInt(destIndex.set(tPos, newYpos, xPos), sVal);
                        }
                    }
                }
            }
            ncFileOut.write(varName, destArray);
            if (findNewRange) {
                Array range = NetCDFConverterUtilities.getRangeArray(varDataType);
                Index index = range.getIndex();
                range.setInt(index.set(0), min);
                range.setInt(index.set(1), max);
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("valid_range", range));
            }
            if (updateFillValue) {
                ncFileOut.updateAttribute(ncFileOut.findVariable(varName), new Attribute("_FillValue", (Number)new Integer(fillValue)));
            }
        } else {
            throw new IllegalArgumentException("Unsupported DataType");
        }
    }

    public static boolean hasThisDimension(Variable var, String dimensionName) {
        List dims = var.getDimensions();
        boolean hasDimension = false;
        for (Dimension dim : dims) {
            if (!dim.getName().equalsIgnoreCase(dimensionName)) continue;
            hasDimension = true;
            break;
        }
        return hasDimension;
    }

    public static boolean isFillValueOutsideValidRange(Attribute validMax, Attribute validMin, Attribute fillValue, DataType dataType) {
        if (dataType == DataType.FLOAT) {
            float min = validMin.getNumericValue().floatValue();
            float max = validMax.getNumericValue().floatValue();
            float fill = fillValue.getNumericValue().floatValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.DOUBLE) {
            double min = validMin.getNumericValue().doubleValue();
            double max = validMax.getNumericValue().doubleValue();
            double fill = fillValue.getNumericValue().doubleValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.BYTE) {
            byte min = validMin.getNumericValue().byteValue();
            byte max = validMax.getNumericValue().byteValue();
            byte fill = fillValue.getNumericValue().byteValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.SHORT) {
            short min = validMin.getNumericValue().shortValue();
            short max = validMax.getNumericValue().shortValue();
            short fill = fillValue.getNumericValue().shortValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.INT) {
            int min = validMin.getNumericValue().intValue();
            int max = validMax.getNumericValue().intValue();
            int fill = fillValue.getNumericValue().intValue();
            return fill != min && fill != max;
        }
        throw new IllegalArgumentException("Actually unsupported Datatype");
    }

    public static boolean isFillValueOutsideValidRange(Attribute validRange, Attribute fillValue, DataType dataType) {
        Array range = validRange.getValues();
        Index index = range.getIndex();
        if (dataType == DataType.FLOAT) {
            float min = range.getFloat(index.set(0));
            float max = range.getFloat(index.set(1));
            float fill = fillValue.getNumericValue().floatValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.DOUBLE) {
            double min = range.getDouble(index.set(0));
            double max = range.getDouble(index.set(1));
            double fill = fillValue.getNumericValue().doubleValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.BYTE) {
            byte min = range.getByte(index.set(0));
            byte max = range.getByte(index.set(1));
            byte fill = fillValue.getNumericValue().byteValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.SHORT) {
            short min = range.getShort(index.set(0));
            short max = range.getShort(index.set(1));
            short fill = fillValue.getNumericValue().shortValue();
            return fill != min && fill != max;
        }
        if (dataType == DataType.INT) {
            int min = range.getInt(index.set(0));
            int max = range.getInt(index.set(1));
            int fill = fillValue.getNumericValue().intValue();
            return fill != min && fill != max;
        }
        throw new IllegalArgumentException("Actually unsupported Datatype");
    }

    public static Number getNumber(DataType varDataType) {
        if (varDataType == DataType.FLOAT) {
            return new Float(Float.MIN_VALUE);
        }
        if (varDataType == DataType.DOUBLE) {
            return new Double(Double.MIN_VALUE);
        }
        if (varDataType == DataType.BYTE) {
            return new Byte(-128);
        }
        if (varDataType == DataType.SHORT) {
            return new Short(Short.MIN_VALUE);
        }
        if (varDataType == DataType.INT) {
            return new Integer(Integer.MIN_VALUE);
        }
        throw new IllegalArgumentException("Actually unsupported Datatype");
    }
}

