/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import it.geosolutions.jaiext.affine.AffineDescriptor;
import it.geosolutions.jaiext.affine.AffinePropertyGenerator;
import it.geosolutions.jaiext.affine.TestAffine;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.NullDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class CoverageClassTest
extends TestAffine {
    @Test
    public void testROIProperty() {
        AffineDescriptor descriptor = new AffineDescriptor();
        AffinePropertyGenerator propertyGenerator = (AffinePropertyGenerator)descriptor.getPropertyGenerators()[0];
        boolean useROIAccessor = false;
        boolean setDestinationNoData = false;
        int dataType = 0;
        Range noDataRange = null;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        ROIShape roi = this.roiCreation();
        byte imageValue = 127;
        RenderedImage testImg = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        RenderedOp testIMG = NullDescriptor.create((RenderedImage)testImg, null);
        AffineTransform transform = AffineTransform.getQuadrantRotateInstance(this.numquadrants, this.anchorX, this.anchorY);
        transform.concatenate(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
        transform.concatenate(AffineTransform.getTranslateInstance(this.transX, this.transY));
        RenderedOp affineImgNear = AffineDescriptor.create((RenderedImage)testIMG, (AffineTransform)transform, (Interpolation)interpNear, null, (ROI)roi, (boolean)useROIAccessor, (boolean)setDestinationNoData, null, null);
        affineImgNear.getTile(0, 0);
        ROI roiNear = (ROI)propertyGenerator.getProperty("roi", affineImgNear);
        Rectangle roiNearBounds = roiNear.getBounds();
        double actualWidth = roiNearBounds.getWidth();
        double actualHeight = roiNearBounds.getHeight();
        double actualminX = roiNearBounds.getMinX();
        double actualminY = roiNearBounds.getMinY();
        Rectangle srcBounds = new Rectangle(testIMG.getMinX() + interpNear.getLeftPadding(), testIMG.getMinY() + interpNear.getTopPadding(), testIMG.getWidth() - interpNear.getWidth() + 1, testIMG.getHeight() - interpNear.getHeight() + 1);
        if (!srcBounds.contains(roi.getBounds())) {
            roi = roi.intersect((ROI)new ROIShape((Shape)srcBounds));
        }
        ROI dstROI = roi.transform(transform);
        Rectangle dstBounds = affineImgNear.getBounds();
        if (!dstBounds.contains(dstROI.getBounds())) {
            dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
        }
        Rectangle dstROIBounds = dstROI.getBounds();
        double expectedWidth = dstROIBounds.getWidth();
        double expectedHeight = dstROIBounds.getHeight();
        double expectedminX = dstROIBounds.getMinX();
        double expectedminY = dstROIBounds.getMinY();
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedWidth, (double)actualWidth, (double)tolerance);
        Assert.assertEquals((double)expectedHeight, (double)actualHeight, (double)tolerance);
        Assert.assertEquals((double)expectedminX, (double)actualminX, (double)tolerance);
        Assert.assertEquals((double)expectedminY, (double)actualminY, (double)tolerance);
        if (affineImgNear instanceof RenderedOp) {
            affineImgNear.dispose();
        }
    }

    @Test
    public void testTranslation() {
        boolean useROIAccessor = false;
        boolean setDestinationNoData = false;
        Range noDataRange = null;
        int dataType = 0;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        AffineTransform transform = AffineTransform.getTranslateInstance(this.transX, this.transY);
        RenderedOp affineImgNear = AffineDescriptor.create((RenderedImage)testIMG, (AffineTransform)transform, (Interpolation)interpNear, null, null, (boolean)useROIAccessor, (boolean)setDestinationNoData, null, null);
        affineImgNear.getTiles();
        double actualX = affineImgNear.getMinX();
        double actualY = affineImgNear.getMinY();
        double expectedX = (float)testIMG.getMinX() + this.transX;
        double expectedY = (float)testIMG.getMinY() + this.transY;
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        double actualWidth = affineImgNear.getWidth();
        double actualHeight = affineImgNear.getHeight();
        double expectedWidth = testIMG.getWidth();
        double expectedHeigh = testIMG.getHeight();
        Assert.assertEquals((double)expectedWidth, (double)actualWidth, (double)tolerance);
        Assert.assertEquals((double)expectedHeigh, (double)actualHeight, (double)tolerance);
        if (affineImgNear instanceof RenderedOp) {
            affineImgNear.dispose();
        }
    }

    @Test
    public void testCopy() {
        boolean useROIAccessor = false;
        boolean setDestinationNoData = false;
        Range noDataRange = null;
        int dataType = 0;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        AffineTransform transform = new AffineTransform();
        RenderedOp affineImgNear = AffineDescriptor.create((RenderedImage)testIMG, (AffineTransform)transform, (Interpolation)interpNear, null, null, (boolean)useROIAccessor, (boolean)setDestinationNoData, null, null);
        affineImgNear.getTiles();
        double actualX = affineImgNear.getMinX();
        double actualY = affineImgNear.getMinY();
        double expectedX = testIMG.getMinX();
        double expectedY = testIMG.getMinY();
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        double actualWidth = affineImgNear.getWidth();
        double actualHeight = affineImgNear.getHeight();
        double expectedWidth = testIMG.getWidth();
        double expectedHeigh = testIMG.getHeight();
        Assert.assertEquals((double)expectedWidth, (double)actualWidth, (double)tolerance);
        Assert.assertEquals((double)expectedHeigh, (double)actualHeight, (double)tolerance);
        if (affineImgNear instanceof RenderedOp) {
            affineImgNear.dispose();
        }
    }
}

