/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;

class AffinePropertyGenerator
extends PropertyGeneratorImpl {
    public AffinePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            ROI dstROI;
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(3) != null) {
                    property = pb.getObjectParameter(3);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            ROI srcROI = (ROI)property;
            Interpolation interp = (Interpolation)pb.getObjectParameter(1);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            AffineTransform transform = (AffineTransform)pb.getObjectParameter(0);
            if (srcROI.getClass().equals(ROI.class)) {
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.add(transform);
                paramBlock.add(interp);
                RenderingHints localHints = new RenderingHints(Collections.emptyMap());
                localHints.putAll((Map<?, ?>)op.getRenderingHints());
                localHints.remove(JAI.KEY_IMAGE_LAYOUT);
                ImageLayout il = new ImageLayout();
                Rectangle dstBounds = op.getBounds();
                il.setMinX(dstBounds.x);
                il.setMinY(dstBounds.y);
                il.setWidth(dstBounds.width);
                il.setHeight(dstBounds.height);
                il.setTileWidth(op.getTileWidth());
                il.setTileHeight(op.getTileHeight());
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il));
                dstROI = srcROI.performImageOp("Affine", paramBlock, 0, localHints);
            } else {
                dstROI = srcROI.transform(transform);
            }
            Rectangle dstBounds = op.getBounds();
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

