/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.binarize;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.binarize.BinarizeDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final boolean ROI_USED = Boolean.getBoolean("JAI.Ext.ROIUsed");
    private static final int NUM_BANDS = 1;
    private static RenderedImage image;
    private static Range range;
    private static ROI roi;
    private static double[] thresholds;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        thresholds = new double[6];
        ComparisonTest.thresholds[0] = 63.0;
        ComparisonTest.thresholds[1] = 8191.0;
        ComparisonTest.thresholds[2] = -49.0;
        ComparisonTest.thresholds[3] = 105.0;
        ComparisonTest.thresholds[4] = 635.0;
        ComparisonTest.thresholds[5] = 468.0;
        image = null;
        switch (TEST_SELECTOR) {
            case 0: {
                image = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1);
                break;
            }
            case 1: {
                image = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false, (int)1);
                break;
            }
            case 2: {
                image = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1);
                break;
            }
            case 3: {
                image = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1);
                break;
            }
            case 4: {
                image = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
                break;
            }
            case 5: {
                image = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
        if (RANGE_USED && !OLD_DESCRIPTOR) {
            switch (TEST_SELECTOR) {
                case 0: {
                    range = RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true);
                    break;
                }
                case 1: {
                    range = RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true);
                    break;
                }
                case 2: {
                    range = RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true);
                    break;
                }
                case 3: {
                    range = RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true);
                    break;
                }
                case 4: {
                    range = RangeFactory.create((float)noDataF, (boolean)true, (float)noDataF, (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    range = RangeFactory.create((double)noDataD, (boolean)true, (double)noDataD, (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        if (ROI_USED) {
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
            roi = new ROIShape((Shape)rect);
        } else {
            roi = null;
        }
    }

    @Test
    public void testOperation() {
        int dataType = TEST_SELECTOR;
        String description = "Binarize";
        description = OLD_DESCRIPTOR ? "Old " + description : "New " + description;
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageCalculated = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                JAIExt.registerJAIDescriptor((String)"Binarize");
                imageCalculated = javax.media.jai.operator.BinarizeDescriptor.create((RenderedImage)image, (Double)thresholds[dataType], null);
            } else {
                imageCalculated = BinarizeDescriptor.create((RenderedImage)image, (Double)thresholds[dataType], (ROI)roi, (Range)range, null);
            }
            long start = System.nanoTime();
            imageCalculated.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageCalculated instanceof RenderedOp) {
            imageCalculated.dispose();
        }
    }
}

