/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.imagefunction;

import it.geosolutions.jaiext.imagefunction.ImageFunctionDescriptor;
import it.geosolutions.jaiext.imagefunction.ImageFunctionJAIEXT;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageFunction;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.Test;

public class ImageFunctionTest
extends TestBase {
    private static final double TOLERANCE = 0.01;

    @Test
    public void testImageFunction() {
        Range nodata = RangeFactory.create((float)25.0f, (float)25.0f);
        float xTrans = 5.0f;
        float yTrans = 5.0f;
        float xScale = 2.0f;
        float yScale = 2.0f;
        ROIShape roi = new ROIShape((Shape)new Rectangle(0, 0, 15, 15));
        float destNoData = 30.0f;
        int width = 128;
        int height = 128;
        DummyFunction function = new DummyFunction();
        RenderedOp transformed = ImageFunctionDescriptor.create((ImageFunction)function, (Integer)width, (Integer)height, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), (ROI)roi, (Range)nodata, (float)destNoData, null);
        this.checkNoDataROI(transformed, (ROI)roi, nodata, xScale, yScale);
    }

    private void checkNoDataROI(RenderedOp finalimage, ROI roi, Range nodata, float deltaX, float deltaY) {
        RandomIter roiIter = RandomIterFactory.create((RenderedImage)roi.getAsImage(), null, (boolean)true, (boolean)true);
        Rectangle roiBounds = roi.getBounds();
        RandomIter destIter = RandomIterFactory.create((RenderedImage)finalimage, null, (boolean)true, (boolean)true);
        int w = finalimage.getWidth();
        int h = finalimage.getHeight();
        int minX = finalimage.getMinX();
        int minY = finalimage.getMinY();
        int maxX = minX + w;
        int maxY = minY + h;
        nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        double result = minX + minY;
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                double dest = destIter.getSampleDouble(x, y, 0);
                boolean valid = true;
                if (!(roiBounds == null || roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0)) {
                    valid = false;
                }
                if (nodata != null && nodata.contains(result)) {
                    valid = false;
                }
                if (!valid) {
                    Assert.assertEquals((double)30.0, (double)dest, (double)0.01);
                }
                result += (double)deltaX;
            }
            result += (double)deltaY;
        }
    }

    public static class DummyFunction
    implements ImageFunctionJAIEXT {
        public void getElements(float arg0, float arg1, float arg2, float arg3, int arg4, int arg5, int arg6, float[] arg7, float[] arg8) {
            this.getElements(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, (Rectangle)null, (ROI)null, (Range)null, 0.0f);
        }

        public void getElements(double arg0, double arg1, double arg2, double arg3, int arg4, int arg5, int arg6, double[] arg7, double[] arg8) {
            this.getElements(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, null, null, null, 0.0f);
        }

        public int getNumElements() {
            return 1;
        }

        public boolean isComplex() {
            return false;
        }

        public void getElements(float startX, float startY, float deltaX, float deltaY, int countX, int countY, int element, float[] real, float[] imag, Rectangle destRect, ROI roi, Range nodata, float destNoData) {
            int index = 0;
            Rectangle roiBounds = roi != null ? roi.getBounds() : null;
            RandomIter it = roi != null ? RandomIterFactory.create((RenderedImage)roi.getAsImage(), null, (boolean)true, (boolean)true) : null;
            float result = startX + startY;
            int x0 = destRect.x;
            int y0 = destRect.y;
            for (int j = 0; j < countY; ++j) {
                int y = y0 + j;
                for (int i = 0; i < countX; ++i) {
                    int x = x0 + i;
                    real[index++] = roiBounds != null && roiBounds.contains(x, y) && it.getSample(x, y, 0) > 0 ? (nodata != null && !nodata.contains(result) ? result : destNoData) : destNoData;
                    result += deltaX;
                }
                result += deltaY;
            }
        }

        public void getElements(double startX, double startY, double deltaX, double deltaY, int countX, int countY, int element, double[] real, double[] imag, Rectangle destRect, ROI roi, Range nodata, float destNoData) {
            int index = 0;
            Rectangle roiBounds = roi != null ? roi.getBounds() : null;
            RandomIter it = roi != null ? RandomIterFactory.create((RenderedImage)roi.getAsImage(), null, (boolean)true, (boolean)true) : null;
            double result = startX + startY;
            int x0 = destRect.x;
            int y0 = destRect.y;
            for (int j = 0; j < countY; ++j) {
                int y = y0 + j;
                for (int i = 0; i < countX; ++i) {
                    int x = x0 + i;
                    real[index++] = roiBounds != null && roiBounds.contains(x, y) && it.getSample(x, y, 0) > 0 ? (nodata != null && !nodata.contains(result) ? result : (double)destNoData) : (double)destNoData;
                    result += deltaX;
                }
                result += deltaY;
            }
        }
    }
}

