/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.demo;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.demo.ImageChoice;
import it.geosolutions.jaiext.jiffle.demo.JiffleDemoBase;
import it.geosolutions.jaiext.jiffle.demo.JiffleDemoHelper;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.swing.ImageFrame;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.media.jai.TiledImage;

public class DirectRuntimeDemo
extends JiffleDemoBase {
    public static void main(String[] args) throws Exception {
        DirectRuntimeDemo demo = new DirectRuntimeDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public void compileAndRun(File scriptFile) throws Exception {
        HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        HashMap<String, TiledImage> images = new HashMap<String, TiledImage>();
        images.put("result", ImageUtilities.createConstantImage((int)500, (int)500, (Number)0.0));
        if (jiffle.isCompiled()) {
            JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
            TiledImage destImg = ImageUtilities.createConstantImage((int)500, (int)500, (Number)0.0);
            runtime.setDestinationImage("result", (WritableRenderedImage)destImg);
            runtime.evaluateAll(null);
            ImageFrame frame = new ImageFrame((RenderedImage)destImg, "Jiffle image demo");
            frame.setVisible(true);
        }
    }
}

