/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.demo;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.swing.SimpleImagePane;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.media.jai.TiledImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GameOfLife
extends JFrame {
    private static final int WORLD_SIZE = 80;
    private WorldType worldType = WorldType.TOROID;
    private static final long SHORT_DELAY = 50L;
    private static final long NORMAL_DELAY = 1000L;
    private static long stepDelay;
    private static final String WORLD_NAME = "world";
    private static final String NEXT_WORLD_NAME = "nextworld";
    private JiffleDirectRuntime toroidRuntime;
    private JiffleDirectRuntime edgeRuntime;
    private JiffleDirectRuntime activeRuntime;
    private final List<PatternInfo> patterns;
    private TiledImage curWorld;
    private TiledImage nextWorld;
    private SimpleImagePane imagePane;
    private ScheduledExecutorService runExecutor;
    private AtomicBoolean running;
    List<JComponent> itemsDisabledWhenRunning;

    public static void main(String[] args) {
        GameOfLife me = new GameOfLife();
        me.start(null);
    }

    public GameOfLife() {
        super("Jiffle demo: Conway's Game of Life");
        this.setDefaultCloseOperation(3);
        this.setSize(500, 500);
        this.running = new AtomicBoolean(false);
        this.patterns = new ArrayList<PatternInfo>();
        this.loadPatterns();
        this.createRuntimeInstances();
        this.initializeComponents();
    }

    private void createRuntimeInstances() {
        try {
            Jiffle jiffle = new Jiffle();
            HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
            imageParams.put(WORLD_NAME, Jiffle.ImageRole.SOURCE);
            imageParams.put(NEXT_WORLD_NAME, Jiffle.ImageRole.DEST);
            URL url = this.getClass().getResource("life-toroid.jfl");
            File file = new File(url.toURI());
            jiffle.setScript(file);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            this.toroidRuntime = jiffle.getRuntimeInstance();
            url = this.getClass().getResource("life-edges.jfl");
            file = new File(url.toURI());
            jiffle.setScript(file);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            this.edgeRuntime = jiffle.getRuntimeInstance();
            this.activeRuntime = this.worldType == WorldType.EDGES ? this.edgeRuntime : this.toroidRuntime;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void start(String patternName) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (patternName == null || patternName.length() == 0) {
            patternName = this.patterns.get((int)0).name;
        }
        this.initializeWorld(patternName);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameOfLife.this.imagePane.setImage((RenderedImage)GameOfLife.this.curWorld);
            }
        });
    }

    private void run() {
        this.running.set(true);
        this.runExecutor = Executors.newScheduledThreadPool(1);
        this.runExecutor.scheduleWithFixedDelay(new StepTask(), 0L, stepDelay, TimeUnit.MILLISECONDS);
    }

    private void stop() {
        if (this.running.get()) {
            this.runExecutor.shutdown();
            this.running.set(false);
        }
    }

    private void step() {
        this.activeRuntime.setSourceImage(WORLD_NAME, (RenderedImage)this.curWorld);
        this.activeRuntime.setDestinationImage(NEXT_WORLD_NAME, (WritableRenderedImage)this.nextWorld);
        this.activeRuntime.evaluateAll(null);
        TiledImage temp = this.curWorld;
        this.curWorld = this.nextWorld;
        this.nextWorld = temp;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameOfLife.this.imagePane.setImage((RenderedImage)GameOfLife.this.curWorld);
            }
        });
    }

    private void initializeWorld(String patternName) {
        this.curWorld = ImageUtilities.createConstantImage((int)80, (int)80, (Number)0.0);
        this.nextWorld = ImageUtilities.createConstantImage((int)80, (int)80, (Number)0.0);
        this.setPopulation(patternName);
    }

    private void setPopulation(String patternName) {
        int oy;
        PatternInfo info = this.getPattern(patternName);
        String[] lines = info.data.split("\n");
        int h = lines.length;
        int maxLen = 0;
        for (String line : lines) {
            if (line.length() <= maxLen) continue;
            maxLen = line.length();
        }
        int w = maxLen;
        int ox = this.curWorld.getMinX() + (this.curWorld.getWidth() - w) / 2;
        int y = oy = this.curWorld.getMinY() + (this.curWorld.getHeight() - h) / 2;
        for (int iy = 0; iy < h; ++iy) {
            String line = lines[iy];
            int len = line.length();
            int x = ox;
            for (int ix = 0; ix < len; ++ix) {
                if (line.charAt(ix) != '.') {
                    this.curWorld.setSample(x, y, 0, 1);
                }
                ++x;
            }
            ++y;
        }
    }

    private void initializeComponents() {
        JMenuItem item;
        this.imagePane = new SimpleImagePane();
        this.getContentPane().add((Component)this.imagePane);
        this.itemsDisabledWhenRunning = new ArrayList<JComponent>();
        JMenu worldMenu = new JMenu("World");
        JMenu patternMenu = new JMenu("Set pattern");
        for (final PatternInfo info : this.patterns) {
            item = new JMenuItem(info.name);
            item.setToolTipText(info.desc);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameOfLife.this.start(info.name);
                }
            });
            patternMenu.add(item);
        }
        worldMenu.add(patternMenu);
        this.itemsDisabledWhenRunning.add(worldMenu);
        final JCheckBoxMenuItem edgesItem = new JCheckBoxMenuItem("Join opposite edges (toroid)");
        edgesItem.setSelected(this.worldType == WorldType.TOROID);
        edgesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (edgesItem.isSelected()) {
                    GameOfLife.this.activeRuntime = GameOfLife.this.toroidRuntime;
                    GameOfLife.this.worldType = WorldType.TOROID;
                } else {
                    GameOfLife.this.activeRuntime = GameOfLife.this.edgeRuntime;
                    GameOfLife.this.worldType = WorldType.EDGES;
                }
            }
        });
        worldMenu.add(edgesItem);
        this.itemsDisabledWhenRunning.add(edgesItem);
        JMenu runMenu = new JMenu("Run");
        item = new JMenuItem("Single step <SPACE>");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GameOfLife.this.step();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(32, 0));
        runMenu.add(item);
        this.itemsDisabledWhenRunning.add(item);
        item = new JMenuItem("Run");
        item.addActionListener(new RunListener(1000L));
        item.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        runMenu.add(item);
        item = new JMenuItem("Run fast");
        item.addActionListener(new RunListener(50L));
        item.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        runMenu.add(item);
        item = new JMenuItem("Stop");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameOfLife.this.stop();
                GameOfLife.this.enableMenuItems(false);
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        runMenu.add(item);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(worldMenu);
        menuBar.add(runMenu);
        this.setJMenuBar(menuBar);
    }

    private void enableMenuItems(boolean isRunning) {
        for (JComponent jc : this.itemsDisabledWhenRunning) {
            jc.setEnabled(!isRunning);
        }
    }

    private void loadPatterns() {
        this.patterns.clear();
        try {
            File[] files;
            URL url = this.getClass().getResource("patterns");
            File patternDir = new File(url.toURI());
            for (File f : files = patternDir.listFiles()) {
                this.patterns.add(this.loadPattern(f));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private PatternInfo loadPattern(File f) throws FileNotFoundException, IOException {
        PatternInfo info = new PatternInfo();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = reader.readLine();
        while (line.startsWith("!")) {
            String lwr = line.toLowerCase();
            if (lwr.startsWith("!name:")) {
                info.name = line.substring(6).trim();
            } else if (lwr.startsWith("!author:")) {
                info.author = line.substring(8).trim();
            } else if (lwr.startsWith("!www")) {
                info.url = line.substring(1).trim();
            } else {
                info.desc = line.substring(1).trim();
            }
            line = reader.readLine();
        }
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            line = line.trim();
            sb.append(line).append("\n");
            line = reader.readLine();
        }
        info.data = sb.toString();
        reader.close();
        return info;
    }

    private PatternInfo getPattern(String patternName) {
        for (PatternInfo info : this.patterns) {
            if (!info.name.equalsIgnoreCase(patternName)) continue;
            return info;
        }
        throw new IllegalArgumentException("Pattern not loaded: " + patternName);
    }

    private class RunListener
    implements ActionListener {
        private final long delay;

        public RunListener(long delay) {
            this.delay = delay;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GameOfLife.this.running.get()) {
                GameOfLife.this.enableMenuItems(true);
            } else {
                GameOfLife.this.stop();
            }
            stepDelay = this.delay;
            GameOfLife.this.run();
        }
    }

    private class StepTask
    implements Runnable {
        private StepTask() {
        }

        @Override
        public void run() {
            GameOfLife.this.step();
        }
    }

    private static class PatternInfo {
        String name;
        String author;
        String desc;
        String url;
        String data;

        private PatternInfo() {
        }
    }

    private static enum WorldType {
        TOROID,
        EDGES;

    }
}

