/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.lookup;

import it.geosolutions.jaiext.lookup.LookupDescriptor;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LookupTest
extends TestBase {
    private static RenderedImage testImageByte;
    private static RenderedImage testImageUShort;
    private static RenderedImage testImageShort;
    private static RenderedImage testImageInt;
    private static LookupTable byteToByteTable;
    private static LookupTable byteToUshortTable;
    private static LookupTable byteToShortTable;
    private static LookupTable byteToIntTable;
    private static LookupTable byteToFloatTable;
    private static LookupTable byteToDoubleTable;
    private static LookupTable ushortToByteTable;
    private static LookupTable ushortToUshortTable;
    private static LookupTable ushortToShortTable;
    private static LookupTable ushortToIntTable;
    private static LookupTable ushortToFloatTable;
    private static LookupTable ushortToDoubleTable;
    private static LookupTable shortToByteTable;
    private static LookupTable shortToUshortTable;
    private static LookupTable shortToShortTable;
    private static LookupTable shortToIntTable;
    private static LookupTable shortToFloatTable;
    private static LookupTable shortToDoubleTable;
    private static LookupTable intToByteTable;
    private static LookupTable intToUshortTable;
    private static LookupTable intToShortTable;
    private static LookupTable intToIntTable;
    private static LookupTable intToFloatTable;
    private static LookupTable intToDoubleTable;
    private static ROIShape roi;
    private static double destinationNoDataValue;
    private static Range rangeB;
    private static Range rangeUS;
    private static Range rangeS;
    private static Range rangeI;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = false;
        byte noDataB = -100;
        short noDataUS = 100;
        short noDataS = -100;
        int noDataI = -100;
        testImageByte = LookupTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
        testImageUShort = LookupTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false);
        testImageShort = LookupTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
        testImageInt = LookupTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
        int byteOffset = 0;
        int ushortOffset = 0;
        short shortOffset = noDataS;
        int intOffset = noDataI;
        int arrayLength = 201;
        int startValue = -100;
        byte[] dataByteB = new byte[arrayLength];
        short[] dataByteUS = new short[arrayLength];
        short[] dataByteS = new short[arrayLength];
        int[] dataByteI = new int[arrayLength];
        float[] dataByteF = new float[arrayLength];
        double[] dataByteD = new double[arrayLength];
        byte[] dataUShortB = new byte[arrayLength];
        short[] dataUShortUS = new short[arrayLength];
        short[] dataUShortS = new short[arrayLength];
        int[] dataUShortI = new int[arrayLength];
        float[] dataUShortF = new float[arrayLength];
        double[] dataUShortD = new double[arrayLength];
        byte[] dataShortB = new byte[arrayLength];
        short[] dataShortUS = new short[arrayLength];
        short[] dataShortS = new short[arrayLength];
        int[] dataShortI = new int[arrayLength];
        float[] dataShortF = new float[arrayLength];
        double[] dataShortD = new double[arrayLength];
        byte[] dataIntB = new byte[arrayLength];
        short[] dataIntUS = new short[arrayLength];
        short[] dataIntS = new short[arrayLength];
        int[] dataIntI = new int[arrayLength];
        float[] dataIntF = new float[arrayLength];
        double[] dataIntD = new double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            dataByteB[i] = 0;
            dataByteUS[i] = 0;
            dataByteS[i] = 0;
            dataByteI[i] = 0;
            dataByteF[i] = (float)i * 1.0f / (float)arrayLength;
            dataByteD[i] = (double)i * 1.0 / (double)arrayLength * 2.0;
            dataUShortB[i] = 0;
            dataUShortUS[i] = 0;
            dataUShortS[i] = 0;
            dataUShortI[i] = 0;
            dataUShortF[i] = (float)i * 1.0f / (float)arrayLength;
            dataUShortD[i] = (double)i * 1.0 / (double)arrayLength * 2.0;
            dataShortB[i] = 0;
            dataShortUS[i] = 0;
            dataShortS[i] = 0;
            dataShortI[i] = 0;
            dataShortF[i] = (float)i * 1.0f / (float)arrayLength;
            dataShortD[i] = (double)i * 1.0 / (double)arrayLength * 2.0;
            dataIntB[i] = 0;
            dataIntUS[i] = 0;
            dataIntS[i] = 0;
            dataIntI[i] = 0;
            dataIntF[i] = (float)i * 1.0f / (float)arrayLength;
            dataIntD[i] = (double)i * 1.0 / (double)arrayLength * 2.0;
            int value = i + startValue;
            if (value == noDataI) {
                dataShortB[i] = 50;
                dataShortUS[i] = 50;
                dataShortS[i] = 50;
                dataShortI[i] = 50;
                dataIntB[i] = 50;
                dataIntUS[i] = 50;
                dataIntS[i] = 50;
                dataIntI[i] = 50;
                dataByteB[i] = 50;
                dataByteUS[i] = 50;
                dataByteS[i] = 50;
                dataByteI[i] = 50;
            }
            if (i != noDataUS) continue;
            dataUShortB[i] = 50;
            dataUShortUS[i] = 50;
            dataUShortS[i] = 50;
            dataUShortI[i] = 50;
        }
        byteToByteTable = new LookupTable(dataByteB, byteOffset);
        byteToUshortTable = new LookupTable(dataByteUS, byteOffset, true);
        byteToShortTable = new LookupTable(dataByteS, byteOffset, false);
        byteToIntTable = new LookupTable(dataByteI, byteOffset);
        byteToFloatTable = new LookupTable(dataByteF, byteOffset);
        byteToDoubleTable = new LookupTable(dataByteD, byteOffset);
        ushortToByteTable = new LookupTable(dataUShortB, ushortOffset);
        ushortToUshortTable = new LookupTable(dataUShortUS, ushortOffset, true);
        ushortToShortTable = new LookupTable(dataUShortS, ushortOffset, false);
        ushortToIntTable = new LookupTable(dataUShortI, ushortOffset);
        ushortToFloatTable = new LookupTable(dataUShortF, ushortOffset);
        ushortToDoubleTable = new LookupTable(dataUShortD, ushortOffset);
        shortToByteTable = new LookupTable(dataShortB, (int)shortOffset);
        shortToUshortTable = new LookupTable(dataShortUS, (int)shortOffset, true);
        shortToShortTable = new LookupTable(dataShortS, (int)shortOffset, false);
        shortToIntTable = new LookupTable(dataShortI, (int)shortOffset);
        shortToFloatTable = new LookupTable(dataShortF, (int)shortOffset);
        shortToDoubleTable = new LookupTable(dataShortD, (int)shortOffset);
        intToByteTable = new LookupTable(dataIntB, intOffset);
        intToUshortTable = new LookupTable(dataIntUS, intOffset, true);
        intToShortTable = new LookupTable(dataIntS, intOffset, false);
        intToIntTable = new LookupTable(dataIntI, intOffset);
        intToFloatTable = new LookupTable(dataIntF, intOffset);
        intToDoubleTable = new LookupTable(dataIntD, intOffset);
        Rectangle roiBounds = new Rectangle(0, 0, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roi = new ROIShape((Shape)roiBounds);
        rangeB = RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true);
        rangeUS = RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true);
        rangeS = RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true);
        rangeI = RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true);
        destinationNoDataValue = 255.0;
    }

    @Test
    public void testByteToAllTypes() {
        boolean roiUsed = false;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 0;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testOperation(testImageByte, byteToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testUshortToAllTypes() {
        boolean roiUsed = false;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 1;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testOperation(testImageUShort, ushortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testShortToAllTypes() {
        boolean roiUsed = false;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 2;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testOperation(testImageShort, shortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testIntToAllTypes() {
        boolean roiUsed = false;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 3;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testOperation(testImageInt, intToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testByteToAllTypesROIBounds() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 0;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testOperation(testImageByte, byteToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testUshortToAllTypesROIBounds() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 1;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testOperation(testImageUShort, ushortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testShortToAllTypesROIBounds() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 2;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testOperation(testImageShort, shortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testIntToAllTypesROIBounds() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = false;
        int dataType = 3;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testOperation(testImageInt, intToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testByteToAllTypesROIAccessor() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = true;
        int dataType = 0;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA;
        this.testOperation(testImageByte, byteToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testUshortToAllTypesROIAccessor() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = true;
        int dataType = 1;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA;
        this.testOperation(testImageUShort, ushortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testShortToAllTypesROIAccessor() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = true;
        int dataType = 2;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA;
        this.testOperation(testImageShort, shortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testIntToAllTypesROIAccessor() {
        boolean roiUsed = true;
        boolean noDataPresent = false;
        boolean useRoiAccessor = true;
        int dataType = 3;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA;
        this.testOperation(testImageInt, intToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testByteToAllTypesNoData() {
        boolean roiUsed = false;
        boolean noDataPresent = true;
        boolean useRoiAccessor = false;
        int dataType = 0;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testOperation(testImageByte, byteToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testUshortToAllTypesNoData() {
        boolean roiUsed = false;
        boolean noDataPresent = true;
        boolean useRoiAccessor = false;
        int dataType = 1;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testOperation(testImageUShort, ushortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testShortToAllTypesNoData() {
        boolean roiUsed = false;
        boolean noDataPresent = true;
        boolean useRoiAccessor = false;
        int dataType = 2;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testOperation(testImageShort, shortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testIntToAllTypesNoData() {
        boolean roiUsed = false;
        boolean noDataPresent = true;
        boolean useRoiAccessor = false;
        int dataType = 3;
        TestBase.TestSelection selector = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testOperation(testImageInt, intToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testByteToAllTypesFull() {
        boolean roiUsed = true;
        boolean noDataPresent = true;
        boolean useRoiAccessor = true;
        int dataType = 0;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_NO_DATA;
        this.testOperation(testImageByte, byteToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageByte, byteToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testUshortToAllTypesFull() {
        boolean roiUsed = true;
        boolean noDataPresent = true;
        boolean useRoiAccessor = true;
        int dataType = 1;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_NO_DATA;
        this.testOperation(testImageUShort, ushortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageUShort, ushortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testShortToAllTypesFull() {
        boolean roiUsed = true;
        boolean noDataPresent = true;
        boolean useRoiAccessor = true;
        int dataType = 2;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_NO_DATA;
        this.testOperation(testImageShort, shortToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageShort, shortToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    @Test
    public void testIntToAllTypesFull() {
        boolean roiUsed = true;
        boolean noDataPresent = true;
        boolean useRoiAccessor = true;
        int dataType = 3;
        TestBase.TestSelection selector = TestBase.TestSelection.ROI_ACCESSOR_NO_DATA;
        this.testOperation(testImageInt, intToByteTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToUshortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToShortTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToIntTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToFloatTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
        this.testOperation(testImageInt, intToDoubleTable, roiUsed, noDataPresent, useRoiAccessor, dataType, selector);
    }

    public void testOperation(RenderedImage img, LookupTable table, boolean roiUsed, boolean noDataUsed, boolean useRoiAccessor, int dataTypeInput, TestBase.TestSelection selector) {
        ROIShape roiData = null;
        if (roiUsed) {
            roiData = roi;
        }
        Range noDataRange = null;
        if (noDataUsed) {
            switch (dataTypeInput) {
                case 0: {
                    noDataRange = rangeB;
                    break;
                }
                case 1: {
                    noDataRange = rangeUS;
                    break;
                }
                case 2: {
                    noDataRange = rangeS;
                    break;
                }
                case 3: {
                    noDataRange = rangeI;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        RenderedOp destinationIMG = LookupDescriptor.create((RenderedImage)img, (LookupTable)table, (double)destinationNoDataValue, (ROI)roiData, (Range)noDataRange, (boolean)useRoiAccessor, null);
        if (INTERACTIVE && table.getDataType() == 0 && TEST_SELECTOR.intValue() == selector.getType() && dataTypeInput == 0) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            destinationIMG.getTiles();
        }
        Assert.assertEquals((long)table.getDataType(), (long)destinationIMG.getSampleModel().getDataType());
        if (roiUsed) {
            Rectangle roiBounds = roi.getBounds();
            int roiMaxPosX = roiBounds.x + roiBounds.width - 1;
            int roiMaxPosY = roiBounds.y + roiBounds.height - 1;
            int tileX = destinationIMG.XToTileX(roiMaxPosX);
            int tileY = destinationIMG.YToTileY(roiMaxPosY);
            Raster roiTile = destinationIMG.getTile(tileX, tileY);
            int dataTypeROI = roiTile.getSampleModel().getDataType();
            switch (dataTypeROI) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int value = roiTile.getSample(roiTile.getMinX() + 2, roiTile.getMinY() + 1, 0);
                    Assert.assertFalse((value == (int)destinationNoDataValue ? 1 : 0) != 0);
                    break;
                }
                case 4: {
                    float valuef = roiTile.getSampleFloat(roiTile.getMinX() + 2, roiTile.getMinY() + 1, 0);
                    Assert.assertFalse((valuef == (float)destinationNoDataValue ? 1 : 0) != 0);
                    break;
                }
                case 5: {
                    double valued = roiTile.getSampleDouble(roiTile.getMinX() + 2, roiTile.getMinY() + 1, 0);
                    Assert.assertFalse((valued == destinationNoDataValue ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        Raster simpleTile = destinationIMG.getTile(destinationIMG.getMinTileX(), destinationIMG.getMinTileY());
        int tileMinX = simpleTile.getMinX();
        int tileMinY = simpleTile.getMinY();
        int tileWidth = simpleTile.getWidth();
        int tileHeight = simpleTile.getHeight();
        int dataType = simpleTile.getSampleModel().getDataType();
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int minValue = Integer.MAX_VALUE;
                int maxValue = Integer.MIN_VALUE;
                for (int i = tileMinY; i < tileHeight + tileMinY; ++i) {
                    for (int j = tileMinX; j < tileWidth + tileMinX; ++j) {
                        int value = simpleTile.getSample(j, i, 0);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                        if (value >= minValue) continue;
                        minValue = value;
                    }
                }
                Assert.assertFalse((minValue == maxValue ? 1 : 0) != 0);
                Assert.assertFalse((minValue == Integer.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValue == Integer.MIN_VALUE ? 1 : 0) != 0);
                break;
            }
            case 4: {
                float minValuef = Float.MAX_VALUE;
                float maxValuef = -3.4028235E38f;
                for (int i = 0; i < tileHeight; ++i) {
                    for (int j = 0; j < tileWidth; ++j) {
                        float valuef = simpleTile.getSampleFloat(j, i, 0);
                        if (Float.isNaN(valuef) || valuef == Float.POSITIVE_INFINITY || valuef == Float.POSITIVE_INFINITY) {
                            valuef = 255.0f;
                        }
                        if (valuef > maxValuef) {
                            maxValuef = valuef;
                        }
                        if (!(valuef < minValuef)) continue;
                        minValuef = valuef;
                    }
                }
                Assert.assertFalse((minValuef == maxValuef ? 1 : 0) != 0);
                Assert.assertFalse((minValuef == Float.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValuef == -3.4028235E38f ? 1 : 0) != 0);
                break;
            }
            case 5: {
                double minValued = Double.MAX_VALUE;
                double maxValued = -1.7976931348623157E308;
                for (int i = 0; i < tileHeight; ++i) {
                    for (int j = 0; j < tileWidth; ++j) {
                        double valued = simpleTile.getSampleDouble(j, i, 0);
                        if (Double.isNaN(valued) || valued == Double.POSITIVE_INFINITY || valued == Double.POSITIVE_INFINITY) {
                            valued = 255.0;
                        }
                        if (valued > maxValued) {
                            maxValued = valued;
                        }
                        if (!(valued < minValued)) continue;
                        minValued = valued;
                    }
                }
                Assert.assertFalse((minValued == maxValued ? 1 : 0) != 0);
                Assert.assertFalse((minValued == Double.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValued == -1.7976931348623157E308 ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        if (destinationIMG instanceof RenderedOp) {
            destinationIMG.dispose();
        }
    }
}

