/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.nullop;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.nullop.NullDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static RenderedImage testImage;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        switch (TEST_SELECTOR) {
            case 0: {
                testImage = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1);
                break;
            }
            case 1: {
                testImage = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false, (int)1);
                break;
            }
            case 2: {
                testImage = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1);
                break;
            }
            case 3: {
                testImage = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1);
                break;
            }
            case 4: {
                testImage = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
                break;
            }
            case 5: {
                testImage = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
    }

    @Test
    public void testNullDescriptor() {
        int dataType = TEST_SELECTOR;
        String description = "\n ";
        String stat = "Null";
        description = OLD_DESCRIPTOR ? "Old " + stat : "New " + stat;
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageNull = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                JAIExt.registerJAIDescriptor((String)"Null");
                imageNull = javax.media.jai.operator.NullDescriptor.create((RenderedImage)testImage, null);
            } else {
                imageNull = NullDescriptor.create((RenderedImage)testImage, null);
            }
            long start = System.nanoTime();
            imageNull.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageNull instanceof RenderedOp) {
            imageNull.dispose();
        }
    }
}

