/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.nullop;

import it.geosolutions.jaiext.nullop.NullDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NullOpTest
extends TestBase {
    private static final double TOLERANCE = 0.1;
    private static final int IMAGE_NUMBER = 6;
    private static RenderedImage[] testImage;

    @BeforeClass
    public static void initialSetup() {
        testImage = new RenderedImage[6];
        byte valueB = 50;
        short valueS = 50;
        int valueI = 50;
        float valueF = 50.0f;
        double valueD = 50.0;
        IMAGE_FILLER = true;
        NullOpTest.testImage[0] = NullOpTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)valueB, (boolean)false, (int)1);
        NullOpTest.testImage[1] = NullOpTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)valueS, (boolean)false, (int)1);
        NullOpTest.testImage[2] = NullOpTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)valueS, (boolean)false, (int)1);
        NullOpTest.testImage[3] = NullOpTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)valueI, (boolean)false, (int)1);
        NullOpTest.testImage[4] = NullOpTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(valueF), (boolean)false, (int)1);
        NullOpTest.testImage[5] = NullOpTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)valueD, (boolean)false, (int)1);
        IMAGE_FILLER = false;
    }

    @Test
    public void testNullOperation() {
        this.singleNullOpTest(testImage[0]);
        this.singleNullOpTest(testImage[1]);
        this.singleNullOpTest(testImage[2]);
        this.singleNullOpTest(testImage[3]);
        this.singleNullOpTest(testImage[4]);
        this.singleNullOpTest(testImage[5]);
    }

    private void singleNullOpTest(RenderedImage source) {
        RenderedOp nullImage = NullDescriptor.create((RenderedImage)source, null);
        int minTileX = nullImage.getMinTileX();
        int minTileY = nullImage.getMinTileY();
        Raster upperLeftTile = nullImage.getTile(minTileX, minTileY);
        Raster upperLeftTileOld = source.getTile(minTileX, minTileY);
        int minX = upperLeftTile.getMinX();
        int minY = upperLeftTile.getMinY();
        int maxX = upperLeftTile.getWidth() + minX;
        int maxY = upperLeftTile.getHeight() + minY;
        int minXOld = upperLeftTileOld.getMinX();
        int minYOld = upperLeftTileOld.getMinY();
        int maxXOld = upperLeftTileOld.getWidth() + minXOld;
        int maxYOld = upperLeftTileOld.getHeight() + minYOld;
        Assert.assertEquals((long)minXOld, (long)minX);
        Assert.assertEquals((long)minYOld, (long)minY);
        Assert.assertEquals((long)maxXOld, (long)maxX);
        Assert.assertEquals((long)maxYOld, (long)maxY);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                double value = upperLeftTile.getSampleDouble(x, y, 0);
                double valueOld = upperLeftTileOld.getSampleDouble(x, y, 0);
                Assert.assertEquals((double)value, (double)valueOld, (double)0.1);
            }
        }
    }
}

