/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.scale.Scale2Descriptor;
import it.geosolutions.jaiext.scale.TestScale2;
import it.geosolutions.jaiext.testclasses.TestData;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest2
extends TestScale2 {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final int TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    public static Boolean IMAGE_REDUCTION = Boolean.getBoolean("JAI.Ext.ImageReduction");
    private static final int DEFAULT_SUBSAMPLE_BITS = 8;
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final int DEFAULT_PRECISION_BITS = 8;
    private static double destinationNoData = 0.0;
    private double xTrans = 0.0;
    private double yTrans = 0.0;
    private double xScale = 1.5;
    private double yScale = 1.5;
    private static javax.media.jai.InterpolationNearest interpNearOld;
    private static InterpolationNearest interpNearNew;
    private static javax.media.jai.InterpolationBilinear interpBilOld;
    private static InterpolationBilinear interpBilNew;
    private static javax.media.jai.InterpolationBicubic interpBicOld;
    private static InterpolationBicubic interpBicNew;
    private static RenderedImage image;
    private static RenderingHints hints;

    @BeforeClass
    public static void initialSetup() throws FileNotFoundException, IOException {
        int dataType = 0;
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        File file = TestData.file(ComparisonTest2.class, (String)"testImageLittle.tif");
        pbj.setParameter("Input", (Object)file);
        image = JAI.create((String)"ImageRead", (ParameterBlock)pbj);
        hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        Range rangeND = null;
        if (RANGE_USED) {
            rangeND = RangeFactory.create((byte)100, (boolean)true, (byte)100, (boolean)true);
        }
        interpNearOld = new javax.media.jai.InterpolationNearest();
        interpNearNew = new InterpolationNearest(rangeND, false, destinationNoData, dataType);
        interpBilOld = new javax.media.jai.InterpolationBilinear(8);
        interpBilNew = new InterpolationBilinear(8, rangeND, false, destinationNoData, dataType);
        interpBicOld = new javax.media.jai.InterpolationBicubic(8);
        interpBicNew = new InterpolationBicubic(8, rangeND, false, (double)dataType, dataType, false, 8);
        if (OLD_DESCRIPTOR) {
            JAIExt.registerJAIDescriptor((String)"Scale");
        }
    }

    @Test
    public void testNearestNewScaleDescriptor() {
        if (!OLD_DESCRIPTOR && TEST_SELECTOR == 0) {
            this.testInterpolators((Interpolation)interpNearNew, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNearestOldScaleDescriptor() {
        if (OLD_DESCRIPTOR && TEST_SELECTOR == 0) {
            this.testInterpolators((Interpolation)interpNearOld, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBilinearNewScaleDescriptor() {
        if (!OLD_DESCRIPTOR && TEST_SELECTOR == 1) {
            this.testInterpolators((Interpolation)interpBilNew, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBilinearOldScaleDescriptor() {
        if (OLD_DESCRIPTOR && TEST_SELECTOR == 1) {
            this.testInterpolators((Interpolation)interpBilOld, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBicubicNewScaleDescriptor() {
        if (!OLD_DESCRIPTOR && TEST_SELECTOR == 2) {
            this.testInterpolators((Interpolation)interpBicNew, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBicubicOldScaleDescriptor() {
        if (OLD_DESCRIPTOR && TEST_SELECTOR == 2) {
            this.testInterpolators((Interpolation)interpBicOld, IMAGE_REDUCTION, OLD_DESCRIPTOR);
        }
    }

    public void testInterpolators(Interpolation interp, boolean reductionBoolean, boolean old) {
        double scaleY;
        double scaleX;
        String reduction = "";
        if (reductionBoolean) {
            reduction = "Reduction";
            scaleX = 1.0 / this.xScale;
            scaleY = 1.0 / this.yScale;
        } else {
            reduction = "Magnification";
            scaleX = this.xScale;
            scaleY = this.yScale;
        }
        String description = "";
        if (old) {
            description = "Old Scale";
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            description = "New Scale";
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        String interpType = "";
        if (interp instanceof InterpolationBilinear || interp instanceof javax.media.jai.InterpolationBilinear) {
            interpType = "Bilinear";
        } else if (interp instanceof InterpolationBicubic || interp instanceof javax.media.jai.InterpolationBicubic) {
            interpType = "Bicubic";
        } else if (interp instanceof InterpolationNearest || interp instanceof javax.media.jai.InterpolationNearest) {
            interpType = "Nearest";
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageScale = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            imageScale = old ? ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf((float)scaleX), (Float)Float.valueOf((float)scaleY), (Float)Float.valueOf((float)this.xTrans), (Float)Float.valueOf((float)this.yTrans), (Interpolation)interp, (RenderingHints)hints) : Scale2Descriptor.create((RenderedImage)image, (Double)scaleX, (Double)scaleY, (Double)this.xTrans, (Double)this.yTrans, (Interpolation)interp, null, (Boolean)false, null, null, (RenderingHints)hints);
            long start = System.nanoTime();
            imageScale.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println("\n" + reduction);
        System.out.println("\n" + interpType);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageScale instanceof RenderedOp) {
            imageScale.dispose();
        }
    }
}

