/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.scale.Scale2Descriptor;
import it.geosolutions.jaiext.scale.TestScale2;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BandSelectDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class BilinearScaleTest
extends TestScale2 {
    public static boolean VERBOSE = Boolean.getBoolean("verbose");

    @Test
    public void testImageScaling() {
        boolean roiPresent = false;
        boolean noDataRangeUsed = false;
        boolean isBinary = false;
        boolean bicubic2DIsabled = true;
        boolean useROIAccessor = false;
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.NO_ROI_ONLY_DATA, TestBase.ScaleType.MAGNIFY);
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.NO_ROI_ONLY_DATA, TestBase.ScaleType.REDUCTION);
    }

    @Test
    public void testImageScalingROIAccessor() {
        boolean roiPresent = true;
        boolean noDataRangeUsed = false;
        boolean isBinary = false;
        boolean bicubic2DIsabled = true;
        boolean useROIAccessor = true;
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA, TestBase.ScaleType.MAGNIFY);
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA, TestBase.ScaleType.REDUCTION);
    }

    @Test
    public void testImageScalingROIBounds() {
        boolean roiPresent = true;
        boolean noDataRangeUsed = false;
        boolean isBinary = false;
        boolean bicubic2DIsabled = true;
        boolean useROIAccessor = false;
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ONLY_DATA, TestBase.ScaleType.MAGNIFY);
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ONLY_DATA, TestBase.ScaleType.REDUCTION);
    }

    @Test
    public void testImageScalingTotal() {
        boolean roiPresent = true;
        boolean noDataRangeUsed = true;
        boolean isBinary = false;
        boolean bicubic2DIsabled = true;
        boolean useROIAccessor = true;
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ACCESSOR_NO_DATA, TestBase.ScaleType.MAGNIFY);
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.ROI_ACCESSOR_NO_DATA, TestBase.ScaleType.REDUCTION);
    }

    @Test
    public void testImageScalingBinary() {
        boolean roiPresent = true;
        boolean noDataRangeUsed = true;
        boolean isBinary = true;
        boolean bicubic2DIsabled = true;
        boolean useROIAccessor = true;
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.BINARY_ROI_ACCESSOR_NO_DATA, TestBase.ScaleType.MAGNIFY);
        this.testGlobal(useROIAccessor, isBinary, bicubic2DIsabled, noDataRangeUsed, roiPresent, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.TestSelection.BINARY_ROI_ACCESSOR_NO_DATA, TestBase.ScaleType.REDUCTION);
    }

    @Test
    public void testInterpolationNoDataEdges() {
        int width = 2;
        int height = 2;
        ComponentSampleModel sm = new ComponentSampleModel(0, width, height, 1, 2, new int[]{0});
        TiledImage source = new TiledImage(0, 0, width, height, 0, 0, (SampleModel)sm, PlanarImage.createColorModel((SampleModel)sm));
        int noDataValue = 1;
        source.setSample(0, 0, 0, 255);
        source.setSample(0, 1, 0, 64);
        source.setSample(1, 0, 0, 32);
        source.setSample(1, 1, 0, noDataValue);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        RenderedOp scaled = Scale2Descriptor.create((RenderedImage)source, (Double)2.0, (Double)2.0, (Double)0.0, (Double)0.0, (Interpolation)Interpolation.getInstance((int)1), null, null, (Range)RangeFactory.create((int)noDataValue, (int)noDataValue), null, (RenderingHints)hints);
        Raster raster = scaled.getData();
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        int maxX = minX + raster.getWidth();
        int maxY = minY + raster.getHeight();
        int halfX = (minX + maxX) / 2;
        int halfY = (minY + maxY) / 2;
        for (int i = minY; i < maxY; ++i) {
            for (int j = minX; j < maxX; ++j) {
                int value = raster.getSample(j, i, 0);
                if (i >= halfY && j >= halfX) {
                    Assert.assertTrue((String)"Expected noData value but found different value", (value == noDataValue ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)"Expected valid value but found nodata", (value != noDataValue ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testInterpolationNoDataBleedByte() {
        this.assertNoDataBleedByte(Interpolation.getInstance((int)1));
    }

    @Test
    public void testInterpolationNoDataBleedShort() {
        this.assertNoDataBleedShort(Interpolation.getInstance((int)1));
    }

    @Test
    public void testInterpolationNoDataBleedFloat() {
        this.assertNoDataBleedFloat(Interpolation.getInstance((int)1));
    }

    @Test
    public void testInterpolationNoDataBleedDouble() {
        this.assertNoDataBleedDouble(Interpolation.getInstance((int)1));
    }

    @Test
    public void testInterpolateInHole() {
        this.assertInterpolateInHole(Interpolation.getInstance((int)1));
    }

    @Test
    public void testBilinearInterpolationROI() {
        for (int i = 0; i <= 5; ++i) {
            if (VERBOSE) {
                System.out.println("Testing data type " + i);
            }
            RenderedImage image = this.buildImageWithROI(i, Interpolation.getInstance((int)1), true, null);
            this.assertBilinearInterpolationROI(image);
            if (VERBOSE) {
                System.out.println("Testing data type " + i + " no roi accessor");
            }
            image = this.buildImageWithROI(i, Interpolation.getInstance((int)1), false, null);
            this.assertBilinearInterpolationROI(image);
        }
    }

    @Test
    public void testRecyclingROIWeights() {
        int width = 6;
        int height = 6;
        int bands = 4;
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, width, height, bands, width * bands, new int[]{3, 2, 1, 0});
        TiledImage image = new TiledImage(0, 0, width, height, 0, 0, (SampleModel)sm, PlanarImage.createColorModel((SampleModel)sm));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int i = 0; i < bands; ++i) {
                    image.setSample(x, y, i, x + y);
                }
            }
        }
        this.printValues((RenderedImage)image, image.getData());
        RenderedOp source = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{1, 3}, null);
        Polygon shape = new Polygon();
        shape.addPoint(1, 1);
        shape.addPoint(2, 1);
        shape.addPoint(2, 2);
        shape.addPoint(4, 2);
        shape.addPoint(4, 4);
        shape.addPoint(1, 3);
        shape.addPoint(1, 1);
        ROIShape roi = new ROIShape((Shape)shape);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        double scaleFactor = 1.5;
        int scaledW = (int)(scaleFactor * (double)width);
        int scaledH = (int)(scaleFactor * (double)height);
        hints.put(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(0, 0, scaledW, scaledH, 0, 0, scaledW, scaledH, null, null));
        RenderedOp scaledImage = Scale2Descriptor.create((RenderedImage)source, (Double)scaleFactor, (Double)scaleFactor, (Double)0.0, (Double)0.0, (Interpolation)Interpolation.getInstance((int)1), (ROI)roi, (Boolean)false, null, (double[])new double[]{0.0}, (RenderingHints)hints);
        byte[][] expected = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 3, 4, 5, 5, 0, 0, 0}, {0, 0, 3, 4, 5, 6, 0, 0, 0}, {0, 0, 0, 5, 6, 6, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}};
        Raster data = scaledImage.getData();
        for (int j = 0; j < scaledH; ++j) {
            for (int i = 0; i < scaledW; ++i) {
                Assert.assertEquals((String)("Unexpected value at " + i + " " + j), (long)expected[j][i], (long)data.getSample(i, j, 0));
            }
        }
    }

    public void assertBilinearInterpolationROI(RenderedImage image) {
        Raster data = image.getData();
        this.printValues(image, data);
        for (int r = 0; r < 8; ++r) {
            for (int c = 0; c < 8; ++c) {
                int sample = image.getSampleModel().getDataType() < 4 ? data.getSample(c, r, 0) : (int)Math.round(data.getSampleDouble(c, r, 0));
                if (r < 2 || r > 5 || c < 2 || c > 5) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)0L, (long)sample);
                    continue;
                }
                if (r < 4 && c < 4 && (r != 3 || c != 3)) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)2L, (long)sample);
                    continue;
                }
                if (r < 4 || r < 6 && c < 4) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)3L, (long)sample);
                    continue;
                }
                Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)4L, (long)sample);
            }
        }
    }

    public void printValues(RenderedImage image, Raster data) {
        if (VERBOSE) {
            for (int r = 0; r < image.getHeight(); ++r) {
                for (int c = 0; c < image.getWidth(); ++c) {
                    if (image.getSampleModel().getDataType() < 4) {
                        int sample = data.getSample(c, r, 0);
                        System.out.print(sample + " ");
                        continue;
                    }
                    double sample = data.getSampleDouble(c, r, 0);
                    System.out.print(String.format("%1$8s", sample));
                }
                System.out.println();
            }
        }
    }

    @Test
    public void testBilinearInterpolationROINoData() {
        for (int i = 0; i <= 5; ++i) {
            if (VERBOSE) {
                System.out.println("Testing data type " + i);
            }
            Range noData = RangeFactory.create((int)2, (int)2);
            RenderedImage image = this.buildImageWithROI(i, Interpolation.getInstance((int)1), true, noData);
            this.assertBilinearInterpolationROINoData(image);
            if (VERBOSE) {
                System.out.println("Testing data type " + i + " no roi accessor");
            }
            image = this.buildImageWithROI(i, Interpolation.getInstance((int)1), false, noData);
            this.assertBilinearInterpolationROINoData(image);
        }
    }

    public void assertBilinearInterpolationROINoData(RenderedImage image) {
        Raster data = image.getData();
        this.printValues(image, data);
        for (int r = 0; r < 8; ++r) {
            for (int c = 0; c < 8; ++c) {
                int sample = image.getSampleModel().getDataType() < 4 ? data.getSample(c, r, 0) : (int)Math.round(data.getSampleDouble(c, r, 0));
                if (r < 2 || r > 5 || c < 2 || c > 5 || r < 4 && c < 4) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)0L, (long)sample);
                    continue;
                }
                if (r < 4 && c < 4 && (r != 3 || c != 3)) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)2L, (long)sample);
                    continue;
                }
                if (r < 4 || r < 6 && c < 4) {
                    Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)3L, (long)sample);
                    continue;
                }
                Assert.assertEquals((String)("Unexpected value at " + c + " " + r), (long)4L, (long)sample);
            }
        }
    }

    @Test
    public void testROILayout() {
        this.testROILayout(1);
    }
}

