/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief.cli;

import it.geosolutions.jaiext.shadedrelief.ShadedReliefAlgorithm;
import it.geosolutions.jaiext.shadedrelief.cli.AbstractCommand;
import it.geosolutions.jaiext.shadedrelief.cli.ShadedReliefParams;
import it.geosolutions.jaiext.shadedrelief.cli.ShadedReliefRunner;
import java.io.File;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShadedReliefCommand
extends AbstractCommand {
    private static Logger LOGGER = LogManager.getLogger(ShadedReliefCommand.class);
    public static String OPT_SRCFILE = "f";
    public static String OPT_OUTFILE = "o";
    public static String OPT_SRCNODATA = "sn";
    public static String OPT_DSTNODATA = "dn";
    public static String OPT_RESX = "x";
    public static String OPT_RESY = "y";
    public static String OPT_ZETA = "z";
    public static String OPT_SCALE = "s";
    public static String OPT_ALT = "alt";
    public static String OPT_AZ = "az";
    public static String OPT_ALG = "alg";
    public static String APP_NAME = "shadedrelief";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ShadedReliefParams params;
        LOGGER.info("");
        LOGGER.info("##############################");
        LOGGER.info(" ShadedRelief COMMAND");
        LOGGER.info("##############################");
        LOGGER.debug("Initializing tool...");
        Options options = ShadedReliefCommand.createOptions();
        try {
            params = ShadedReliefCommand.parseParams(options, args);
        }
        catch (AbstractCommand.BadParamException e) {
            LOGGER.warn("Error parsing params: " + e.getMessage());
            HelpFormatter usageFormatter = new HelpFormatter();
            try (PrintWriter pw = new PrintWriter(System.err);){
                System.out.println("");
                usageFormatter.printHelp(APP_NAME + ".sh", "hillshading", options, null, true);
            }
            return;
        }
        ShadedReliefRunner runner = new ShadedReliefRunner(params);
        try {
            runner.run();
        }
        finally {
            LOGGER.info("Exiting...");
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)OPT_SRCFILE).longOpt("in").hasArg().argName("file").desc("Input file").required().build());
        options.addOption(Option.builder((String)OPT_OUTFILE).longOpt("out").hasArg().argName("file").desc("Output file").required().build());
        options.addOption(Option.builder((String)OPT_SRCNODATA).longOpt("srcnodata").hasArg().argName("val").desc("Value of nodata in source file").build());
        options.addOption(Option.builder((String)OPT_DSTNODATA).longOpt("dstnodata").hasArg().argName("val").desc("Value of nodata in out file").build());
        options.addOption(Option.builder((String)OPT_RESX).longOpt("resx").hasArg().argName("val").desc("X resolutions").build());
        options.addOption(Option.builder((String)OPT_RESY).longOpt("resy").hasArg().argName("val").desc("Y resolution").build());
        options.addOption(Option.builder((String)OPT_ZETA).longOpt("zeta").hasArg().argName("val").desc("Vertical relief factor (exaggeration)").build());
        options.addOption(Option.builder((String)OPT_SCALE).longOpt("scale").hasArg().argName("val").desc("Elevation unit to 2D unit scale ratio").build());
        options.addOption(Option.builder((String)OPT_ALT).longOpt("alt").hasArg().argName("val").desc("Sun altitude").build());
        options.addOption(Option.builder((String)OPT_AZ).longOpt("azimuth").hasArg().argName("val").desc("Sun azimuth").build());
        options.addOption(Option.builder((String)OPT_ALG).longOpt("algorithm").hasArg().argName("algorithm").desc("Algorithm. May be ZT, ZTC, C").build());
        return options;
    }

    private static ShadedReliefParams parseParams(Options options, String[] args) throws AbstractCommand.BadParamException {
        double d;
        CommandLine cl;
        try {
            cl = new DefaultParser().parse(options, args);
            ShadedReliefCommand.dumpParams(cl, options);
        }
        catch (ParseException ex) {
            throw new AbstractCommand.BadParamException("Error parsing args: " + ex.getMessage(), ex);
        }
        ShadedReliefParams params = new ShadedReliefParams();
        File inputFile = ShadedReliefCommand.validateFile(cl.getOptionValue(OPT_SRCFILE));
        params.setInputFile(inputFile);
        File outputFile = new File(cl.getOptionValue(OPT_OUTFILE));
        params.setOutputFile(outputFile);
        if (cl.hasOption(OPT_SRCNODATA)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_SRCNODATA));
            params.setSrcNoData(d);
        } else {
            params.setSrcNoData(null);
        }
        if (cl.hasOption(OPT_DSTNODATA)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_DSTNODATA));
            params.setDstNoData(d);
        } else {
            params.setDstNoData(0.0);
        }
        if (cl.hasOption(OPT_RESX)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_RESX));
            params.setResX(d);
        } else {
            params.setResX(1.0);
        }
        if (cl.hasOption(OPT_RESY)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_RESY));
            params.setResY(d);
        } else {
            params.setResY(1.0);
        }
        if (cl.hasOption(OPT_ZETA)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_ZETA));
            params.setZetaFactor(d);
        } else {
            params.setZetaFactor(25.0);
        }
        if (cl.hasOption(OPT_SCALE)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_SCALE));
            params.setScale(d);
        } else {
            params.setScale(111120.0);
        }
        if (cl.hasOption(OPT_ALT)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_ALT));
            params.setAltitude(d);
        } else {
            params.setAltitude(45.0);
        }
        if (cl.hasOption(OPT_AZ)) {
            d = ShadedReliefCommand.validateDouble(cl.getOptionValue(OPT_AZ));
            params.setAzimuth(d);
        } else {
            params.setAzimuth(315.0);
        }
        if (cl.hasOption(OPT_ALG)) {
            switch (cl.getOptionValue(OPT_ALG)) {
                case "ZT": {
                    params.setAlgo(ShadedReliefAlgorithm.ZEVENBERGEN_THORNE);
                    break;
                }
                case "ZTC": {
                    params.setAlgo(ShadedReliefAlgorithm.ZEVENBERGEN_THORNE_COMBINED);
                    break;
                }
                case "C": {
                    params.setAlgo(ShadedReliefAlgorithm.COMBINED);
                    break;
                }
                default: {
                    throw new AbstractCommand.BadParamException("Unknown algorithm " + cl.getOptionValue(OPT_ALG));
                }
            }
        } else {
            params.setAlgo(ShadedReliefAlgorithm.DEFAULT);
        }
        return params;
    }
}

