/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief.cli;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefAlgorithm;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefDescriptor;
import it.geosolutions.jaiext.shadedrelief.cli.ShadedReliefParams;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.RenderedOp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShadedReliefRunner {
    private static final Logger LOGGER = LogManager.getLogger(ShadedReliefRunner.class);
    private final ShadedReliefParams params;

    public ShadedReliefRunner(ShadedReliefParams params) {
        this.params = params;
    }

    public void run() throws IOException {
        LOGGER.info("Running " + this.getClass().getSimpleName() + " with params " + this.params);
        File out = this.params.getOutputFile();
        File in = this.params.getInputFile();
        BufferedImage bi = ImageIO.read(in);
        Double snd = this.params.getSrcNoData();
        Range srcNoDataRange = snd == null ? null : RangeFactory.create((double)snd, (boolean)true, (double)snd, (boolean)true, (boolean)true);
        RenderingHints hints = null;
        JAIExt.initJAIEXT();
        RenderedOp finalImage = ShadedReliefDescriptor.create((RenderedImage)bi, null, (Range)srcNoDataRange, (double)this.params.getDstNoData(), (double)this.params.getResX(), (double)this.params.getResY(), (double)this.params.getZetaFactor(), (double)this.params.getScale(), (double)this.params.getAltitude(), (double)this.params.getAzimuth(), (ShadedReliefAlgorithm)this.params.getAlgo(), hints);
        ImageIO.write((RenderedImage)finalImage, "tif", out);
    }
}

