/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.contrastenhancement;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class SquareRootStretchOpImage
extends PointOpImage {
    protected int[] inputMin;
    protected int[] inputMax;
    protected int[] outputMin;
    protected int[] outputMax;

    public SquareRootStretchOpImage(RenderedImage source, Map config, ImageLayout layout, int[] inputMin, int[] inputMax, int[] outputMin, int[] outputMax) {
        super(source, layout, config, true);
        int i;
        int numBands = this.getSampleModel().getNumBands();
        if (inputMin.length < numBands) {
            this.inputMin = new int[numBands];
            for (i = 0; i < numBands; ++i) {
                this.inputMin[i] = inputMin[0];
            }
        } else {
            this.inputMin = (int[])inputMin.clone();
        }
        if (inputMax.length < numBands) {
            this.inputMax = new int[numBands];
            for (i = 0; i < numBands; ++i) {
                this.inputMax[i] = inputMax[0];
            }
        } else {
            this.inputMax = (int[])inputMax.clone();
        }
        if (outputMin.length < numBands) {
            this.outputMin = new int[numBands];
            for (i = 0; i < numBands; ++i) {
                this.outputMin[i] = outputMin[0];
            }
        } else {
            this.outputMin = (int[])outputMin.clone();
        }
        if (outputMax.length < numBands) {
            this.outputMax = new int[numBands];
            for (i = 0; i < numBands; ++i) {
                this.outputMax[i] = outputMax[0];
            }
        } else {
            this.outputMax = (int[])outputMax.clone();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSource(0).getColorModel());
        switch (dst.getDataType()) {
            case 0: {
                this.computeRectByte(src, dst);
                break;
            }
            case 1: {
                this.computeRectUShort(src, dst);
                break;
            }
            case 2: {
                this.computeRectShort(src, dst);
                break;
            }
            case 3: {
                this.computeRectInt(src, dst);
            }
        }
        if (dst.needsClamping()) {
            dst.clampDataArrays();
        }
        dst.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        for (int b = 0; b < dstBands; ++b) {
            float c = this.inputMin[b];
            byte[] d = dstData[b];
            byte[] s = srcData[b];
            int dstLineOffset = dstBandOffsets[b];
            int srcLineOffset = srcBandOffsets[b];
            for (int h = 0; h < dstHeight; ++h) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    d[dstPixelOffset] = ImageUtil.clampRoundByte((float)((float)(s[srcPixelOffset] & 0xFF) * c));
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int val = 0;
        for (int b = 0; b < dstBands; ++b) {
            short[] d = dstData[b];
            short[] s = srcData[b];
            int inMin = this.inputMin[b];
            int inMax = this.inputMax[b];
            int outMin = this.outputMin[b];
            int outMax = this.outputMax[b];
            int dstLineOffset = dstBandOffsets[b];
            int srcLineOffset = srcBandOffsets[b];
            for (int h = 0; h < dstHeight; ++h) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    val = s[srcPixelOffset] >= inMin ? s[srcPixelOffset] - inMin : 0;
                    d[dstPixelOffset] = ImageUtil.clampRoundUShort((double)(Math.sqrt(val / (inMax - inMin)) * (double)outMax + (double)outMin));
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        double val = 0.0;
        for (int b = 0; b < dstBands; ++b) {
            int inMin = this.inputMin[b];
            int inMax = this.inputMax[b];
            int outMin = this.outputMin[b];
            int outMax = this.outputMax[b];
            short[] d = dstData[b];
            short[] s = srcData[b];
            int dstLineOffset = dstBandOffsets[b];
            int srcLineOffset = srcBandOffsets[b];
            for (int h = 0; h < dstHeight; ++h) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    val = s[srcPixelOffset] >= inMin ? s[srcPixelOffset] - inMin : 0;
                    d[dstPixelOffset] = ImageUtil.clampRoundShort((double)(Math.sqrt(val / (double)(inMax - inMin)) * (double)outMax + (double)outMin));
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        double val = 0.0;
        for (int b = 0; b < dstBands; ++b) {
            int inMin = this.inputMin[b];
            int inMax = this.inputMax[b];
            int outMin = this.outputMin[b];
            int outMax = this.outputMax[b];
            int[] d = dstData[b];
            int[] s = srcData[b];
            int dstLineOffset = dstBandOffsets[b];
            int srcLineOffset = srcBandOffsets[b];
            for (int h = 0; h < dstHeight; ++h) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    val = s[srcPixelOffset] >= inMin ? s[srcPixelOffset] - inMin : 0;
                    d[dstPixelOffset] = ImageUtil.clampRoundInt((double)(Math.sqrt(val / (double)(inMax - inMin)) * (double)outMax + (double)outMin));
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }
}

