/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CompleteStatsTest
extends TestBase {
    private static final double TOLERANCE = 0.1;
    private static int xPeriod;
    private static int yPeriod;
    private static ROI roi;
    private static byte noDataB;
    private static short noDataU;
    private static short noDataS;
    private static int noDataI;
    private static float noDataF;
    private static double noDataD;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static Statistics.StatsType[] simpleStats;
    private static Statistics.StatsType[] complexStats;
    private static int[] band1;
    private static int[] band2;
    private static RenderedImage[] sourceIMG;
    private static double[][] calculations;
    private static long[] numSamples;
    private static double[][] hist;
    private static double[] minBound;
    private static double[] maxBound;
    private static double[] binInterval;
    private static int[] numBins;
    private static Range[] interval;
    private static List<Double>[] listData;

    @BeforeClass
    public static void initialSetup() {
        xPeriod = 1;
        yPeriod = 1;
        minBound = new double[]{-3.0, -3.0, -3.0};
        maxBound = new double[]{3.0, 3.0, 3.0};
        numBins = new int[]{4, 4, 4};
        double binInterval0 = (maxBound[0] - minBound[0]) / (double)numBins[0];
        binInterval = new double[]{binInterval0, binInterval0, binInterval0};
        interval = new Range[3];
        CompleteStatsTest.interval[0] = RangeFactory.create((double)minBound[0], (boolean)true, (double)maxBound[0], (boolean)false, (boolean)false);
        CompleteStatsTest.interval[1] = RangeFactory.create((double)minBound[1], (boolean)true, (double)maxBound[1], (boolean)false, (boolean)false);
        CompleteStatsTest.interval[2] = RangeFactory.create((double)minBound[2], (boolean)true, (double)maxBound[2], (boolean)false, (boolean)false);
        hist = new double[numBins[0]][4];
        listData = new List[4];
        for (int i = 0; i < listData.length; ++i) {
            CompleteStatsTest.listData[i] = new ArrayList<Double>();
        }
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roi = new ROIShape((Shape)roiBounds);
        noDataB = (byte)50;
        noDataU = (short)50;
        noDataS = (short)50;
        noDataI = 50;
        noDataF = 50.0f;
        noDataD = 50.0;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataU, (boolean)minIncluded, (short)noDataU, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        simpleStats = new Statistics.StatsType[]{Statistics.StatsType.MEAN, Statistics.StatsType.SUM, Statistics.StatsType.MAX, Statistics.StatsType.MIN, Statistics.StatsType.EXTREMA, Statistics.StatsType.VARIANCE, Statistics.StatsType.DEV_STD};
        complexStats = new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM, Statistics.StatsType.MODE, Statistics.StatsType.MEDIAN};
        int[] array1Band = new int[]{0};
        int[] array2Band = new int[]{0, 2};
        band1 = array1Band;
        band2 = array2Band;
        sourceIMG = new RenderedImage[6];
        CompleteStatsTest.sourceIMG[0] = CompleteStatsTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)3, (Number)64);
        CompleteStatsTest.sourceIMG[1] = CompleteStatsTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataU, (boolean)false, (int)3, (Number)64);
        CompleteStatsTest.sourceIMG[2] = CompleteStatsTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)3, (Number)64);
        CompleteStatsTest.sourceIMG[3] = CompleteStatsTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)3, (Number)64);
        CompleteStatsTest.sourceIMG[4] = CompleteStatsTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)3, (Number)64);
        CompleteStatsTest.sourceIMG[5] = CompleteStatsTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)3, (Number)64);
        numSamples = new long[4];
        calculations = new double[9][4];
        int minTileX = sourceIMG[0].getMinTileX();
        int minTileY = sourceIMG[0].getMinTileY();
        int maxTileX = minTileX + sourceIMG[0].getNumXTiles();
        int maxTileY = minTileY + sourceIMG[0].getNumYTiles();
        CompleteStatsTest.calculations[2][0] = Double.NEGATIVE_INFINITY;
        CompleteStatsTest.calculations[2][1] = Double.NEGATIVE_INFINITY;
        CompleteStatsTest.calculations[2][2] = Double.NEGATIVE_INFINITY;
        CompleteStatsTest.calculations[2][3] = Double.NEGATIVE_INFINITY;
        CompleteStatsTest.calculations[3][0] = Double.POSITIVE_INFINITY;
        CompleteStatsTest.calculations[3][1] = Double.POSITIVE_INFINITY;
        CompleteStatsTest.calculations[3][2] = Double.POSITIVE_INFINITY;
        CompleteStatsTest.calculations[3][3] = Double.POSITIVE_INFINITY;
        for (int i = minTileX; i < maxTileX; ++i) {
            for (int j = minTileY; j < maxTileY; ++j) {
                Raster arrayRas = sourceIMG[0].getTile(i, j);
                int minX = arrayRas.getMinX();
                int minY = arrayRas.getMinY();
                int maxX = minX + arrayRas.getWidth();
                int maxY = minY + arrayRas.getHeight();
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        byte value = (byte)arrayRas.getSample(x, y, 0);
                        block11: for (int z = 0; z < 4; ++z) {
                            switch (z) {
                                case 0: {
                                    int n = z;
                                    numSamples[n] = numSamples[n] + 1L;
                                    double[] dArray = calculations[1];
                                    int n2 = z;
                                    dArray[n2] = dArray[n2] + (double)value;
                                    double[] dArray2 = calculations[4];
                                    int n3 = z;
                                    dArray2[n3] = dArray2[n3] + (double)(value * value);
                                    if ((double)value > calculations[2][z]) {
                                        CompleteStatsTest.calculations[2][z] = value;
                                    }
                                    if ((double)value < calculations[3][z]) {
                                        CompleteStatsTest.calculations[3][z] = value;
                                    }
                                    if (!interval[0].contains((double)value)) continue block11;
                                    int index = CompleteStatsTest.getIndex(value);
                                    double[] dArray3 = hist[index];
                                    int n4 = z;
                                    dArray3[n4] = dArray3[n4] + 1.0;
                                    listData[z].add(Double.valueOf(value));
                                    continue block11;
                                }
                                case 1: {
                                    if (!roi.contains(x, y)) continue block11;
                                    int n = z;
                                    numSamples[n] = numSamples[n] + 1L;
                                    double[] dArray = calculations[1];
                                    int n5 = z;
                                    dArray[n5] = dArray[n5] + (double)value;
                                    double[] dArray4 = calculations[4];
                                    int n6 = z;
                                    dArray4[n6] = dArray4[n6] + (double)(value * value);
                                    if ((double)value > calculations[2][z]) {
                                        CompleteStatsTest.calculations[2][z] = value;
                                    }
                                    if ((double)value < calculations[3][z]) {
                                        CompleteStatsTest.calculations[3][z] = value;
                                    }
                                    if (!interval[0].contains((double)value)) continue block11;
                                    int index = CompleteStatsTest.getIndex(value);
                                    double[] dArray5 = hist[index];
                                    int n7 = z;
                                    dArray5[n7] = dArray5[n7] + 1.0;
                                    listData[z].add(Double.valueOf(value));
                                    continue block11;
                                }
                                case 2: {
                                    if (noDataByte.contains(value)) continue block11;
                                    int n = z;
                                    numSamples[n] = numSamples[n] + 1L;
                                    double[] dArray = calculations[1];
                                    int n8 = z;
                                    dArray[n8] = dArray[n8] + (double)value;
                                    double[] dArray6 = calculations[4];
                                    int n9 = z;
                                    dArray6[n9] = dArray6[n9] + (double)(value * value);
                                    if ((double)value > calculations[2][z]) {
                                        CompleteStatsTest.calculations[2][z] = value;
                                    }
                                    if ((double)value < calculations[3][z]) {
                                        CompleteStatsTest.calculations[3][z] = value;
                                    }
                                    if (!interval[0].contains((double)value)) continue block11;
                                    int index = CompleteStatsTest.getIndex(value);
                                    double[] dArray7 = hist[index];
                                    int n10 = z;
                                    dArray7[n10] = dArray7[n10] + 1.0;
                                    listData[z].add(Double.valueOf(value));
                                    continue block11;
                                }
                                case 3: {
                                    if (noDataByte.contains(value) || !roi.contains(x, y)) continue block11;
                                    int n = z;
                                    numSamples[n] = numSamples[n] + 1L;
                                    double[] dArray = calculations[1];
                                    int n11 = z;
                                    dArray[n11] = dArray[n11] + (double)value;
                                    double[] dArray8 = calculations[4];
                                    int n12 = z;
                                    dArray8[n12] = dArray8[n12] + (double)(value * value);
                                    if ((double)value > calculations[2][z]) {
                                        CompleteStatsTest.calculations[2][z] = value;
                                    }
                                    if ((double)value < calculations[3][z]) {
                                        CompleteStatsTest.calculations[3][z] = value;
                                    }
                                    if (!interval[0].contains((double)value)) continue block11;
                                    int index = CompleteStatsTest.getIndex(value);
                                    double[] dArray9 = hist[index];
                                    int n13 = z;
                                    dArray9[n13] = dArray9[n13] + 1.0;
                                    listData[z].add(Double.valueOf(value));
                                }
                            }
                        }
                    }
                }
            }
        }
        for (int h = 0; h < 6; ++h) {
            for (int z = 0; z < 4; ++z) {
                CompleteStatsTest.calculations[0][z] = numSamples[z] == 1L ? calculations[1][z] / (double)numSamples[z] : calculations[1][z] / (double)(numSamples[z] - 1L);
                CompleteStatsTest.calculations[5][z] = (calculations[4][z] - calculations[1][z] * calculations[1][z] / (double)numSamples[z]) / (double)(numSamples[z] - 1L);
                CompleteStatsTest.calculations[6][z] = Math.sqrt(calculations[5][z]);
                Collections.sort(listData[z]);
                int listSize = listData[z].size();
                if (listSize == 0) {
                    CompleteStatsTest.calculations[8][z] = Double.NaN;
                } else if (listSize == 1) {
                    CompleteStatsTest.calculations[8][z] = listData[z].get(0);
                } else {
                    int halfSize = listSize / 2;
                    double halfValue = listData[z].get(halfSize);
                    CompleteStatsTest.calculations[8][z] = listData[z].size() % 2 == 1 ? halfValue : (halfValue + listData[z].get(halfSize + 1)) / 2.0;
                }
                double max = Double.NEGATIVE_INFINITY;
                double indexMax = 0.0;
                for (int i = 0; i < numBins[0]; ++i) {
                    if (!(hist[i][z] > max)) continue;
                    max = hist[i][z];
                    indexMax = i;
                }
                if (max != 0.0) {
                    indexMax += minBound[0];
                }
                CompleteStatsTest.calculations[7][z] = indexMax;
            }
        }
    }

    @Test
    public void testNoRangeNoRoi() {
        boolean roiUsed = false;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = false;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    @Test
    public void testRoiBounds() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = false;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    @Test
    public void testRoiAccessor() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = true;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = false;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    @Test
    public void testRoiNoData() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = false;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    @Test
    public void testRoiAccessorNoData() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = true;
        this.testStatistics(sourceIMG[0], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band1, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[0], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[1], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[2], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[3], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[4], band2, roiUsed, noDataRangeUsed, useROIAccessor);
        this.testStatistics(sourceIMG[5], band2, roiUsed, noDataRangeUsed, useROIAccessor);
    }

    public void testStatistics(RenderedImage source, int[] bands, boolean roiUsed, boolean noDataRangeUsed, boolean useRoiAccessor) {
        Statistics stat;
        int i;
        Range noDataRange;
        Object roiData = roiUsed ? roi : null;
        if (noDataRangeUsed) {
            int dataType = source.getSampleModel().getDataType();
            switch (dataType) {
                case 0: {
                    noDataRange = noDataByte;
                    break;
                }
                case 1: {
                    noDataRange = noDataUShort;
                    break;
                }
                case 2: {
                    noDataRange = noDataShort;
                    break;
                }
                case 3: {
                    noDataRange = noDataInt;
                    break;
                }
                case 4: {
                    noDataRange = noDataFloat;
                    break;
                }
                case 5: {
                    noDataRange = noDataDouble;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        } else {
            noDataRange = null;
        }
        int statsIndex = 0;
        if (roiUsed && noDataRangeUsed) {
            statsIndex = 3;
        } else if (roiUsed) {
            statsIndex = 1;
        } else if (noDataRangeUsed) {
            statsIndex = 2;
        }
        RenderedOp dstSimple = StatisticsDescriptor.create((RenderedImage)source, (int)xPeriod, (int)yPeriod, (ROI)roiData, (Range)noDataRange, (boolean)useRoiAccessor, (int[])bands, (Statistics.StatsType[])simpleStats, null);
        Statistics[][] resultSimple = (Statistics[][])dstSimple.getProperty("JAI-EXT.stats");
        RenderedOp dstComplex = StatisticsDescriptor.create((RenderedImage)source, (int)xPeriod, (int)yPeriod, (ROI)roiData, (Range)noDataRange, (boolean)useRoiAccessor, (int[])bands, (Statistics.StatsType[])complexStats, (double[])minBound, (double[])maxBound, (int[])numBins, null);
        Statistics[][] resultComplex = (Statistics[][])dstComplex.getProperty("JAI-EXT.stats");
        Statistics[] stats0 = resultSimple[0];
        Statistics[] stats02 = resultComplex[0];
        block16: for (i = 0; i < stats0.length; ++i) {
            stat = stats0[i];
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    double value = (Double)stat.getResult();
                    Assert.assertEquals((double)calculations[i][statsIndex], (double)value, (double)0.1);
                    continue block16;
                }
                case 4: {
                    double[] extrema = (double[])stat.getResult();
                    double max = extrema[1];
                    double min = extrema[0];
                    Assert.assertEquals((double)calculations[2][statsIndex], (double)max, (double)0.1);
                    Assert.assertEquals((double)calculations[3][statsIndex], (double)min, (double)0.1);
                }
            }
        }
        block17: for (i = 0; i < stats02.length; ++i) {
            stat = stats02[i];
            switch (i + 7) {
                case 7: {
                    double[] hist2 = (double[])stat.getResult();
                    for (int j = 0; j < numBins[0]; ++j) {
                        Assert.assertEquals((double)hist[i][statsIndex], (double)hist2[i], (double)0.1);
                    }
                    continue block17;
                }
                case 8: 
                case 9: {
                    double value = (Double)stat.getResult();
                    Assert.assertEquals((double)calculations[i + 6][statsIndex], (double)value, (double)0.1);
                }
            }
        }
    }

    private static int getIndex(double sample) {
        int index = (int)((sample - minBound[0]) / binInterval[0]);
        return index;
    }
}

