/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.configs;

import it.geosolutions.mapstore.controllers.BaseConfigController;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConfigsController
extends BaseConfigController {
    @RequestMapping(value={"/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] loadResource(@PathVariable(value="resource") String resourceName, @RequestParam(value="overrides", defaultValue="true") boolean applyOverrides) throws IOException {
        String sanitizedResourceName = this.sanitizeResourceName(resourceName);
        Path configPath = Paths.get(this.getConfigsFolder(), this.normalizedFilePath(sanitizedResourceName, "json"));
        Path patchPath = Paths.get(this.getConfigsFolder(), this.normalizePatchExtension(sanitizedResourceName, "json", "patch"));
        this.validatePathWithinConfigDirectory(configPath);
        this.validatePathWithinConfigDirectory(patchPath);
        return this.toBytes(this.readResource(configPath.toString(), applyOverrides, patchPath.toString()));
    }

    private String sanitizeResourceName(String resourceName) throws IOException {
        if (resourceName.contains("..") || resourceName.contains(File.separator)) {
            throw new IOException("Invalid resource name: Directory traversal attempt detected.");
        }
        return resourceName;
    }

    private String normalizedFilePath(String name, String extension) {
        if (!name.toLowerCase().endsWith("." + extension)) {
            return name + "." + extension;
        }
        return name;
    }

    private String normalizePatchExtension(String name, String extension, String patchExtension) {
        if (name.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return name + "." + patchExtension;
        }
        return name + "." + extension + "." + patchExtension;
    }

    private void validatePathWithinConfigDirectory(Path path) throws IOException {
        Path baseDir = Paths.get(this.getConfigsFolder(), new String[0]).toAbsolutePath().normalize();
        if (!path.toAbsolutePath().normalize().startsWith(baseDir)) {
            throw new IOException("Access to the specified resource is denied.");
        }
    }
}

