/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.rest.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import it.geosolutions.mapstore.controllers.BaseConfigController;
import it.geosolutions.mapstore.controllers.rest.config.SetParamsUUIDStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SetParamsController
extends BaseConfigController {
    private static final String PAGE_PARAM = "page";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String DEF_PAGE = "../../#viewer/openlayers/config";
    private SetParamsUUIDStrategy uuidStrategy = new DefUUIDGenerationStrategy();

    @RequestMapping(value={"/setParams"}, method={RequestMethod.POST}, consumes={"application/json", "application/x-www-form-urlencoded"})
    public void setParams(HttpServletRequest request, HttpServletResponse response, @RequestHeader(value="Content-Type") String contentType) throws IOException {
        JsonNode node = contentType.equals("application/x-www-form-urlencoded") ? this.formEncodedToJSON(new HttpServletRequestInput(request)) : this.toJSON(request);
        String jsString = StringEscapeUtils.escapeEcmaScript((String)node.toString());
        response.setContentType("text/html");
        String uuid = this.getUUID();
        String itemName = QUERY_PARAMS.concat("-").concat(uuid);
        PrintWriter out = response.getWriter();
        out.write("<html><head>");
        out.write("<meta charset=\"UTF-8\">");
        out.write("<script>");
        out.write("let params=".concat("'").concat(jsString).concat("'; "));
        out.write("sessionStorage.setItem(\"".concat(itemName).concat("\",params); "));
        String location = this.buildRedirectUrl(node, uuid);
        out.write("location.href=\"".concat(location).concat("\"; "));
        out.write("</script></head><body></body></html>");
    }

    private String buildRedirectUrl(JsonNode node, String uuid) {
        String page = this.getPage(node);
        StringBuilder location = new StringBuilder(page);
        if (!this.containsQueryString(page)) {
            location.append("?");
        } else {
            location.append("&");
        }
        location.append("queryParamsID=").append(uuid);
        return location.toString();
    }

    private boolean containsQueryString(String page) {
        try {
            URI url = new URI(page);
            String queryString = url.getQuery();
            return !StringUtils.isBlank((CharSequence)queryString);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String getPage(JsonNode node) {
        String pageStr = null;
        if (node.has(PAGE_PARAM)) {
            JsonNode pageNode = node.get(PAGE_PARAM);
            if (pageNode != null && !(pageNode instanceof NullNode) && !(pageNode instanceof ValueNode)) {
                String error = "The page JSON attribute should be a string value.";
                throw new UnsupportedOperationException(error);
            }
            if (pageNode instanceof TextNode) {
                pageStr = pageNode.asText();
            }
        }
        if (pageStr == null) {
            pageStr = DEF_PAGE;
        }
        return pageStr;
    }

    private JsonNode formEncodedToJSON(HttpInputMessage message) throws IOException {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        MultiValueMap result = converter.read(null, message);
        Map map = result.toSingleValueMap();
        return this.mapToJSONObject(map);
    }

    private ObjectNode mapToJSONObject(Map<String, String> map) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNodeFactory factory = new JsonNodeFactory(false);
        ObjectNode resultJSON = factory.objectNode();
        for (String k : map.keySet()) {
            if (k.equals(PAGE_PARAM)) {
                resultJSON.set(k, (JsonNode)factory.textNode(map.get(k)));
                continue;
            }
            String val = map.get(k);
            try {
                JsonNode node = mapper.readTree(val);
                resultJSON.set(k, node);
            }
            catch (JsonProcessingException e) {
                resultJSON.set(k, (JsonNode)factory.textNode(val));
            }
        }
        return resultJSON;
    }

    private JsonNode toJSON(HttpServletRequest request) throws IOException {
        String jsonStr = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(jsonStr);
    }

    private String getUUID() {
        return this.uuidStrategy.generateUUID();
    }

    void setUuidStrategy(SetParamsUUIDStrategy uuidStrategy) {
        this.uuidStrategy = uuidStrategy;
    }

    private class DefUUIDGenerationStrategy
    implements SetParamsUUIDStrategy {
        private DefUUIDGenerationStrategy() {
        }

        @Override
        public String generateUUID() {
            return UUID.randomUUID().toString();
        }
    }

    private class HttpServletRequestInput
    implements HttpInputMessage {
        private HttpServletRequest request;

        HttpServletRequestInput(HttpServletRequest request) {
            this.request = request;
        }

        public InputStream getBody() throws IOException {
            return this.request.getInputStream();
        }

        public HttpHeaders getHeaders() {
            HttpHeaders headers = new HttpHeaders();
            Enumeration names = this.request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                headers.put(name, Collections.list(this.request.getHeaders(name)));
            }
            return headers;
        }
    }
}

