/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import it.geosolutions.mapstore.controllers.BaseMapStoreController;
import it.geosolutions.mapstore.utils.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public abstract class BaseConfigController
extends BaseMapStoreController {
    protected ObjectMapper jsonMapper = new ObjectMapper();

    public byte[] loadAsset(String resourcePath) throws IOException {
        return this.toBytes(this.readResource(resourcePath, false, ""));
    }

    protected InputStream toStream(Resource resource) throws IOException {
        if (resource.data != null) {
            byte[] bytes = this.toBytes(resource);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return in;
        }
        if (resource.file != null) {
            return new FileInputStream(resource.file);
        }
        return null;
    }

    protected byte[] toBytes(Resource resource) throws UnsupportedEncodingException {
        return resource.data.getBytes("UTF-8");
    }

    protected Resource readResource(String resourceName, boolean applyOverrides, String patchName) throws IOException {
        Optional<File> resourcePatch;
        Optional<File> resource = ResourceUtils.findResource(this.getDataDir(), this.getContext(), resourceName);
        Optional<File> optional = resourcePatch = patchName.isEmpty() ? Optional.empty() : ResourceUtils.findResource(this.getDataDir(), this.getContext(), patchName);
        if (!resource.isPresent()) {
            throw new ResourceNotFoundException(resourceName);
        }
        return this.readResourceFromFile(resource.get(), applyOverrides, resourcePatch);
    }

    protected Resource readResourceFromFile(File file, boolean applyOverrides, Optional<File> patch) throws IOException {
        Resource resource = new Resource();
        resource.file = file;
        MimeType type = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((File)file));
        resource.type = type != null ? type.toString() : null;
        try (Stream<String> stream = Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);){
            Properties props = this.readOverrides();
            if (applyOverrides && (!"".equals(this.getMappings()) && props != null || patch.isPresent())) {
                resource.data = this.resourceWithPatch(stream, props, patch);
                Resource resource2 = resource;
                return resource2;
            }
            try {
                final StringBuilder contentBuilder = new StringBuilder();
                stream.forEach(new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        contentBuilder.append(s).append("\n");
                    }
                });
                resource.data = contentBuilder.toString();
            }
            catch (Exception e) {
                resource.file = file;
            }
            Resource resource3 = resource;
            return resource3;
        }
    }

    protected String resourceWithPatch(Stream<String> stream, Properties props, Optional<File> patch) throws IOException {
        JsonNode jsonObject = this.readJsonConfig(stream);
        if (patch.isPresent()) {
            jsonObject = this.mergeJSON(jsonObject, (JsonPatch)this.jsonMapper.readValue(patch.get(), JsonPatch.class));
        }
        if (!"".equals(this.getMappings()) && props != null) {
            for (String mapping : this.getMappings().split(",")) {
                jsonObject = this.fillMapping(mapping, props, jsonObject);
            }
        }
        return jsonObject.toString();
    }

    protected JsonNode mergeJSON(JsonNode orig, JsonPatch patch) throws IOException {
        try {
            return patch.apply(orig);
        }
        catch (JsonPatchException e) {
            throw new IOException("Error applying patch", e);
        }
    }

    protected Properties readOverrides() throws FileNotFoundException, IOException {
        Optional<File> resource;
        if (!"".equals(this.getOverrides()) && (resource = ResourceUtils.findResource(this.getDataDir(), this.getContext(), this.getOverrides())).isPresent()) {
            try (FileReader reader = new FileReader(resource.get());){
                Properties props = new Properties();
                props.load(reader);
                Properties properties = props;
                return properties;
            }
        }
        return null;
    }

    protected JsonNode readJsonConfig(Stream<String> stream) throws IOException {
        final StringBuilder contentBuilder = new StringBuilder();
        stream.forEach(new Consumer<String>(){

            @Override
            public void accept(String s) {
                contentBuilder.append(s).append("\n");
            }
        });
        String json = contentBuilder.toString();
        JsonNode jsonObject = this.jsonMapper.readTree(json);
        return jsonObject;
    }

    protected JsonNode fillMapping(String mapping, Properties props, JsonNode jsonObject) throws IOException {
        String[] parts = mapping.split("=");
        if (parts.length != 2 || parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) {
            return jsonObject;
        }
        String path = parts[0];
        String propName = parts[1];
        String value = props.getProperty(propName, "");
        return this.setJsonProperty(jsonObject, path.split("\\."), value);
    }

    protected JsonNode setJsonProperty(JsonNode jsonObject, String[] path, String value) throws IOException {
        String propertyPath = "/" + StringUtils.join((Object[])path, (String)"/");
        JsonPatch patch = (JsonPatch)this.jsonMapper.readValue("[{\"op\":\"replace\",\"path\":\"" + propertyPath + "\",\"value\":\"" + value + "\"}]", JsonPatch.class);
        try {
            return this.mergeJSON(jsonObject, patch);
        }
        catch (IOException e) {
            return jsonObject;
        }
    }

    static {
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public class ResourceNotAllowedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResourceNotAllowedException(String message) {
            super(message);
        }
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public class ResourceNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResourceNotFoundException(String message) {
            super(message);
        }
    }

    public class Resource {
        public String data;
        public String type;
        public File file;
    }
}

