/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.ServletContext;

public class ResourceUtils {
    public static Optional<String> findExisting(String[] candidates) {
        return Stream.of(candidates).filter(new Predicate<String>(){

            @Override
            public boolean test(String path) {
                return path != null && new File(path).exists();
            }
        }).findFirst();
    }

    public static Optional<File> findResource(String baseFolders, ServletContext context, final String resourceName) {
        String[] candidates = (String[])Stream.concat(Stream.of(baseFolders.split(",")).filter(new Predicate<String>(){

            @Override
            public boolean test(String string) {
                return string != null && !string.isEmpty();
            }
        }).map(new Function<String, String>(){

            @Override
            public String apply(String f) {
                return f + "/" + resourceName;
            }
        }), Stream.of(new String[]{context != null ? context.getRealPath(resourceName) : null})).toArray((IntFunction<A[]>)new IntFunction<String[]>(){

            @Override
            public String[] apply(int size) {
                return new String[size];
            }
        });
        Optional<String> resourcePath = ResourceUtils.findExisting(candidates);
        return resourcePath.map(File::new);
    }

    public static String getResourcePath(String baseFolder, ServletContext context, String path) {
        return ResourceUtils.getResourcePath(baseFolder, context, path, false);
    }

    public static String getResourcePath(String baseFolder, ServletContext context, String path, boolean write) {
        try {
            String specific;
            if (baseFolder != null && !baseFolder.isEmpty()) {
                File baseDir = ResourceUtils.resolveBaseDirectory(baseFolder, context);
                return ResourceUtils.canonicalChild(baseDir, path).getPath();
            }
            if (context != null && (specific = context.getRealPath(path)) != null) {
                return new File(specific).getCanonicalPath();
            }
            if (write) {
                String root;
                String string = root = context != null ? context.getRealPath("") : null;
                if (root == null || root.isEmpty()) {
                    throw new IllegalArgumentException("Cannot determine servlet context root path");
                }
                return ResourceUtils.canonicalChild(new File(root).getCanonicalFile(), path).getPath();
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to resolve resource path", e);
        }
    }

    private static File resolveBaseDirectory(String baseFolder, ServletContext context) throws IOException {
        File base;
        if (baseFolder != null && !baseFolder.isEmpty()) {
            base = new File(baseFolder);
        } else {
            String root;
            String string = root = context != null ? context.getRealPath("") : null;
            if (root == null || root.isEmpty()) {
                throw new IllegalArgumentException("Cannot determine servlet context root path");
            }
            base = new File(root);
        }
        return base.getCanonicalFile();
    }

    private static File canonicalChild(File baseDir, String childRelativePath) throws IOException {
        if (childRelativePath == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        File child = new File(childRelativePath);
        if (child.isAbsolute()) {
            throw new SecurityException("Absolute paths are not allowed: " + childRelativePath);
        }
        File joined = new File(baseDir, childRelativePath);
        File canonicalJoined = joined.getCanonicalFile();
        File canonicalBase = baseDir.getCanonicalFile();
        String basePath = canonicalBase.getPath();
        String targetPath = canonicalJoined.getPath();
        if (!targetPath.equals(basePath) && !targetPath.startsWith(basePath + File.separator)) {
            throw new SecurityException("Path traversal attempt blocked: " + childRelativePath);
        }
        return canonicalJoined;
    }

    public static void storeJSONConfig(String baseFolder, ServletContext context, Object config, String configName) throws FileNotFoundException, IOException {
        String outputFile = ResourceUtils.getResourcePath(baseFolder, context, configName, true);
        File out = new File(outputFile);
        File parent = out.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create parent directories for: " + outputFile);
        }
        try (FileOutputStream output = new FileOutputStream(out);){
            byte[] bytes = String.valueOf(config).getBytes(StandardCharsets.UTF_8);
            output.write(bytes);
        }
    }

    public static String toPosix(String path) {
        if (path == null) {
            return null;
        }
        String p = path.replace('\\', '/');
        while (p.contains("//")) {
            p = p.replace("//", "/");
        }
        return p;
    }

    public static String posixJoinStrict(String ... segments) {
        if (segments == null || segments.length == 0) {
            throw new IllegalArgumentException("At least one segment is required");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String raw : segments) {
            if (raw == null) {
                throw new IllegalArgumentException("Null segment not allowed");
            }
            String s = ResourceUtils.toPosix(raw).trim();
            if (s.startsWith("/") || s.matches("^[A-Za-z]:.*")) {
                throw new SecurityException("Absolute segment not allowed: " + raw);
            }
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.equals("..") || s.contains("/../") || s.startsWith("../") || s.endsWith("/..")) {
                throw new SecurityException("Traversal not allowed in path segment: " + raw);
            }
            if (s.equals(".") || s.isEmpty()) continue;
            if (!first) {
                sb.append('/');
            }
            sb.append(s);
            first = false;
        }
        if (sb.length() == 0) {
            return ".";
        }
        return sb.toString();
    }
}

