/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.rest.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import it.geosolutions.mapstore.controllers.BaseMapStoreController;
import it.geosolutions.mapstore.utils.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UploadPluginController
extends BaseMapStoreController {
    private static final String PLUGIN_PATH_PREFIX = "__PLUGIN__/";
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(false);
    @Autowired
    ServletContext context;

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/uploadPlugin"}, method={RequestMethod.POST}, headers={"Accept=application/json"})
    @ResponseBody
    public String uploadPlugin(InputStream dataStream) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(dataStream);){
            ZipEntry entry = zip.getNextEntry();
            String pluginName = null;
            String bundleEntryName = null;
            HashMap<File, String> tempFilesToRelativeTargets = new HashMap<File, String>();
            JsonNode plugin = null;
            boolean addTranslations = false;
            while (entry != null) {
                if (!entry.isDirectory()) {
                    File tempAsset;
                    String normalizedEntry = UploadPluginController.normalizeZipEntryName(entry.getName());
                    String lower = normalizedEntry.toLowerCase(Locale.ROOT);
                    if (lower.endsWith("index.js")) {
                        bundleEntryName = normalizedEntry;
                        File tempBundle = File.createTempFile("mapstore-bundle", ".js");
                        this.storeAsset(zip, tempBundle);
                        tempFilesToRelativeTargets.put(tempBundle, "__BUNDLE__");
                    } else if (lower.equals("index.json")) {
                        JsonNode json = this.readJSON(zip);
                        JsonNode plugins = json.get("plugins");
                        if (plugins == null || !plugins.isArray() || plugins.isEmpty()) {
                            throw new IOException("Invalid bundle: index.json has no 'plugins' array");
                        }
                        plugin = plugins.get(0);
                        ((ObjectNode)plugin).put("extension", true);
                        pluginName = plugin.get("name").asText();
                        UploadPluginController.validatePluginName(pluginName);
                        if (this.shouldStorePluginsConfigAsPatch()) {
                            this.addPluginConfigurationAsPatch(plugin);
                        } else {
                            this.addPluginConfiguration(plugin);
                        }
                    } else if (lower.startsWith("translations/")) {
                        tempAsset = File.createTempFile("mapstore-asset-translations", ".json");
                        this.storeAsset(zip, tempAsset);
                        tempFilesToRelativeTargets.put(tempAsset, PLUGIN_PATH_PREFIX + normalizedEntry);
                        addTranslations = true;
                    } else if (lower.startsWith("assets/")) {
                        tempAsset = File.createTempFile("mapstore-asset", ".tmp");
                        this.storeAsset(zip, tempAsset);
                        tempFilesToRelativeTargets.put(tempAsset, PLUGIN_PATH_PREFIX + normalizedEntry);
                    }
                }
                entry = zip.getNextEntry();
            }
            if (plugin == null) {
                throw new IOException("Invalid bundle: index.json missing");
            }
            if (bundleEntryName == null) {
                throw new IOException("Invalid bundle: index.js missing");
            }
            String pluginBundleRelative = UploadPluginController.joinUnixStrict(pluginName, bundleEntryName);
            String translationsDirRelative = addTranslations ? UploadPluginController.joinUnixStrict(pluginName, "translations") : null;
            this.addExtension(pluginName, pluginBundleRelative, translationsDirRelative);
            for (Map.Entry e : tempFilesToRelativeTargets.entrySet()) {
                String relativeTarget;
                File tempFile = (File)e.getKey();
                String markerOrRel = (String)e.getValue();
                if ("__BUNDLE__".equals(markerOrRel)) {
                    relativeTarget = pluginBundleRelative;
                } else if (markerOrRel.startsWith(PLUGIN_PATH_PREFIX)) {
                    String sub = markerOrRel.substring(PLUGIN_PATH_PREFIX.length());
                    relativeTarget = UploadPluginController.joinUnixStrict(pluginName, sub);
                } else {
                    throw new IOException("Unexpected target marker: " + markerOrRel);
                }
                this.moveAsset(tempFile, relativeTarget);
            }
            String string = plugin.toString();
            return string;
        }
    }

    private static void validatePluginName(String pluginName) {
        if (pluginName == null || pluginName.isEmpty() || !pluginName.matches("^[A-Za-z0-9._-]+$")) {
            throw new IllegalArgumentException("Invalid plugin name.");
        }
    }

    private static String normalizeZipEntryName(String entryName) {
        if (entryName == null) {
            throw new SecurityException("Null zip entry");
        }
        String unix = entryName.replace('\\', '/');
        if (unix.startsWith("/") || unix.matches("^[A-Za-z]:.*")) {
            throw new SecurityException("Zip entry is absolute: " + entryName);
        }
        String[] parts = unix.split("/");
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (String seg : parts) {
            if (seg.isEmpty() || ".".equals(seg)) continue;
            if ("..".equals(seg)) {
                throw new SecurityException("Zip entry attempts path traversal: " + entryName);
            }
            stack.addLast(seg);
        }
        return String.join((CharSequence)"/", stack);
    }

    private static String joinUnixStrict(String left, String right) {
        String b;
        String a = left == null ? "" : left.replace('\\', '/');
        String string = b = right == null ? "" : right.replace('\\', '/');
        if (b.startsWith("/")) {
            throw new SecurityException("Absolute component not allowed");
        }
        if (b.contains("..")) {
            throw new SecurityException("Traversal not allowed: " + b);
        }
        if (a.endsWith("/")) {
            a = a.substring(0, a.length() - 1);
        }
        return a.isEmpty() ? b : a + "/" + b;
    }

    private boolean shouldStorePluginsConfigAsPatch() {
        return this.getPluginsConfigAsPatch() != false && this.canUseDataDir();
    }

    private boolean canUseDataDir() {
        return !this.getDataDir().isEmpty() && Stream.of(this.getDataDir().split(",")).anyMatch(folder -> !folder.trim().isEmpty() && new File((String)folder).exists());
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/uninstallPlugin/{pluginName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public String uninstallPlugin(@PathVariable String pluginName) throws IOException {
        UploadPluginController.validatePluginName(pluginName);
        ObjectNode configObj = this.getExtensionConfig();
        if (configObj.has(pluginName)) {
            ArrayNode plugins;
            JsonNode pluginConfig = configObj.get(pluginName);
            String pluginBundle = pluginConfig.get("bundle").asText();
            String pluginFolder = pluginBundle.substring(0, pluginBundle.lastIndexOf("/"));
            Path folderRel = Paths.get(pluginFolder, new String[0]).normalize();
            this.removeFolderSecurely(folderRel);
            configObj.remove(pluginName);
            this.storeJSONConfig(configObj, this.getExtensionsConfigPath());
            ObjectNode pluginsConfigObj = null;
            if (this.shouldStorePluginsConfigAsPatch()) {
                plugins = this.getPluginsConfigurationPatch();
            } else {
                pluginsConfigObj = this.getPluginsConfiguration();
                plugins = (ArrayNode)pluginsConfigObj.get("plugins");
            }
            int toRemove = -1;
            for (int i = 0; i < plugins.size(); ++i) {
                String name;
                JsonNode plugin = plugins.get(i);
                String string = name = plugin.has("name") ? plugin.get("name").asText() : plugin.get("value").get("name").asText();
                if (!name.contentEquals(pluginName)) continue;
                toRemove = i;
            }
            if (toRemove >= 0) {
                plugins.remove(toRemove);
            }
            if (this.shouldStorePluginsConfigAsPatch()) {
                this.storeJSONConfig(plugins, this.getPluginsConfigPatchFilePath());
            } else {
                this.storeJSONConfig(pluginsConfigObj, this.getPluginsConfig());
            }
            return pluginConfig.toString();
        }
        return "{}";
    }

    private void removeFolderSecurely(Path folderRelativeToExtensions) throws IOException {
        if (folderRelativeToExtensions == null) {
            throw new IllegalArgumentException("Plugin folder path cannot be null.");
        }
        String relUnderExtensions = this.getExtensionsFolder().replace('\\', '/') + "/" + folderRelativeToExtensions.toString().replace('\\', '/');
        String resolvedPath = ResourceUtils.getResourcePath(this.getWriteStorage(), this.context, relUnderExtensions, true);
        if (resolvedPath == null) {
            throw new FileNotFoundException("The specified folder path could not be resolved: " + relUnderExtensions);
        }
        File folderPath = new File(resolvedPath).getCanonicalFile();
        String baseFolder = this.getWriteStorage();
        if (baseFolder != null && !baseFolder.isEmpty()) {
            File base = new File(baseFolder).getCanonicalFile();
            String basePath = base.getPath();
            String targetPath = folderPath.getPath();
            if (!targetPath.equals(basePath) && !targetPath.startsWith(basePath + File.separator)) {
                throw new IOException("Unauthorized path traversal attempt detected.");
            }
        }
        if (folderPath.exists()) {
            FileUtils.cleanDirectory((File)folderPath);
            if (!folderPath.delete()) {
                throw new IOException("The specified folder path could not be deleted: " + folderPath.getAbsolutePath());
            }
        } else {
            throw new FileNotFoundException("The specified folder path does not exist: " + folderPath.getAbsolutePath());
        }
    }

    private Optional<File> findResource(String resourceName) {
        return ResourceUtils.findResource(this.getDataDir(), this.context, resourceName);
    }

    private void moveAsset(File tempAsset, String relativeTarget) throws IOException {
        String relUnderExtensions = this.getExtensionsFolder().replace('\\', '/') + "/" + relativeTarget.replace('\\', '/');
        String destPathStr = ResourceUtils.getResourcePath(this.getWriteStorage(), this.context, relUnderExtensions, true);
        if (destPathStr == null) {
            throw new IOException("Unable to resolve destination path for: " + relUnderExtensions);
        }
        File destFile = new File(destPathStr);
        File parent = destFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create parent directories for: " + destFile.getAbsolutePath());
        }
        try (FileInputStream input = new FileInputStream(tempAsset);
             FileOutputStream output = new FileOutputStream(destFile);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        if (!tempAsset.delete()) {
            throw new IOException("Temporary file could not be deleted: " + tempAsset.getAbsolutePath());
        }
    }

    private String getWriteStorage() {
        return this.getDataDir().isEmpty() ? "" : Stream.of(this.getDataDir().split(",")).filter(folder -> !folder.trim().isEmpty()).findFirst().orElse("");
    }

    private void addPluginConfiguration(JsonNode json) throws IOException {
        ObjectNode config;
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                config = (ObjectNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.objectNode();
                config.set("plugins", (JsonNode)this.jsonNodeFactory.arrayNode());
            }
        } else {
            config = this.jsonNodeFactory.objectNode();
            config.set("plugins", (JsonNode)this.jsonNodeFactory.arrayNode());
        }
        if (config != null) {
            ArrayNode plugins = (ArrayNode)config.get("plugins");
            int remove = -1;
            for (int count = 0; count < plugins.size(); ++count) {
                JsonNode node = plugins.get(count);
                if (!json.get("name").asText().equals(node.get("name").asText())) continue;
                remove = count;
            }
            if (remove >= 0) {
                plugins.remove(remove);
            }
            plugins.add(json);
            this.storeJSONConfig(config, this.getPluginsConfigPath());
        }
    }

    private void addPluginConfigurationAsPatch(JsonNode json) throws IOException {
        ArrayNode config;
        String configPath = this.getPluginsConfigPatchFilePath();
        Optional<File> pluginsConfigFile = this.findResource(configPath);
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                config = (ArrayNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.arrayNode();
            }
        } else {
            config = this.jsonNodeFactory.arrayNode();
        }
        if (config != null) {
            int remove = -1;
            for (int count = 0; count < config.size(); ++count) {
                JsonNode node = config.get(count);
                if (!json.get("name").asText().equals(node.get("value").get("name").asText())) continue;
                remove = count;
            }
            if (remove >= 0) {
                config.remove(remove);
            }
            ObjectNode plugin = new ObjectNode(this.jsonNodeFactory);
            plugin.put("op", "add");
            plugin.put("path", "/plugins/-");
            plugin.set("value", json);
            config.add((JsonNode)plugin);
            this.storeJSONConfig(config, configPath);
        }
    }

    private ObjectNode getPluginsConfiguration() throws IOException {
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                ObjectNode objectNode = (ObjectNode)this.readJSON(input);
                return objectNode;
            }
        }
        throw new FileNotFoundException(this.getPluginsConfigPath());
    }

    private ArrayNode getPluginsConfigurationPatch() throws IOException {
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPatchFilePath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                ArrayNode arrayNode = (ArrayNode)this.readJSON(input);
                return arrayNode;
            }
        }
        throw new FileNotFoundException(this.getPluginsConfigPatchFilePath());
    }

    private void storeJSONConfig(Object config, String configName) throws IOException {
        ResourceUtils.storeJSONConfig(this.getWriteStorage(), this.context, config, configName);
    }

    private void addExtension(String pluginName, String pluginBundleRelative, String translationsRelative) throws IOException {
        ObjectNode config;
        Optional<File> extensionsConfigFile = this.findResource(this.getExtensionsConfigPath());
        if (extensionsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(extensionsConfigFile.get());){
                config = (ObjectNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.objectNode();
            }
        } else {
            config = this.jsonNodeFactory.objectNode();
        }
        if (config != null) {
            ObjectNode extension = this.jsonNodeFactory.objectNode();
            extension.put("bundle", pluginBundleRelative);
            if (translationsRelative != null) {
                extension.put("translations", translationsRelative);
            }
            if (config.has(pluginName)) {
                config.replace(pluginName, (JsonNode)extension);
            } else {
                config.set(pluginName, (JsonNode)extension);
            }
            this.storeJSONConfig(config, this.getExtensionsConfigPath());
        }
    }

    private ObjectNode getExtensionConfig() throws IOException {
        Optional<File> extensionsConfigFile = this.findResource(this.getExtensionsConfigPath());
        if (extensionsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(extensionsConfigFile.get());){
                ObjectNode objectNode = (ObjectNode)this.readJSON(input);
                return objectNode;
            }
        }
        throw new FileNotFoundException();
    }

    private JsonNode readJSON(InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        StringBuilder json = new StringBuilder();
        while ((read = input.read(buffer)) >= 0) {
            json.append(new String(buffer, 0, read, StandardCharsets.UTF_8));
        }
        return this.jsonMapper.readTree(json.toString());
    }

    private void storeAsset(ZipInputStream zip, File file) throws IOException {
        try (FileOutputStream outFile = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = zip.read(buffer)) >= 0) {
                outFile.write(buffer, 0, read);
            }
        }
    }

    @Override
    public void setContext(ServletContext context) {
        this.context = context;
    }

    private String getExtensionsConfigPath() {
        return Paths.get(this.getExtensionsFolder(), this.getExtensionsConfig()).toString();
    }

    private String getPluginsConfigPath() {
        return Paths.get(this.getConfigsFolder(), this.getPluginsConfig()).toString();
    }

    private String getPluginsConfigPatchFilePath() {
        return this.getPluginsConfigPath() + ".patch";
    }
}

