/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.geoserver.flow.ControllerPriorityComparator;
import org.geoserver.flow.config.DefaultControlFlowConfigurator;
import org.geoserver.flow.config.Intervals;
import org.geoserver.flow.controller.BasicOWSController;
import org.geoserver.flow.controller.GlobalFlowController;
import org.geoserver.flow.controller.HttpHeaderPriorityProvider;
import org.geoserver.flow.controller.IpFlowController;
import org.geoserver.flow.controller.IpRequestMatcher;
import org.geoserver.flow.controller.PriorityThreadBlocker;
import org.geoserver.flow.controller.RateFlowController;
import org.geoserver.flow.controller.SingleIpFlowController;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.flow.controller.UserConcurrentFlowController;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.PropertyFileWatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DefaultControlFlowConfigurationTest {
    @Test
    public void testParsing() throws Exception {
        PropertyFileWatcher.LinkedProperties p = new PropertyFileWatcher.LinkedProperties();
        p.put("timeout", "10");
        p.put("ows.global", "100");
        p.put("ows.wms.getmap", "8");
        p.put("user", "6");
        p.put("ip", "12");
        p.put("ip.192.168.1.8", "14");
        p.put("ip.192.168.1.10", "15");
        p.put("ip.blacklist", "192.168.1.1,192.168.1.2");
        p.put("ip.whitelist", "192.168.1.3,192.168.1.4");
        p.put("user.ows", "20/s");
        p.put("user.ows.wms", "300/m;3s");
        p.put("ip.ows.wms.getmap", "100/m;3s");
        p.put("ip.ows.wps.execute", "50/d;60s");
        DefaultControlFlowConfigurator configurator = new DefaultControlFlowConfigurator((PropertyFileWatcher)new FixedWatcher((Properties)p));
        Assert.assertTrue((boolean)configurator.isStale());
        List controllers = configurator.buildFlowControllers();
        Collections.sort(controllers, new ControllerPriorityComparator());
        Assert.assertFalse((boolean)configurator.isStale());
        Assert.assertEquals((long)10000L, (long)configurator.getTimeout());
        Assert.assertEquals((long)10L, (long)controllers.size());
        Assert.assertTrue((boolean)(controllers.get(0) instanceof RateFlowController));
        RateFlowController rfc = (RateFlowController)controllers.get(0);
        Assert.assertEquals((Object)"wms.getmap", (Object)rfc.getMatcher().toString());
        Assert.assertEquals((long)100L, (long)rfc.getMaxRequests());
        Assert.assertEquals((long)Intervals.m.getDuration(), (long)rfc.getTimeInterval());
        Assert.assertEquals((long)3000L, (long)rfc.getDelay());
        Assert.assertTrue((boolean)(controllers.get(1) instanceof RateFlowController));
        rfc = (RateFlowController)controllers.get(1);
        Assert.assertEquals((Object)"wms", (Object)rfc.getMatcher().toString());
        Assert.assertEquals((long)300L, (long)rfc.getMaxRequests());
        Assert.assertEquals((long)Intervals.m.getDuration(), (long)rfc.getTimeInterval());
        Assert.assertEquals((long)3000L, (long)rfc.getDelay());
        Assert.assertTrue((boolean)(controllers.get(2) instanceof RateFlowController));
        rfc = (RateFlowController)controllers.get(2);
        Assert.assertEquals((Object)"Any OGC request", (Object)rfc.getMatcher().toString());
        Assert.assertEquals((long)20L, (long)rfc.getMaxRequests());
        Assert.assertEquals((long)Intervals.s.getDuration(), (long)rfc.getTimeInterval());
        Assert.assertEquals((long)0L, (long)rfc.getDelay());
        Assert.assertTrue((boolean)(controllers.get(3) instanceof UserConcurrentFlowController));
        UserConcurrentFlowController uc = (UserConcurrentFlowController)controllers.get(3);
        Assert.assertEquals((long)6L, (long)uc.getPriority());
        Assert.assertTrue((boolean)(controllers.get(4) instanceof BasicOWSController));
        BasicOWSController oc = (BasicOWSController)controllers.get(4);
        Assert.assertEquals((long)8L, (long)oc.getPriority());
        Assert.assertEquals((Object)"wms.getmap", (Object)oc.getMatcher().toString());
        Assert.assertTrue((boolean)(controllers.get(5) instanceof IpFlowController));
        IpFlowController ipFc = (IpFlowController)controllers.get(5);
        Assert.assertEquals((long)12L, (long)ipFc.getPriority());
        Assert.assertTrue((boolean)(controllers.get(6) instanceof SingleIpFlowController));
        SingleIpFlowController ipSc = (SingleIpFlowController)controllers.get(6);
        Assert.assertEquals((long)14L, (long)ipSc.getPriority());
        IpRequestMatcher ipMatcher = (IpRequestMatcher)ipSc.getMatcher();
        Assert.assertEquals((Object)"192.168.1.8", (Object)ipMatcher.getIp());
        Assert.assertTrue((boolean)(controllers.get(7) instanceof SingleIpFlowController));
        ipMatcher = (IpRequestMatcher)((SingleIpFlowController)controllers.get(7)).getMatcher();
        Assert.assertEquals((Object)"192.168.1.10", (Object)ipMatcher.getIp());
        Assert.assertTrue((boolean)(controllers.get(8) instanceof GlobalFlowController));
        GlobalFlowController gc = (GlobalFlowController)controllers.get(8);
        Assert.assertEquals((long)100L, (long)gc.getPriority());
        Assert.assertTrue((boolean)(controllers.get(9) instanceof RateFlowController));
        rfc = (RateFlowController)controllers.get(9);
        Assert.assertEquals((Object)"wps.execute", (Object)rfc.getMatcher().toString());
        Assert.assertEquals((long)50L, (long)rfc.getMaxRequests());
        Assert.assertEquals((long)Intervals.d.getDuration(), (long)rfc.getTimeInterval());
        Assert.assertEquals((long)60000L, (long)rfc.getDelay());
        Assert.assertTrue((boolean)configurator.getFileLocations().isEmpty());
        File tmpDir = DefaultControlFlowConfigurationTest.createTempDir();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(tmpDir);
        configurator.saveConfiguration(resourceLoader);
        Resource controlFlowProps = Files.asResource((File)resourceLoader.find("controlflow.properties"));
        Assert.assertTrue((boolean)Resources.exists((Resource)controlFlowProps));
        PropertyFileWatcher savedProps = new PropertyFileWatcher(controlFlowProps);
        Assert.assertEquals((Object)savedProps.getProperties(), (Object)p);
    }

    @Test
    public void testParsingPriority() throws Exception {
        Properties p = new Properties();
        p.put("timeout", "10");
        p.put("ows.global", "100");
        p.put("ows.priority.http", "gs-priority,3");
        p.put("ows.wms", "6");
        p.put("ows.wfs.getFeature", "12");
        this.checkPriorityParsing(p);
    }

    @Test
    public void testParsingPriorityWithSpaces() throws Exception {
        Properties p = new Properties();
        p.put("timeout", "10");
        p.put("ows.global", "100");
        p.put("ows.priority.http", " gs-priority , 3 ");
        p.put("ows.wms", "6");
        p.put("ows.wfs.getFeature", "12");
        this.checkPriorityParsing(p);
    }

    private void checkPriorityParsing(Properties p) throws Exception {
        DefaultControlFlowConfigurator configurator = new DefaultControlFlowConfigurator((PropertyFileWatcher)new FixedWatcher(p));
        Assert.assertTrue((boolean)configurator.isStale());
        List controllers = configurator.buildFlowControllers();
        Collections.sort(controllers, new ControllerPriorityComparator());
        Assert.assertFalse((boolean)configurator.isStale());
        Assert.assertEquals((long)10000L, (long)configurator.getTimeout());
        Assert.assertEquals((long)3L, (long)controllers.size());
        Assert.assertTrue((boolean)(controllers.get(0) instanceof BasicOWSController));
        BasicOWSController wmsController = (BasicOWSController)controllers.get(0);
        Assert.assertEquals((Object)"wms", (Object)wmsController.getMatcher().toString());
        ThreadBlocker blocker = wmsController.getBlocker();
        this.assertPriorityThreadBlocker(blocker, "gs-priority", 3);
        Assert.assertTrue((boolean)(controllers.get(1) instanceof BasicOWSController));
        BasicOWSController wfsController = (BasicOWSController)controllers.get(1);
        Assert.assertEquals((Object)"wfs.getFeature", (Object)wfsController.getMatcher().toString());
        this.assertPriorityThreadBlocker(blocker, "gs-priority", 3);
    }

    public void assertPriorityThreadBlocker(ThreadBlocker blocker, String headerName, int defaultPriority) {
        MatcherAssert.assertThat((Object)blocker, (Matcher)CoreMatchers.instanceOf(PriorityThreadBlocker.class));
        PriorityThreadBlocker ptb = (PriorityThreadBlocker)blocker;
        MatcherAssert.assertThat((Object)ptb.getPriorityProvider(), (Matcher)CoreMatchers.instanceOf(HttpHeaderPriorityProvider.class));
        HttpHeaderPriorityProvider priorityProvider = (HttpHeaderPriorityProvider)ptb.getPriorityProvider();
        Assert.assertEquals((Object)headerName, (Object)priorityProvider.getHeaderName());
        Assert.assertEquals((long)defaultPriority, (long)priorityProvider.getDefaultPriority());
    }

    static File createTempDir() throws IOException {
        File f = File.createTempFile("controlFlow", "data", new File("target"));
        f.delete();
        f.mkdirs();
        return f;
    }

    static class FixedWatcher
    extends PropertyFileWatcher {
        boolean stale = true;
        Properties properties;

        public FixedWatcher(Properties properties) {
            super(null);
            this.properties = properties;
        }

        public boolean isStale() {
            if (this.stale) {
                this.stale = false;
                return true;
            }
            return false;
        }

        public Properties getProperties() throws IOException {
            return this.properties;
        }
    }
}

