/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.flow.controller.IpFlowControllerTest;
import org.geoserver.flow.controller.SingleIpFlowController;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;

public class SingleIpFlowControllerTest
extends IpFlowControllerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testConcurrentRequestsSingleIPAddress() {
        SingleIpFlowController controller = new SingleIpFlowController(1, "127.0.0.1");
        String ipAddress = "127.0.0.1";
        Request firstRequest = this.buildIpRequest(ipAddress, "");
        FlowControllerTestingThread tSample = new FlowControllerTestingThread(firstRequest, 0L, 0L, new FlowController[]{controller});
        tSample.start();
        this.waitTerminated(tSample, 60000L);
        Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)tSample.state));
        String ip = firstRequest.getHttpRequest().getRemoteAddr();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequestsDifferentIPAddress() {
        SingleIpFlowController controller = new SingleIpFlowController(1, "192.168.1.8");
        String ipAddress = "127.0.0.1";
        Request firstRequest = this.buildIpRequest(ipAddress, "");
        FlowControllerTestingThread tSample = new FlowControllerTestingThread(firstRequest, 0L, 0L, new FlowController[]{controller});
        tSample.start();
        this.waitTerminated(tSample, 60000L);
        Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)tSample.state));
        String ip = firstRequest.getHttpRequest().getRemoteAddr();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }
}

