/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geotools.util.logging.Logging;

public class CatalogStyleChangeListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogStyleChangeListener.class);
    private static ThreadLocal<CatalogModifyEvent> PRE_MODIFY_EVENT = new ThreadLocal();
    private final GWC mediator;
    private Catalog catalog;

    public CatalogStyleChangeListener(GWC mediator, Catalog catalog) {
        this.mediator = mediator;
        this.catalog = catalog;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof StyleInfo) {
            List propertyNames = event.getPropertyNames();
            if (!propertyNames.contains("name") && !propertyNames.contains("workspace")) {
                return;
            }
            int nameIdx = propertyNames.indexOf("name");
            String oldName = nameIdx != -1 ? (String)event.getOldValues().get(nameIdx) : null;
            String newName = nameIdx != -1 ? (String)event.getNewValues().get(nameIdx) : null;
            int workspaceIdx = propertyNames.indexOf("wokspace");
            String oldWorkspaceName = workspaceIdx != -1 ? (String)event.getOldValues().get(workspaceIdx) : null;
            String newWorkspaceName = workspaceIdx != -1 ? (String)event.getNewValues().get(workspaceIdx) : null;
            String oldStyleName = this.getPrefixedName(oldWorkspaceName, oldName);
            String newStyleName = this.getPrefixedName(newWorkspaceName, newName);
            if (nameIdx != -1) {
                this.handleStyleRenamed(oldStyleName, newStyleName);
            }
        } else if (source instanceof WorkspaceInfo) {
            PRE_MODIFY_EVENT.set(event);
        }
    }

    private void handleStyleRenamed(String oldStyleName, String newStyleName) {
        if (oldStyleName.equals(newStyleName)) {
            return;
        }
        List<GeoServerTileLayer> affectedLayers = this.mediator.getTileLayersForStyle(oldStyleName);
        for (GeoServerTileLayer tl : affectedLayers) {
            GeoServerTileLayerInfo info;
            ImmutableSet<String> styleNames;
            if (!(tl.getPublishedInfo() instanceof LayerInfo) || !(styleNames = (info = tl.getInfo()).cachedStyles()).contains((Object)oldStyleName)) continue;
            tl.resetParameterFilters();
            this.mediator.truncateByLayerAndStyle(tl.getName(), oldStyleName);
            HashSet<String> newStyles = new HashSet<String>((Collection<String>)styleNames);
            newStyles.remove(oldStyleName);
            newStyles.add(newStyleName);
            LayerInfo layerInfo = (LayerInfo)tl.getPublishedInfo();
            String defaultStyle = layerInfo.getDefaultStyle() == null ? null : layerInfo.getDefaultStyle().prefixedName();
            TileLayerInfoUtil.setCachedStyles(info, defaultStyle, newStyles);
            this.mediator.save(tl);
        }
    }

    private String getPrefixedName(String workspace, String name) {
        if (workspace != null) {
            return workspace + ":" + name;
        }
        return name;
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof StyleInfo) {
            StyleInfo si = (StyleInfo)source;
            this.handleStyleChange(si);
        } else if (source instanceof WorkspaceInfo) {
            WorkspaceInfo ws = (WorkspaceInfo)source;
            this.handleWorkspaceChange(ws);
        }
    }

    private void handleWorkspaceChange(WorkspaceInfo ws) {
        CatalogModifyEvent preModifyEvent = PRE_MODIFY_EVENT.get();
        PRE_MODIFY_EVENT.remove();
        List changedProperties = preModifyEvent.getPropertyNames();
        int nameIdx = changedProperties.indexOf("name");
        if (nameIdx == -1) {
            return;
        }
        String oldWorkspaceName = (String)preModifyEvent.getOldValues().get(nameIdx);
        String newWorkspaceName = (String)preModifyEvent.getNewValues().get(nameIdx);
        try (CloseableIterator styles = this.catalog.list(StyleInfo.class, Predicates.equal((String)"workspace.name", (Object)newWorkspaceName));){
            while (styles.hasNext()) {
                StyleInfo style = (StyleInfo)styles.next();
                String oldStyleName = oldWorkspaceName + ":" + style.getName();
                String newStyleName = newWorkspaceName + ":" + style.getName();
                this.handleStyleRenamed(oldStyleName, newStyleName);
            }
        }
    }

    private void handleStyleChange(StyleInfo modifiedStyle) {
        String styleName = modifiedStyle.prefixedName();
        log.finer("Handling style modification: " + styleName);
        Iterable<LayerInfo> layers = this.mediator.getLayerInfosFor(modifiedStyle);
        for (LayerInfo affectedLayer : layers) {
            String prefixedName = GWC.tileLayerName(affectedLayer);
            log.info("Truncating layer '" + prefixedName + "' due to a change in style '" + styleName + "'");
            this.mediator.truncateByLayerAndStyle(prefixedName, styleName);
        }
        for (LayerGroupInfo layerGroup : this.mediator.getLayerGroupsFor(modifiedStyle)) {
            String layerGroupName = GWC.tileLayerName(layerGroup);
            log.info("Truncating layer group '" + layerGroupName + "' due to a change in style '" + styleName + "'");
            this.mediator.truncate(layerGroupName);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
    }

    public void reloaded() {
    }
}

