/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.XMLGridSubset;

public class LegacyTileLayerInfoLoader {
    private static final Logger LOGGER = Logging.getLogger(LegacyTileLayerInfoLoader.class);
    public static final String CONFIG_KEY_ENABLED = "GWC.enabled";
    public static final String CONFIG_KEY_GUTTER = "GWC.gutter";
    public static final String CONFIG_KEY_GRIDSETS = "GWC.gridSets";
    public static final String CONFIG_KEY_METATILING_X = "GWC.metaTilingX";
    public static final String CONFIG_KEY_METATILING_Y = "GWC.metaTilingY";
    public static final String CONFIG_KEY_FORMATS = "GWC.cacheFormats";
    public static final String CONFIG_KEY_AUTO_CACHE_STYLES = "GWC.autoCacheStyles";
    public static final String CONFIG_KEY_CACHED_STYLES = "GWC.cachedNonDefaultStyles";
    public static final String CONFIG_KEY_IN_MEMORY_CACHED = "GWC.inMemoryUncached";
    public static final String[] _ALL_KEYS = new String[]{"GWC.enabled", "GWC.gutter", "GWC.gridSets", "GWC.metaTilingX", "GWC.metaTilingY", "GWC.cacheFormats", "GWC.autoCacheStyles", "GWC.cachedNonDefaultStyles", "GWC.inMemoryUncached"};

    public static GeoServerTileLayerInfoImpl load(LayerInfo layer) {
        MetadataMap metadataMap = layer.getMetadata();
        if (!LegacyTileLayerInfoLoader.hasTileLayerDef(metadataMap)) {
            return null;
        }
        GeoServerTileLayerInfoImpl tileLayerInfo = LegacyTileLayerInfoLoader.load(metadataMap);
        if (metadataMap.containsKey((Object)CONFIG_KEY_CACHED_STYLES)) {
            String defaultStyle = layer.getDefaultStyle() == null ? "" : layer.getDefaultStyle().prefixedName();
            String cachedStylesStr = (String)metadataMap.get(CONFIG_KEY_CACHED_STYLES, String.class);
            Set<String> cachedStyles = LegacyTileLayerInfoLoader.unmarshalSet(cachedStylesStr);
            TileLayerInfoUtil.setCachedStyles(tileLayerInfo, defaultStyle, cachedStyles);
        }
        TileLayerInfoUtil.checkAutomaticStyles(layer, (GeoServerTileLayerInfo)tileLayerInfo);
        tileLayerInfo.setName(GWC.tileLayerName(layer));
        tileLayerInfo.setId(layer.getId());
        return tileLayerInfo;
    }

    public static boolean hasTileLayerDef(MetadataMap metadataMap) {
        return metadataMap.containsKey((Object)CONFIG_KEY_ENABLED);
    }

    public static GeoServerTileLayerInfoImpl load(LayerGroupInfo layerGroup) {
        MetadataMap metadataMap = layerGroup.getMetadata();
        if (!LegacyTileLayerInfoLoader.hasTileLayerDef(metadataMap)) {
            return null;
        }
        GeoServerTileLayerInfoImpl tileLayerInfo = LegacyTileLayerInfoLoader.load(metadataMap);
        if (tileLayerInfo != null) {
            tileLayerInfo.setName(GWC.tileLayerName(layerGroup));
            tileLayerInfo.setId(layerGroup.getId());
        }
        TileLayerInfoUtil.checkAutomaticStyles(layerGroup, (GeoServerTileLayerInfo)tileLayerInfo);
        return tileLayerInfo;
    }

    private static GeoServerTileLayerInfoImpl load(MetadataMap metadataMap) {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        boolean enabled = (Boolean)metadataMap.get(CONFIG_KEY_ENABLED, Boolean.class);
        info.setEnabled(enabled);
        int gutter = (Integer)metadataMap.get(CONFIG_KEY_GUTTER, Integer.class);
        info.setGutter(gutter);
        String gridsets = (String)metadataMap.get(CONFIG_KEY_GRIDSETS, String.class);
        Set<XMLGridSubset> gridSetIds = LegacyTileLayerInfoLoader.unmarshalGridSubsets(gridsets);
        info.getGridSubsets().addAll(gridSetIds);
        int metaTilingX = (Integer)metadataMap.get(CONFIG_KEY_METATILING_X, Integer.class);
        info.setMetaTilingX(metaTilingX);
        int metaTilingY = (Integer)metadataMap.get(CONFIG_KEY_METATILING_Y, Integer.class);
        info.setMetaTilingY(metaTilingY);
        if (metadataMap.containsKey((Object)CONFIG_KEY_FORMATS)) {
            String mimeFormatsStr = (String)metadataMap.get(CONFIG_KEY_FORMATS, String.class);
            Set<String> mimeFormats = LegacyTileLayerInfoLoader.unmarshalSet(mimeFormatsStr);
            info.getMimeFormats().addAll(mimeFormats);
        }
        if (metadataMap.containsKey((Object)CONFIG_KEY_AUTO_CACHE_STYLES)) {
            boolean autoCacheStyles = (Boolean)metadataMap.get(CONFIG_KEY_AUTO_CACHE_STYLES, Boolean.class);
            info.setAutoCacheStyles(autoCacheStyles);
        }
        if (metadataMap.containsKey((Object)CONFIG_KEY_IN_MEMORY_CACHED)) {
            boolean inMemoryCached = (Boolean)metadataMap.get(CONFIG_KEY_IN_MEMORY_CACHED, Boolean.class);
            info.setInMemoryCached(inMemoryCached);
        }
        return info;
    }

    private static Set<String> unmarshalSet(String listStr) {
        HashSet<String> unmarshalled = new HashSet<String>(Arrays.asList(listStr.split(",")));
        return unmarshalled;
    }

    private static String marshalList(Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static Set<XMLGridSubset> unmarshalGridSubsets(String gridSubsetsStr) throws IllegalArgumentException {
        String[] epsgCodes;
        HashSet<XMLGridSubset> gridSubsets = new HashSet<XMLGridSubset>();
        for (String code : epsgCodes = gridSubsetsStr.split(",")) {
            if (code.trim().isEmpty()) continue;
            try {
                XMLGridSubset xmlGridSubset = new XMLGridSubset();
                xmlGridSubset.setGridSetName(code);
                gridSubsets.add(xmlGridSubset);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Invalid GridSubset list: " + gridSubsetsStr);
            }
        }
        gridSubsets.remove(null);
        return gridSubsets;
    }

    public static void clear(MetadataMap metadata) {
        if (metadata != null) {
            for (String key : _ALL_KEYS) {
                metadata.remove((Object)key);
            }
        }
    }

    public static void save(GeoServerTileLayerInfo source, MetadataMap metadata) {
        boolean enabled = source.isEnabled();
        int gutter = source.getGutter();
        Set<XMLGridSubset> cachedGridSubsets = source.getGridSubsets();
        int metaTilingX = source.getMetaTilingX();
        int metaTilingY = source.getMetaTilingY();
        Set<String> mimeFormats = source.getMimeFormats();
        Boolean autoCacheStyles = source.isAutoCacheStyles();
        ImmutableSet<String> cachedStyles = source.cachedStyles();
        boolean inMemoryCached = source.isInMemoryCached();
        metadata.put(CONFIG_KEY_ENABLED, (Serializable)Boolean.valueOf(enabled));
        metadata.put(CONFIG_KEY_GUTTER, (Serializable)Integer.valueOf(gutter));
        ArrayList<String> subsetNames = new ArrayList<String>();
        for (XMLGridSubset s : cachedGridSubsets) {
            subsetNames.add(s.getGridSetName());
        }
        metadata.put(CONFIG_KEY_GRIDSETS, (Serializable)((Object)LegacyTileLayerInfoLoader.marshalList(subsetNames)));
        metadata.put(CONFIG_KEY_METATILING_X, (Serializable)Integer.valueOf(metaTilingX));
        metadata.put(CONFIG_KEY_METATILING_Y, (Serializable)Integer.valueOf(metaTilingY));
        metadata.put(CONFIG_KEY_FORMATS, (Serializable)((Object)LegacyTileLayerInfoLoader.marshalList(mimeFormats)));
        metadata.put(CONFIG_KEY_AUTO_CACHE_STYLES, (Serializable)autoCacheStyles);
        metadata.put(CONFIG_KEY_IN_MEMORY_CACHED, (Serializable)Boolean.valueOf(inMemoryCached));
        if (cachedStyles.isEmpty()) {
            metadata.remove((Object)CONFIG_KEY_CACHED_STYLES);
        } else {
            metadata.put(CONFIG_KEY_CACHED_STYLES, (Serializable)((Object)LegacyTileLayerInfoLoader.marshalList(cachedStyles)));
        }
    }
}

