/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.util.HTTPWarningAppender;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;

public class CacheSeedingWebMapService
implements MethodInterceptor {
    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        boolean isSeedingRequest;
        Method method = invocation.getMethod();
        Preconditions.checkArgument((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Preconditions.checkArgument((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(arguments[0] instanceof GetMapRequest));
        GetMapRequest request = (GetMapRequest)arguments[0];
        WebMap map = (WebMap)invocation.proceed();
        Map rawKvp = request.getRawKvp();
        boolean bl = isSeedingRequest = rawKvp != null && rawKvp.containsKey("GWC_SEED_INTERCEPT");
        if (isSeedingRequest) {
            GeoServerTileLayer.WEB_MAP.set(map);
            GeoServerTileLayer.DIMENSION_WARNINGS.set(HTTPWarningAppender.getWarnings());
            return null;
        }
        return map;
    }
}

