/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.admin;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleNewPage;
import org.geoserver.wms.web.data.StylePage;
import org.junit.Assert;
import org.junit.Test;

public class AdminPrivilegesTest
extends GeoServerWicketTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Arrays.asList("ROLE_CITE_ADMIN"));
        this.addUser("sf", "sf", null, Arrays.asList("ROLE_SF_ADMIN"));
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.ADMIN, new String[]{"ROLE_ADMINISTRATOR"});
        this.addLayerAccessRule("cite", "*", AccessMode.ADMIN, new String[]{"ROLE_CITE_ADMIN"});
        this.addLayerAccessRule("cite", "*", AccessMode.ADMIN, new String[]{"ROLE_SF_ADMIN"});
        Catalog cat = this.getCatalog();
        StyleInfo s = cat.getFactory().createStyle();
        s.setName("sf_style");
        s.setWorkspace(cat.getWorkspaceByName("sf"));
        s.setFilename("sf.sld");
        cat.add(s);
        s = cat.getFactory().createStyle();
        s.setName("cite_style");
        s.setWorkspace(cat.getWorkspaceByName("cite"));
        s.setFilename("cite.sld");
        cat.add(s);
    }

    void loginAsCite() {
        this.login("cite", "cite", new String[]{"ROLE_CITE_ADMIN"});
    }

    void loginAsSf() {
        this.login("sf", "sf", new String[]{"ROLE_SF_ADMIN"});
    }

    @Test
    public void testStyleAllPageAsAdmin() throws Exception {
        this.login();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        tester.debugComponentTrees();
        Catalog cat = this.getCatalog();
        DataView view = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)cat.getStyles().size(), (long)view.getItemCount());
    }

    @Test
    public void testStyleAllPage() throws Exception {
        this.loginAsCite();
        tester.startPage(StylePage.class);
        tester.assertRenderedPage(StylePage.class);
        DataView view = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        int expected = 1;
        AdminRequest.start((Object)new Object());
        Assert.assertEquals((long)expected, (long)view.getItemCount());
        Iterator it = view.getItems();
        while (it.hasNext()) {
            String name = ((Item)it.next()).get("itemProperties:0:component:link:label").getDefaultModelObjectAsString();
            Assert.assertNotEquals((Object)"sf_style", (Object)name);
        }
    }

    @Test
    public void testStyleNewPageAsAdmin() throws Exception {
        this.login();
        tester.startPage(StyleNewPage.class);
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertModelValue("styleForm:context:panel:workspace", null);
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        Assert.assertTrue((boolean)choice.isNullValid());
        Assert.assertFalse((boolean)choice.isRequired());
    }

    @Test
    public void testStyleNewPage() throws Exception {
        this.loginAsCite();
        tester.startPage(StyleNewPage.class);
        tester.assertRenderedPage(StyleNewPage.class);
        Catalog cat = this.getCatalog();
        tester.assertModelValue("styleForm:context:panel:workspace", (Object)cat.getWorkspaceByName("cite"));
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace");
        Assert.assertFalse((boolean)choice.isNullValid());
        Assert.assertTrue((boolean)choice.isRequired());
    }

    @Test
    public void testStyleEditPageGlobal() throws Exception {
        this.loginAsCite();
        tester.startPage(StyleEditPage.class, new PageParameters().add("name", (Object)"point"));
        tester.assertRenderedPage(StyleEditPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("styleForm:context:panel:name").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("styleForm:context:panel:workspace").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("styleForm:context:panel:copy").isEnabled());
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("cancel").isEnabled());
    }
}

