/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyleEditPageRenameTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;
    StyleEditPage edit;
    private static final String STYLE_TO_MOVE_NAME = "testStyle";
    private static final String STYLE_TO_MOVE_FILENAME = "testMoveStyle.sld";
    StyleInfo styleInfoToMove;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = this.getCatalog();
        this.login();
        this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        if (this.buildingsStyle == null) {
            StyleInfo si = catalog.getStyleByName("BuildingsNew");
            if (si != null) {
                si.setName(MockData.BUILDINGS.getLocalPart());
                catalog.save(si);
            }
            this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        }
        this.edit = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)this.edit);
        this.styleInfoToMove = catalog.getStyleByName(STYLE_TO_MOVE_NAME);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle(STYLE_TO_MOVE_NAME, STYLE_TO_MOVE_FILENAME, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testMoveFromWorkspace() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleInfo si = catalog.getStyleByName(STYLE_TO_MOVE_NAME);
        si.setWorkspace(catalog.getWorkspaceByName("sf"));
        catalog.save(si);
        GeoServerDataDirectory dataDir = new GeoServerDataDirectory(catalog.getResourceLoader());
        Assert.assertEquals((Object)Resource.Type.UNDEFINED, (Object)dataDir.get(new String[]{"styles/testMoveStyle.sld"}).getType());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)dataDir.get(new String[]{"workspaces/sf/styles/testMoveStyle.sld"}).getType());
        this.edit = new StyleEditPage(si);
        tester.startPage((Page)this.edit);
        Assert.assertEquals((long)1L, (long)si.getStyle().featureTypeStyles().size());
        Assert.assertEquals((Object)"sf", (Object)si.getWorkspace().getName());
        FormTester form = tester.newFormTester("styleForm", false);
        form.setValue("context:panel:workspace", "");
        form.submit();
        si = this.getCatalog().getStyleByName(STYLE_TO_MOVE_NAME);
        Assert.assertNotNull((Object)si);
        Assert.assertNull((Object)si.getWorkspace());
        Assert.assertEquals((Object)Resource.Type.RESOURCE, (Object)dataDir.get(new String[]{"styles/testMoveStyle.sld"}).getType());
        Assert.assertEquals((Object)Resource.Type.UNDEFINED, (Object)dataDir.get(new String[]{"workspaces/sf/styles/testMoveStyle.sld"}).getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenerateTemplateFrenchLocale() throws Exception {
        Session session = tester.getSession();
        try {
            session.clear();
            session.setLocale(Locale.FRENCH);
            StyleEditPage edit = new StyleEditPage(this.buildingsStyle);
            tester.startPage((Page)edit);
            tester.newFormTester("styleForm").select("context:panel:templates", 1);
            tester.executeAjaxEvent("styleForm:context:panel:templates", "change");
            Component generateLink = tester.getComponentFromLastRenderedPage("styleForm:context:panel:generate");
            tester.executeAjaxEvent(generateLink, "click");
            MatcherAssert.assertThat((Object)tester.getLastResponseAsString(), (Matcher)CoreMatchers.containsString((String)"l\\'\u00e9diteur"));
        }
        finally {
            session.clear();
            session.setLocale(Locale.getDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyStyleFrenchLocale() throws Exception {
        Session session = tester.getSession();
        try {
            session.clear();
            session.setLocale(Locale.FRENCH);
            StyleEditPage edit = new StyleEditPage(this.buildingsStyle);
            tester.startPage((Page)edit);
            tester.newFormTester("styleForm").select("context:panel:existingStyles", 1);
            tester.executeAjaxEvent("styleForm:context:panel:existingStyles", "change");
            Component copyLink = tester.getComponentFromLastRenderedPage("styleForm:context:panel:copy");
            tester.executeAjaxEvent(copyLink, "click");
            MatcherAssert.assertThat((Object)tester.getLastResponseAsString(), (Matcher)CoreMatchers.containsString((String)"l\\'\u00e9diteur"));
        }
        finally {
            session.clear();
            session.setLocale(Locale.getDefault());
        }
    }
}

