/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.geotools.api.feature.type.PropertyDescriptor;

public class KMLLayerConfigPanel
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 6469105227923320272L;
    static final List<String> KML_STRATEGIES = Arrays.asList("external-sorting", "geometry", "native-sorting", "random");

    public KMLLayerConfigPanel(String id, IModel<LayerInfo> model) {
        super(id, model);
        PropertyModel metadata = new PropertyModel(model, "resource.metadata");
        this.add(new Component[]{new DropDownChoice("kml.regionateAttribute", (IModel)new MapModel((IModel)metadata, "kml.regionateAttribute"), (IModel)new AttributeNamesModel((IModel<FeatureTypeInfo>)new PropertyModel(model, "resource")))});
        this.add(new Component[]{new DropDownChoice("kml.regionateStrategy", (IModel)new MapModel((IModel)metadata, "kml.regionateStrategy"), KML_STRATEGIES)});
        TextField maxFeatures = new TextField("kml.regionateFeatureLimit", (IModel)new MapModel((IModel)metadata, "kml.regionateFeatureLimit"), Integer.class);
        maxFeatures.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        this.add(new Component[]{maxFeatures});
    }

    private static class AttributeNamesModel
    extends LoadableDetachableModel<List<String>> {
        private static final long serialVersionUID = 2480902398710400909L;
        IModel<FeatureTypeInfo> featureTypeInfo;

        public AttributeNamesModel(IModel<FeatureTypeInfo> featureTypeInfo) {
            this.featureTypeInfo = featureTypeInfo;
        }

        protected List<String> load() {
            try {
                FeatureTypeInfo fti = (FeatureTypeInfo)this.featureTypeInfo.getObject();
                ArrayList<String> result = new ArrayList<String>();
                for (PropertyDescriptor property : fti.getFeatureType().getDescriptors()) {
                    result.add(property.getName().getLocalPart());
                }
                Collections.sort(result);
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load feature type attribute list", e);
            }
        }
    }
}

