/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.geoserver.catalog.StyleInfo;

class LegendGraphicAjaxUpdater
implements Serializable {
    private static final long serialVersionUID = 5543647283072466506L;
    private Image image;
    private IModel<StyleInfo> styleInfoModel;
    private IModel<String> urlModel;

    public LegendGraphicAjaxUpdater(Image image, IModel<StyleInfo> styleInfoModel) {
        this.image = image;
        this.styleInfoModel = styleInfoModel;
        this.urlModel = new Model();
        this.image.add(new Behavior[]{new AttributeModifier("src", this.urlModel)});
        this.updateStyleImage(null);
    }

    public void updateStyleImage(AjaxRequestTarget target) {
        StyleInfo styleInfo = (StyleInfo)this.styleInfoModel.getObject();
        if (styleInfo != null) {
            String url = styleInfo.getWorkspace() == null ? RequestCycle.get().getUrlRenderer().renderContextRelativeUrl("wms") + "?" : RequestCycle.get().getUrlRenderer().renderContextRelativeUrl(styleInfo.getWorkspace().getName() + "/wms") + "?";
            String style = styleInfo.prefixedName();
            url = url + "REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&STRICT=false&style=" + style;
            this.urlModel.setObject((Object)url);
            if (target != null) {
                target.add(new Component[]{this.image});
            }
        }
    }
}

