/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.appschema.feature.AppSchemaAttributeBuilder;
import org.geotools.appschema.jdbc.JoiningJDBCFeatureSource;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.XmlMappingFeatureIterator;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public class DataAccessMappingFeatureIterator
extends AbstractMappingFeatureIterator {
    private FeatureIterator<? extends Feature> sourceFeatureIterator;
    protected CoordinateReferenceSystem reprojection;
    protected Feature curSrcFeature;
    protected FeatureSource<? extends FeatureType, ? extends Feature> mappedSource;
    protected FeatureCollection<? extends FeatureType, ? extends Feature> sourceFeatures;
    protected List<Expression> foreignIds;
    protected AttributeDescriptor targetFeature;
    private Map<JdbcMultipleValue, Map<Object, List<MultiValueContainer>>> jdbcMultiValues = new HashMap<JdbcMultipleValue, Map<Object, List<MultiValueContainer>>>();
    private boolean isFiltered;
    private ArrayList<String> filteredFeatures;
    private Filter listFilter;
    private boolean isTransactionOwner;

    public boolean isTransactionOwner() {
        return this.isTransactionOwner;
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isFiltered, boolean removeQueryLimitIfDenormalised) throws IOException {
        this(store, mapping, query, isFiltered, removeQueryLimitIfDenormalised, false);
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isFiltered, boolean removeQueryLimitIfDenormalised, boolean hasPostFilter) throws IOException {
        this(store, mapping, query, isFiltered, removeQueryLimitIfDenormalised, hasPostFilter, null);
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isFiltered, boolean removeQueryLimitIfDenormalised, boolean hasPostFilter, Transaction transaction) throws IOException {
        super(store, mapping, query, null, removeQueryLimitIfDenormalised, hasPostFilter, transaction);
        this.isFiltered = isFiltered;
        if (isFiltered) {
            this.filteredFeatures = new ArrayList();
        }
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        this(store, mapping, query, null, false);
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, boolean removeQueryLimitIfDenormalised) throws IOException {
        this(store, mapping, query, unrolledQuery, removeQueryLimitIfDenormalised, null);
    }

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, boolean removeQueryLimitIfDenormalised, Transaction transaction) throws IOException {
        super(store, mapping, query, unrolledQuery, removeQueryLimitIfDenormalised, false, transaction);
    }

    @Override
    public boolean hasNext() {
        boolean exists;
        boolean bl = exists = !this.isNextSourceFeatureNull();
        if (!this.isHasNextCalled()) {
            if (this.featureCounter < this.requestMaxFeatures) {
                if (!exists && this.getSourceFeatureIterator() != null && this.getSourceFeatureIterator().hasNext()) {
                    this.curSrcFeature = this.getSourceFeatureIterator().next();
                    exists = true;
                }
                if (exists && this.filteredFeatures != null) {
                    while (exists && this.filteredFeatures.contains(this.extractIdForFeature(this.curSrcFeature))) {
                        if (this.getSourceFeatureIterator() != null && this.getSourceFeatureIterator().hasNext()) {
                            this.curSrcFeature = this.getSourceFeatureIterator().next();
                            exists = true;
                            continue;
                        }
                        exists = false;
                    }
                }
                if (this.listFilter != null) {
                    while (exists && !this.listFilter.evaluate((Object)this.curSrcFeature)) {
                        if (this.getSourceFeatureIterator() != null && this.getSourceFeatureIterator().hasNext()) {
                            this.curSrcFeature = this.getSourceFeatureIterator().next();
                            exists = true;
                            continue;
                        }
                        exists = false;
                    }
                }
            } else {
                exists = false;
            }
        }
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
            this.curSrcFeature = null;
        }
        this.setHasNextCalled(true);
        return exists;
    }

    @Override
    protected FeatureIterator<? extends Feature> getSourceFeatureIterator() {
        return this.sourceFeatureIterator;
    }

    @Override
    protected boolean isSourceFeatureIteratorNull() {
        return this.getSourceFeatureIterator() == null;
    }

    protected Object peekValue(Object source, Expression prop) {
        Object o = prop.evaluate(source);
        if (o instanceof Attribute) {
            o = ((Attribute)o).getValue();
        }
        return o;
    }

    public Object peekNextValue(Expression prop) {
        return this.peekValue(this.curSrcFeature, prop);
    }

    public void setForeignIds(List<Expression> ids) {
        this.foreignIds = ids;
    }

    public List<Object> getForeignIdValues(Object source) {
        if (this.foreignIds != null) {
            ArrayList<Object> foreignIdValues = new ArrayList<Object>();
            for (int i = 0; i < this.foreignIds.size(); ++i) {
                foreignIdValues.add(i, this.peekValue(source, this.foreignIds.get(i)));
            }
            return foreignIdValues;
        }
        return null;
    }

    protected boolean checkForeignIdValues(List<Object> foreignIdValues, Feature next) {
        if (this.foreignIds != null) {
            for (int i = 0; i < this.foreignIds.size(); ++i) {
                if (this.peekValue(next, this.foreignIds.get(i)).toString().equals(foreignIdValues.get(i).toString())) continue;
                return false;
            }
        }
        return true;
    }

    public List<Object> getIdValues(Object source) {
        ArrayList<Object> ids = new ArrayList<Object>();
        Expression idExpression = this.mapping.getFeatureIdExpression();
        if (Expression.NIL.equals(idExpression) || idExpression instanceof Literal) {
            if (source instanceof Feature) {
                for (Property p : ((Feature)source).getProperties()) {
                    if (!p.getName().getLocalPart().startsWith("PARENT_TABLE_PKEY")) continue;
                    ids.add(p.getValue());
                }
            }
        } else {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            idExpression.accept((ExpressionVisitor)extractor, null);
            for (String att : extractor.getAttributeNameSet()) {
                ids.add(this.peekValue(source, (Expression)this.namespaceAwareFilterFactory.property(att)));
            }
        }
        if (this.foreignIds != null) {
            ids.addAll(this.getForeignIdValues(source));
        }
        return ids;
    }

    public boolean checkForeignIdValues(List<Object> foreignIdValues) {
        return this.checkForeignIdValues(foreignIdValues, this.curSrcFeature);
    }

    @Override
    protected void initialiseSourceFeatures(FeatureTypeMapping mapping, Query query, CoordinateReferenceSystem targetCRS) throws IOException {
        this.mappedSource = mapping.getSource();
        if (query instanceof JoiningQuery) {
            JoiningJDBCFeatureSource joiningJdbcFS = null;
            if (this.mappedSource instanceof JDBCFeatureSource) {
                joiningJdbcFS = new JoiningJDBCFeatureSource((JDBCFeatureSource)this.mappedSource);
            } else if (this.mappedSource instanceof JDBCFeatureStore) {
                joiningJdbcFS = new JoiningJDBCFeatureSource((JDBCFeatureStore)this.mappedSource);
            } else {
                throw new IllegalArgumentException("Joining queries are only supported on JDBC data stores");
            }
            if (this.transaction != null) {
                this.isTransactionOwner = false;
            } else {
                this.transaction = new DefaultTransaction();
                this.isTransactionOwner = true;
            }
            joiningJdbcFS.setTransaction(this.transaction);
            this.mappedSource = joiningJdbcFS;
        }
        String version = (String)this.mapping.getTargetFeature().getType().getUserData().get("targetVersion");
        if (targetCRS == null && version != null && !version.contains("wms")) {
            CoordinateReferenceSystem target;
            CoordinateReferenceSystem crs = null;
            try {
                crs = this.mappedSource.getSchema().getCoordinateReferenceSystem();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            CoordinateReferenceSystem declaredCRS = this.getDeclaredCrs(crs, version);
            Object crsobject = this.mapping.getTargetFeature().getType().getUserData().get("targetCrs");
            if (crsobject instanceof CoordinateReferenceSystem) {
                target = (CoordinateReferenceSystem)crsobject;
            } else if (crsobject instanceof URI) {
                URI uri = (URI)crsobject;
                if (uri != null) {
                    try {
                        target = CRS.decode((String)uri.toString());
                    }
                    catch (Exception e) {
                        String msg = "Unable to support srsName: " + String.valueOf(uri);
                        throw new UnsupportedOperationException(msg, e);
                    }
                } else {
                    target = declaredCRS;
                }
            } else {
                target = declaredCRS;
            }
            this.reprojection = target;
        } else {
            this.reprojection = targetCRS;
        }
        mapping.getTargetFeature().getType().getUserData().put("targetVersion", null);
        mapping.getTargetFeature().getType().getUserData().put("targetCrs", null);
        this.targetFeature = this.reprojectAttribute(mapping.getTargetFeature());
        query.setMaxFeatures(this.dataMaxFeatures);
        this.sourceFeatures = this.mappedSource.getFeatures(query);
        if (this.reprojection != null) {
            this.xpathAttributeBuilder.setCRS(this.reprojection);
            if (this.sourceFeatures.getSchema().getGeometryDescriptor() == null || this.isReprojectionCrsEqual(this.mappedSource.getSchema().getCoordinateReferenceSystem(), this.reprojection)) {
                query.setCoordinateSystemReproject(null);
            }
        }
        if (!(this instanceof XmlMappingFeatureIterator)) {
            this.sourceFeatureIterator = this.sourceFeatures.features();
        }
        for (AttributeMapping attMapping : this.selectedMapping) {
            if (!(attMapping instanceof JoiningNestedAttributeMapping)) continue;
            ((JoiningNestedAttributeMapping)attMapping).open(this, query, mapping);
        }
    }

    @Override
    protected boolean unprocessedFeatureExists() {
        boolean exists = this.getSourceFeatureIterator().hasNext();
        if (exists && this.curSrcFeature == null) {
            this.curSrcFeature = this.getSourceFeatureIterator().next();
        }
        return exists;
    }

    protected String extractIdForFeature(Feature feature) {
        if (this.mapping.getFeatureIdExpression().equals(Expression.NIL)) {
            if (feature.getIdentifier() == null) {
                return null;
            }
            return feature.getIdentifier().getID();
        }
        return (String)this.mapping.getFeatureIdExpression().evaluate((Object)feature, String.class);
    }

    @Override
    protected String extractIdForAttribute(Expression idExpression, Object sourceInstance) {
        String value = (String)idExpression.evaluate(sourceInstance, String.class);
        return value;
    }

    @Override
    protected boolean isNextSourceFeatureNull() {
        return this.curSrcFeature == null;
    }

    @Override
    protected boolean sourceFeatureIteratorHasNext() {
        return this.getSourceFeatureIterator().hasNext();
    }

    protected Object getValues(boolean isMultiValued, Expression expression, Object sourceFeatureInput) {
        if (isMultiValued && sourceFeatureInput instanceof FeatureImpl && expression instanceof AttributeExpressionImpl) {
            AttributeExpressionImpl attribExpression = (AttributeExpressionImpl)expression;
            String xpath = attribExpression.getPropertyName();
            ComplexAttribute sourceFeature = (ComplexAttribute)sourceFeatureInput;
            XPathUtil.StepList xpathSteps = XPath.steps((AttributeDescriptor)sourceFeature.getDescriptor(), (String)xpath, (NamespaceSupport)this.namespaces);
            return this.getProperties(sourceFeature, xpathSteps);
        }
        return expression.evaluate(sourceFeatureInput);
    }

    protected Attribute setAttributeValue(Attribute target, String id, Object source, AttributeMapping attMapping, Object values, XPathUtil.StepList inputXpath, List<PropertyName> selectedProperties) throws IOException {
        Expression sourceExpression = attMapping.getSourceExpression();
        AttributeType targetNodeType = attMapping.getTargetNodeInstance();
        XPathUtil.StepList xpath = inputXpath == null ? attMapping.getTargetXPath().clone() : inputXpath;
        Map<Name, Expression> clientPropsMappings = attMapping.getClientProperties();
        boolean isNestedFeature = attMapping.isNestedAttribute();
        if (id == null && Expression.NIL != attMapping.getIdentifierExpression()) {
            id = this.extractIdForAttribute(attMapping.getIdentifierExpression(), source);
        }
        if (attMapping.isNestedAttribute()) {
            NestedAttributeMapping nestedMapping = (NestedAttributeMapping)attMapping;
            Object mappingName = nestedMapping.getNestedFeatureType(source);
            if (mappingName != null) {
                if (nestedMapping.isSameSource() && mappingName instanceof Name) {
                    return this.setPolymorphicValues((Name)mappingName, target, id, nestedMapping, source, xpath, clientPropsMappings);
                }
                if (mappingName instanceof String) {
                    if (attMapping instanceof JoiningNestedAttributeMapping) {
                        if (values == null && source != null) {
                            values = this.getValues(attMapping.isMultiValued(), sourceExpression, source);
                        }
                        if (values != null) {
                            List<Object> idValues = this.getIdValues(source);
                            if (values instanceof Collection) {
                                for (Object singleVal : (Collection)values) {
                                    ((JoiningNestedAttributeMapping)attMapping).skip(this, singleVal, idValues);
                                }
                            } else {
                                ((JoiningNestedAttributeMapping)attMapping).skip(this, values, idValues);
                            }
                        }
                    }
                    return this.setPolymorphicReference((String)mappingName, clientPropsMappings, target, xpath, targetNodeType);
                }
            } else {
                return null;
            }
        }
        if (source instanceof Feature && attMapping.isMultiValued() && attMapping.getMultipleValue() != null) {
            values = this.extractMultipleValues((Feature)source, attMapping);
        } else if (values == null && source != null) {
            values = this.getValues(attMapping.isMultiValued(), sourceExpression, source);
        }
        boolean isHRefLink = this.isByReference(clientPropsMappings, isNestedFeature);
        int newResolveDepth = this.resolveDepth;
        boolean ignoreXlinkHref = false;
        if (isHRefLink && newResolveDepth > 0) {
            isHRefLink = false;
            --newResolveDepth;
            ignoreXlinkHref = true;
        }
        if (isNestedFeature) {
            if (values instanceof Collection) {
                ArrayList<Feature> nestedFeatures = new ArrayList<Feature>(((Collection)values).size());
                for (Object val : (Collection)values) {
                    if (val instanceof Attribute) {
                        if ((val = ((Attribute)val).getValue()) instanceof Collection) {
                            val = ((Collection)val).iterator().next();
                        }
                        while (val instanceof Attribute) {
                            val = ((Attribute)val).getValue();
                        }
                    }
                    if (isHRefLink) {
                        nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getInputFeatures(this, val, this.getIdValues(source), source, this.reprojection, selectedProperties, this.includeMandatory));
                        continue;
                    }
                    nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getFeatures(this, val, this.getIdValues(source), this.reprojection, source, selectedProperties, this.includeMandatory, newResolveDepth, this.resolveTimeOut));
                }
                values = nestedFeatures;
            } else {
                values = isHRefLink ? ((NestedAttributeMapping)attMapping).getInputFeatures(this, values, this.getIdValues(source), source, this.reprojection, selectedProperties, this.includeMandatory) : ((NestedAttributeMapping)attMapping).getFeatures(this, values, this.getIdValues(source), this.reprojection, source, selectedProperties, this.includeMandatory, newResolveDepth, this.resolveTimeOut);
            }
            if (isHRefLink) {
                this.setXlinkReference(target, clientPropsMappings, values, xpath, targetNodeType);
                return null;
            }
        }
        Attribute instance = null;
        if (this.isMultiElement(values, clientPropsMappings)) {
            this.generateInnerElementMultiValue(target, values, targetNodeType, xpath, clientPropsMappings);
        } else if (values instanceof Collection) {
            Collection cobjs = values;
            for (Object singleVal : cobjs) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Map<Name, Expression> clientProperties = clientPropsMappings;
                if (!isNestedFeature) {
                    if (singleVal instanceof Attribute) {
                        singleVal = ((Attribute)singleVal).getValue();
                    }
                    if (singleVal instanceof Collection) {
                        Collection collection = (Collection)singleVal;
                        valueList.addAll(collection);
                    }
                    if (singleVal instanceof MultiValueContainer) {
                        MultiValueContainer multiValue = (MultiValueContainer)singleVal;
                        valueList.add(multiValue.value);
                        clientProperties = MultiValueContainer.resolve((FilterFactory)this.filterFac, multiValue, clientProperties);
                    } else {
                        valueList.add(singleVal);
                    }
                } else {
                    valueList.add(singleVal);
                }
                instance = this.setAttributeContent(target, xpath, valueList, id, targetNodeType, false, sourceExpression, source, clientProperties, ignoreXlinkHref);
            }
        } else {
            if (values instanceof Attribute) {
                Map<Name, Expression> newClientProps = this.getClientProperties((Property)((Attribute)values));
                if (!newClientProps.isEmpty()) {
                    newClientProps.putAll(clientPropsMappings);
                    clientPropsMappings = newClientProps;
                }
                values = ((Attribute)values).getValue();
            }
            instance = this.setAttributeContent(target, xpath, values, id, targetNodeType, false, sourceExpression, source, this.cleanFromAnonymousAttribute(clientPropsMappings), ignoreXlinkHref);
        }
        if (attMapping.encodeIfEmpty()) {
            if (instance == null) {
                instance = this.setAttributeContent(target, xpath, values, id, targetNodeType, false, sourceExpression, source, clientPropsMappings, ignoreXlinkHref);
            }
            instance.getDescriptor().getUserData().put("encodeIfEmpty", attMapping.encodeIfEmpty());
        }
        return instance;
    }

    private Map<Name, Expression> cleanFromAnonymousAttribute(Map<Name, Expression> clientProps) {
        return clientProps.entrySet().stream().filter(e -> !(e.getKey() instanceof AppSchemaDataAccessConfigurator.ComplexNameImpl)).collect(Collectors.toMap(e -> (Name)e.getKey(), e -> (Expression)e.getValue()));
    }

    private void generateInnerElementMultiValue(Attribute target, Object values, AttributeType targetNodeType, XPathUtil.StepList xpath, Map<Name, Expression> clientPropsMappings) {
        Collection multiValues = (Collection)values;
        Attribute parentAttribute = this.xpathAttributeBuilder.set(target, xpath, null, null, targetNodeType, false, null);
        boolean allComplexNames = clientPropsMappings.entrySet().stream().allMatch(e -> e.getKey() instanceof AppSchemaDataAccessConfigurator.ComplexNameImpl);
        if (!multiValues.isEmpty() && !clientPropsMappings.isEmpty() && allComplexNames) {
            parentAttribute.getUserData().put("multi_value_type", "unbounded-multi-value");
        }
        for (MultiValueContainer mv : multiValues) {
            Map<Name, Expression> clientProperties = clientPropsMappings;
            clientProperties = MultiValueContainer.resolve((FilterFactory)this.filterFac, mv, clientProperties);
            for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
                XPathUtil.Step newStep = new XPathUtil.Step(new QName(entry.getKey().getNamespaceURI(), entry.getKey().getLocalPart(), ((XPathUtil.Step)xpath.get(0)).getName().getPrefix()), xpath.size() + 1);
                XPathUtil.StepList slist = xpath.clone();
                slist.add((Object)newStep);
                this.xpathAttributeBuilder.set(parentAttribute, slist, entry.getValue(), null, targetNodeType, false, entry.getValue());
            }
        }
    }

    private boolean isMultiElement(Object values, Map<Name, Expression> clientPropsMappings) {
        if (!(values instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)values;
        if (collection.isEmpty() || !collection.stream().allMatch(o -> o instanceof MultiValueContainer)) {
            return false;
        }
        List expressionEntryList = collection.stream().map(o -> (MultiValueContainer)o).flatMap(m -> {
            Map<Name, Expression> clientProperties = clientPropsMappings;
            clientProperties = MultiValueContainer.resolve((FilterFactory)this.filterFac, m, clientProperties);
            return clientProperties.entrySet().stream();
        }).collect(Collectors.toList());
        if (expressionEntryList.isEmpty()) {
            return false;
        }
        return expressionEntryList.stream().allMatch(y -> y.getKey() instanceof AppSchemaDataAccessConfigurator.ComplexNameImpl);
    }

    private List<MultiValueContainer> extractMultipleValues(Feature sourceFeature, AttributeMapping attributeMapping) throws IOException {
        Object sourceColumnValue;
        List<MultiValueContainer> list;
        MultipleValue multipleValue = attributeMapping.getMultipleValue();
        if (!(multipleValue instanceof JdbcMultipleValue)) {
            List<Object> values = multipleValue.getValues(sourceFeature, attributeMapping);
            return MultiValueContainer.toList(sourceFeature, values);
        }
        JdbcMultipleValue jdbcMultipleValue = (JdbcMultipleValue)multipleValue;
        Map<Object, List<MultiValueContainer>> candidates = this.jdbcMultiValues.get(jdbcMultipleValue);
        if (candidates == null) {
            candidates = new HashMap<Object, List<MultiValueContainer>>();
            if (!(this.mappedSource instanceof JoiningJDBCFeatureSource)) {
                throw new RuntimeException(String.format("JDBC multi values only work with JDBC based data sources, got '%s'.", this.mappedSource.getName()));
            }
            JoiningJDBCFeatureSource jdbcDataSource = (JoiningJDBCFeatureSource)this.mappedSource;
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featuresReader = jdbcDataSource.getJoiningReaderInternal(jdbcMultipleValue, (JoiningQuery)this.query);){
                while (featuresReader.hasNext()) {
                    SimpleFeature readFeature = (SimpleFeature)featuresReader.next();
                    Object targetColumnValue = readFeature.getProperty(jdbcMultipleValue.getTargetColumn()).getValue();
                    List<MultiValueContainer> candidatesValues = candidates.get(targetColumnValue);
                    if (candidatesValues == null) {
                        candidatesValues = new ArrayList<MultiValueContainer>();
                        candidates.put(targetColumnValue, candidatesValues);
                    }
                    Object targetValue = jdbcMultipleValue.getTargetValue() != null ? jdbcMultipleValue.getTargetValue().evaluate((Object)readFeature) : null;
                    candidatesValues.add(new MultiValueContainer((Feature)readFeature, targetValue));
                }
            }
            this.jdbcMultiValues.put(jdbcMultipleValue, candidates);
        }
        return (list = candidates.get(sourceColumnValue = sourceFeature.getProperty(jdbcMultipleValue.getSourceColumn()).getValue())) != null ? list : Collections.emptyList();
    }

    private Attribute setPolymorphicReference(String uri, Map<Name, Expression> clientPropsMappings, Attribute target, XPathUtil.StepList xpath, AttributeType targetNodeType) {
        if (uri != null) {
            Attribute instance = this.xpathAttributeBuilder.set(target, xpath, null, "", targetNodeType, true, null);
            HashMap<Name, Expression> newClientProps = new HashMap<Name, Expression>();
            newClientProps.putAll(clientPropsMappings);
            newClientProps.put(XLINK_HREF_NAME, (Expression)this.namespaceAwareFilterFactory.literal((Object)uri));
            this.setClientProperties(instance, null, newClientProps);
            return instance;
        }
        return null;
    }

    private Attribute setPolymorphicValues(Name mappingName, Attribute target, String id, NestedAttributeMapping nestedMapping, Object source, XPathUtil.StepList xpath, Map<Name, Expression> clientPropsMappings) throws IOException {
        DataAccess<FeatureType, Feature> da = DataAccessRegistry.getDataAccess(mappingName);
        if (da instanceof AppSchemaDataAccess) {
            FeatureTypeMapping fTypeMapping = ((AppSchemaDataAccess)da).getMappingByName(mappingName);
            List<AttributeMapping> polymorphicMappings = fTypeMapping.getAttributeMappings();
            AttributeDescriptor attDescriptor = fTypeMapping.getTargetFeature();
            AttributeType type = attDescriptor.getType();
            Name polymorphicTypeName = attDescriptor.getName();
            XPathUtil.StepList prefixedXpath = xpath.clone();
            prefixedXpath.add((Object)new XPathUtil.Step(new QName(polymorphicTypeName.getNamespaceURI(), polymorphicTypeName.getLocalPart(), this.namespaces.getPrefix(polymorphicTypeName.getNamespaceURI())), 1));
            if (!fTypeMapping.getFeatureIdExpression().equals(Expression.NIL)) {
                id = (String)fTypeMapping.getFeatureIdExpression().evaluate(source, String.class);
            }
            Attribute instance = this.xpathAttributeBuilder.set(target, prefixedXpath, null, id, type, false, attDescriptor, null);
            this.setClientProperties(instance, source, clientPropsMappings);
            for (AttributeMapping mapping : polymorphicMappings) {
                if (this.skipTopElement(polymorphicTypeName, mapping, type)) {
                    this.setClientProperties(instance, source, mapping.getClientProperties());
                    continue;
                }
                this.setAttributeValue(instance, null, source, mapping, null, null, (List)this.selectedProperties.get(mapping));
            }
            return instance;
        }
        return null;
    }

    protected void setXlinkReference(Attribute target, Map<Name, Expression> clientPropsMappings, Object value, XPathUtil.StepList xpath, AttributeType targetNodeType) {
        Expression linkExpression = clientPropsMappings.get(XLINK_HREF_NAME);
        for (Object singleVal : (Collection)value) {
            Collection<Property> existingAttributes = this.getProperties((ComplexAttribute)target, xpath);
            boolean exists = false;
            if (existingAttributes != null) {
                for (Property existingAttribute : existingAttributes) {
                    Object hrefValue;
                    Object existingValue = existingAttribute.getUserData().get(Attributes.class);
                    if (existingValue != null) {
                        assert (existingValue instanceof HashMap);
                        existingValue = ((Map)existingValue).get(XLINK_HREF_NAME);
                    }
                    if (existingValue == null || (hrefValue = linkExpression.evaluate(singleVal)) == null || !hrefValue.equals(existingValue)) continue;
                    exists = true;
                    break;
                }
            }
            if (exists) continue;
            Attribute instance = this.xpathAttributeBuilder.set(target, xpath, null, null, targetNodeType, true, null);
            this.setClientProperties(instance, singleVal, clientPropsMappings);
        }
    }

    protected List<Feature> setNextFeature(String fId, List<Object> foreignIdValues) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(this.curSrcFeature);
        this.curSrcFeature = null;
        while (this.getSourceFeatureIterator().hasNext()) {
            Feature next = this.getSourceFeatureIterator().next();
            if (this.extractIdForFeature(next).equals(fId) && this.checkForeignIdValues(foreignIdValues, next)) {
                if (this.listFilter != null) {
                    if (!this.listFilter.evaluate((Object)next)) continue;
                    features.add(next);
                    continue;
                }
                features.add(next);
                continue;
            }
            if (this.listFilter != null && !this.listFilter.evaluate((Object)next)) continue;
            this.curSrcFeature = next;
            break;
        }
        return features;
    }

    private List<Feature> setNextFilteredFeature(String fId) throws IOException {
        PropertyIsEqualTo fidFilter;
        Query query = new Query();
        if (this.reprojection != null && this.sourceFeatures.getSchema().getGeometryDescriptor() != null && !this.isReprojectionCrsEqual(this.mappedSource.getSchema().getCoordinateReferenceSystem(), this.reprojection)) {
            query.setCoordinateSystemReproject(this.reprojection);
        }
        if (this.mapping.getFeatureIdExpression().equals(Expression.NIL)) {
            HashSet<FeatureId> ids = new HashSet<FeatureId>();
            FeatureId featureId = this.namespaceAwareFilterFactory.featureId(fId);
            ids.add(featureId);
            fidFilter = this.namespaceAwareFilterFactory.id(ids);
        } else {
            fidFilter = this.namespaceAwareFilterFactory.equals(this.mapping.getFeatureIdExpression(), (Expression)this.namespaceAwareFilterFactory.literal((Object)fId));
        }
        if (this.listFilter != null) {
            ArrayList<Object> filters = new ArrayList<Object>();
            filters.add(this.listFilter);
            filters.add(fidFilter);
            fidFilter = this.namespaceAwareFilterFactory.and(filters);
        }
        query.setFilter((Filter)fidFilter);
        FeatureCollection matchingFeatures = this.mappedSource.getFeatures(query);
        ArrayList<Feature> features = new ArrayList<Feature>();
        try (FeatureIterator iterator = matchingFeatures.features();){
            while (iterator.hasNext()) {
                features.add(iterator.next());
            }
            if (features.isEmpty()) {
                features.add(this.curSrcFeature);
            }
            this.filteredFeatures.add(fId);
        }
        this.curSrcFeature = null;
        return features;
    }

    public void skipNestedMapping(AttributeMapping attMapping, List<Feature> sources) throws IOException {
        if (attMapping instanceof JoiningNestedAttributeMapping) {
            for (Feature source : sources) {
                Object value = this.getValues(attMapping.isMultiValued(), attMapping.getSourceExpression(), source);
                if (value instanceof Collection) {
                    for (Object val : (Collection)value) {
                        ((JoiningNestedAttributeMapping)attMapping).skip(this, val, this.getIdValues(source));
                    }
                    continue;
                }
                ((JoiningNestedAttributeMapping)attMapping).skip(this, value, this.getIdValues(source));
            }
        }
    }

    public List<Feature> skip() throws IOException {
        this.setHasNextCalled(false);
        List<Feature> sources = this.getSources(this.extractIdForFeature(this.curSrcFeature));
        for (AttributeMapping attMapping : this.selectedMapping) {
            this.skipNestedMapping(attMapping, sources);
        }
        return sources;
    }

    private GeometryDescriptor reprojectGeometry(GeometryDescriptor descr) {
        if (descr == null) {
            return null;
        }
        GeometryType type = this.ftf.createGeometryType(descr.getType().getName(), descr.getType().getBinding(), this.reprojection, descr.getType().isIdentified(), descr.getType().isAbstract(), descr.getType().getRestrictions(), descr.getType().getSuper(), descr.getType().getDescription());
        type.getUserData().putAll(descr.getType().getUserData());
        GeometryDescriptor gd = this.ftf.createGeometryDescriptor(type, descr.getName(), descr.getMinOccurs(), descr.getMaxOccurs(), descr.isNillable(), descr.getDefaultValue());
        gd.getUserData().putAll(descr.getUserData());
        return gd;
    }

    private FeatureType reprojectType(FeatureType type) {
        ArrayList<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descr : type.getDescriptors()) {
            if (descr instanceof GeometryDescriptor) {
                schema.add((PropertyDescriptor)this.reprojectGeometry((GeometryDescriptor)descr));
                continue;
            }
            schema.add(descr);
        }
        NonFeatureTypeProxy ft = type instanceof NonFeatureTypeProxy ? new NonFeatureTypeProxy(((NonFeatureTypeProxy)type).getSubject(), this.mapping, schema) : this.ftf.createFeatureType(type.getName(), schema, this.reprojectGeometry(type.getGeometryDescriptor()), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
        ft.getUserData().putAll(type.getUserData());
        return ft;
    }

    private AttributeDescriptor reprojectAttribute(AttributeDescriptor descr) {
        if (this.reprojection != null && descr.getType() instanceof FeatureType) {
            AttributeDescriptor ad = this.ftf.createAttributeDescriptor((AttributeType)this.reprojectType((FeatureType)descr.getType()), descr.getName(), descr.getMinOccurs(), descr.getMaxOccurs(), descr.isNillable(), descr.getDefaultValue());
            ad.getUserData().putAll(descr.getUserData());
            return ad;
        }
        return descr;
    }

    @Override
    protected Feature computeNext() throws IOException {
        String id = this.getNextFeatureId();
        List<Feature> sources = this.getSources(id);
        Name targetNodeName = this.targetFeature.getName();
        AppSchemaAttributeBuilder builder = new AppSchemaAttributeBuilder(this.attf);
        builder.setDescriptor(this.targetFeature);
        Feature target = (Feature)builder.build(id);
        for (AttributeMapping attMapping : this.selectedMapping) {
            try {
                if (this.skipTopElement(targetNodeName, attMapping, this.targetFeature.getType())) {
                    this.setClientPropertiesRootEl(target, sources, attMapping);
                    continue;
                }
                if (attMapping.isList()) {
                    Attribute instance = this.setAttributeValue((Attribute)target, null, sources.get(0), attMapping, null, null, (List)this.selectedProperties.get(attMapping));
                    if (sources.size() <= 1 || instance == null) continue;
                    ArrayList<Object> values = new ArrayList<Object>();
                    Expression sourceExpr = attMapping.getSourceExpression();
                    for (Feature source : sources) {
                        values.add(this.getValue(sourceExpr, source));
                    }
                    String valueString = StringUtils.join(values.iterator(), (String)" ");
                    XPathUtil.StepList fullPath = attMapping.getTargetXPath();
                    XPathUtil.StepList leafPath = fullPath.subList(fullPath.size() - 1, fullPath.size());
                    if (instance instanceof ComplexAttributeImpl) {
                        this.xpathAttributeBuilder.set(instance, leafPath, valueString, null, null, false, sourceExpr);
                        continue;
                    }
                    instance.setValue((Object)valueString);
                    continue;
                }
                if (attMapping.isMultiValued()) {
                    for (Feature source : sources) {
                        this.setAttributeValue((Attribute)target, null, source, attMapping, null, null, (List)this.selectedProperties.get(attMapping));
                    }
                    continue;
                }
                String indexString = attMapping.getSourceIndex();
                int index = 0;
                if (indexString != null) {
                    index = "LAST".equals(indexString) ? sources.size() - 1 : Integer.parseInt(indexString);
                }
                this.setAttributeValue((Attribute)target, null, sources.get(index), attMapping, null, null, (List)this.selectedProperties.get(attMapping));
                this.skipNestedMapping(attMapping, sources.subList(1, sources.size()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error applying mapping with targetAttribute " + String.valueOf(attMapping.getTargetXPath()), e);
            }
        }
        this.setDefaultGeometryAttribute(target);
        this.cleanEmptyElements(target);
        return target;
    }

    private void setClientPropertiesRootEl(Feature target, List<Feature> sources, AttributeMapping attMapping) {
        Map<Name, Expression> clientProps = attMapping.getClientProperties();
        if (MapUtils.isNotEmpty(clientProps) && CollectionUtils.isNotEmpty(sources)) {
            sources.forEach(f -> this.setClientProperties((Attribute)target, f, clientProps));
        }
    }

    private void setDefaultGeometryAttribute(Feature feature) {
        GeometryDescriptor defaultGeomDescr;
        String defaultGeomXPath = this.mapping.getDefaultGeometryXPath();
        if (defaultGeomXPath != null && !defaultGeomXPath.isEmpty() && (defaultGeomDescr = feature.getType().getGeometryDescriptor()) != null) {
            PropertyName geomProperty = this.filterFac.property(defaultGeomXPath, this.namespaces);
            Object geomValue = geomProperty.evaluate((Object)feature);
            if (geomValue instanceof Collection) {
                throw new RuntimeException("Error setting default geometry value: multiple values were found");
            }
            String geomName = Types.toPrefixedName((Name)defaultGeomDescr.getName(), (NamespaceSupport)this.namespaces);
            XPathUtil.StepList fakeDefaultGeomXPath = XPath.steps((AttributeDescriptor)this.targetFeature, (String)geomName, (NamespaceSupport)this.namespaces);
            this.xpathAttributeBuilder.set((Attribute)feature, fakeDefaultGeomXPath, geomValue, null, null, false, null);
        }
    }

    protected List<Feature> getSources(String id) throws IOException {
        if (this.isFiltered) {
            return this.setNextFilteredFeature(id);
        }
        return this.setNextFeature(id, this.getForeignIdValues(this.curSrcFeature));
    }

    protected String getNextFeatureId() {
        return this.extractIdForFeature(this.curSrcFeature);
    }

    protected void cleanEmptyElements(Feature target) throws DataSourceException {
        try {
            ArrayList<Property> values = new ArrayList<Property>();
            for (Property property : target.getValue()) {
                if (!this.hasChild(property) && property.getDescriptor().getMinOccurs() <= 0 && !this.getEncodeIfEmpty(property)) continue;
                values.add(property);
            }
            target.setValue(values);
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Unable to clean empty element", (Throwable)e);
        }
    }

    private boolean hasChild(Property property) throws DataSourceException {
        boolean result = false;
        if (this.hasChildElementOnUserData(property)) {
            return true;
        }
        if (property.getValue() instanceof Collection) {
            Collection collection = (Collection)property.getValue();
            ArrayList<Property> values = new ArrayList<Property>();
            for (Object o : collection) {
                if (!(o instanceof Property)) continue;
                Property p = (Property)o;
                if (this.hasChild(p)) {
                    values.add(p);
                    result = true;
                    continue;
                }
                if (this.getEncodeIfEmpty(p)) {
                    values.add(p);
                    result = true;
                    continue;
                }
                if (p.getDescriptor().getMinOccurs() <= 0 || !p.getDescriptor().isNillable()) continue;
                values.add(p);
            }
            property.setValue(values);
            if (this.getClientProperties(property).containsKey(XLINK_HREF_NAME)) {
                return true;
            }
        } else if (property.getName().equals((Object)ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME)) {
            result = false;
        } else if (property.getValue() != null && property.getValue().toString().length() > 0) {
            result = true;
        }
        return result;
    }

    private boolean hasChildElementOnUserData(Property property) {
        if (property.getUserData() != null && property.getUserData().containsKey(Attributes.class) && property.getUserData().get(Attributes.class) instanceof Map) {
            Map childsMap = (Map)property.getUserData().get(Attributes.class);
            for (Object objectKey : childsMap.keySet()) {
                if (!(objectKey instanceof AppSchemaDataAccessConfigurator.ComplexNameImpl)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean skipTopElement(Name topElement, AttributeMapping attMapping, AttributeType type) {
        return XPath.equals((Name)topElement, (XPathUtil.StepList)attMapping.getTargetXPath()) && (attMapping.getSourceExpression() == null || Expression.NIL.equals(attMapping.getSourceExpression()));
    }

    @Override
    protected Feature populateFeatureData(String id) throws IOException {
        throw new UnsupportedOperationException("populateFeatureData should not be called!");
    }

    @Override
    protected void closeSourceFeatures() {
        if (this.sourceFeatures != null && this.getSourceFeatureIterator() != null) {
            this.sourceFeatureIterator.close();
            this.sourceFeatureIterator = null;
            this.sourceFeatures = null;
            this.filteredFeatures = null;
            this.listFilter = null;
            for (AttributeMapping attMapping : this.selectedMapping) {
                if (!(attMapping instanceof JoiningNestedAttributeMapping)) continue;
                ((JoiningNestedAttributeMapping)attMapping).close(this);
            }
            if (this.transaction != null && this.isTransactionOwner) {
                try {
                    this.transaction.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Exception occurred closing transaction: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected Object getValue(Expression expression, Object sourceFeature) {
        Object value = expression.evaluate(sourceFeature);
        if (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        return value;
    }

    private Collection<Property> getProperties(ComplexAttribute root, XPathUtil.StepList xpath) {
        XPathUtil.StepList steps = new XPathUtil.StepList(xpath);
        Iterator stepsIterator = steps.iterator();
        Collection properties = null;
        XPathUtil.Step step = null;
        if (stepsIterator.hasNext()) {
            step = (XPathUtil.Step)stepsIterator.next();
            properties = root.getProperties(Types.toTypeName((QName)step.getName()));
        }
        while (stepsIterator.hasNext()) {
            step = (XPathUtil.Step)stepsIterator.next();
            ArrayList nestedProperties = new ArrayList();
            for (Property property : properties) {
                assert (property instanceof ComplexAttribute);
                Collection tempProperties = ((ComplexAttribute)property).getProperties(Types.toTypeName((QName)step.getName()));
                if (tempProperties.isEmpty()) continue;
                nestedProperties.addAll(tempProperties);
            }
            properties.clear();
            if (nestedProperties.isEmpty()) {
                return properties;
            }
            properties.addAll(nestedProperties);
        }
        return properties;
    }

    protected boolean isByReference(Map<Name, Expression> clientPropsMappings, boolean isNested) {
        return isNested ? (clientPropsMappings.isEmpty() ? false : clientPropsMappings.get(XLINK_HREF_NAME) != null) : false;
    }

    private CoordinateReferenceSystem getDeclaredCrs(CoordinateReferenceSystem nativeCRS, String wfsVersion) {
        try {
            if (nativeCRS == null) {
                return null;
            }
            if (wfsVersion.equals("1.0.0")) {
                return nativeCRS;
            }
            String code = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)nativeCRS);
            if (code == null) {
                return nativeCRS;
            }
            return CRS.decode((String)("urn:x-ogc:def:crs:EPSG:6.11.2:" + code));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("We have had issues trying to flip axis of " + String.valueOf(nativeCRS), e);
        }
    }

    public boolean isReprojectionCrsEqual(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return CRS.equalsIgnoreMetadata((Object)source, (Object)target);
    }

    public void setListFilter(Filter filter) {
        this.listFilter = filter;
    }

    private boolean getEncodeIfEmpty(Property p) {
        Object o = p.getDescriptor().getUserData().get("encodeIfEmpty");
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getMappedSource() {
        return this.mappedSource;
    }

    private static final class MultiValueContainer {
        final Feature feature;
        final Object value;

        MultiValueContainer(Feature feature, Object value) {
            this.feature = feature;
            this.value = value;
        }

        static List<MultiValueContainer> toList(Feature feature, List<Object> values) {
            ArrayList<MultiValueContainer> list = new ArrayList<MultiValueContainer>();
            for (Object value : values) {
                list.add(new MultiValueContainer(feature, value));
            }
            return list;
        }

        static Map<Name, Expression> resolve(FilterFactory filterFactory, MultiValueContainer multiValue, Map<Name, Expression> properties) {
            HashMap<Name, Expression> resolved = new HashMap<Name, Expression>();
            for (Map.Entry<Name, Expression> entry : properties.entrySet()) {
                Name key = entry.getKey();
                Expression expression = entry.getValue();
                Object value = expression.evaluate((Object)multiValue.feature);
                resolved.put(key, (Expression)filterFactory.literal(value));
            }
            return resolved;
        }
    }
}

