/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.IndexIdIterator;
import org.geotools.data.complex.IndexQueryManager;
import org.geotools.data.complex.filter.IndexUnmappingVisitor;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class IndexedMappingFeatureIterator
implements IMappingFeatureIterator {
    private static int MAX_FEATURES_ROUND = 100;
    protected FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    protected final AppSchemaDataAccess store;
    protected final FeatureTypeMapping mapping;
    protected final Query query;
    protected final Filter unrolledFilter;
    protected final Transaction transaction;
    protected IndexIdIterator indexIterator;
    protected FeatureIterator<? extends Feature> sourceIterator;
    protected IndexQueryManager indexModeProc;
    protected IndexQueryManager.QueryIndexCoverage queryMode;

    public IndexedMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction, IndexQueryManager indexModeProcessor) {
        this.store = store;
        this.mapping = mapping;
        this.query = query;
        this.unrolledFilter = unrolledFilter;
        this.transaction = transaction;
        this.indexModeProc = indexModeProcessor;
        this.selectExecutionPlan();
    }

    protected void selectExecutionPlan() {
        this.queryMode = this.indexModeProc.getIndexMode();
    }

    protected Query unrollIndexes(Query query) {
        Query newQuery = new Query(query);
        newQuery.setFilter(this.unrollFilter(query.getFilter()));
        return newQuery;
    }

    protected SortBy[] unrollSortBy(SortBy[] sortArray) {
        if (sortArray == null) {
            return null;
        }
        ArrayList<SortBy> unrolledSorts = new ArrayList<SortBy>();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        for (SortBy aSort : sortArray) {
            SortBy newSort = ff.sort(IndexedMappingFeatureIterator.unrollIndex(aSort.getPropertyName(), this.mapping).getPropertyName(), aSort.getSortOrder());
            unrolledSorts.add(newSort);
        }
        return unrolledSorts.toArray(new SortBy[0]);
    }

    public static PropertyName unrollIndex(PropertyName expression, FeatureTypeMapping mapping) {
        String targetXPath = expression.getPropertyName();
        AttributeMapping attMp = IndexedMappingFeatureIterator.getIndexedAttribute(mapping, targetXPath);
        if (attMp != null) {
            return new AttributeExpressionImpl(attMp.getIndexField());
        }
        return new AttributeExpressionImpl((String)null);
    }

    protected Filter unrollFilter(Filter filter) {
        IndexUnmappingVisitor visitor = new IndexUnmappingVisitor(this.mapping);
        Filter unrolledFilter = (Filter)filter.accept((FilterVisitor)visitor, null);
        return unrolledFilter;
    }

    public XPathUtil.StepList getFidStepList() {
        return XPathUtil.rootElementSteps((AttributeDescriptor)this.mapping.getTargetFeature(), (NamespaceSupport)this.mapping.namespaces);
    }

    public AttributeMapping getFidAttrMap() {
        return this.mapping.getAttributeMapping(this.getFidStepList());
    }

    public String getFidIndexName() {
        return this.getFidAttrMap().getIndexField();
    }

    protected boolean isDenormalized() {
        return !"id".equals(this.getFidIndexName().toLowerCase());
    }

    protected IndexIdIterator getIndexIterator() {
        if (this.indexIterator == null) {
            try {
                this.initializeIndexIterator();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.indexIterator;
    }

    protected void initializeIndexIterator() throws IOException {
        Query idQuery = this.transformQueryToIdsOnly();
        FeatureCollection fc = this.mapping.getIndexSource().getFeatures(idQuery);
        this.indexIterator = this.isDenormalized() ? new IndexIdIterator.IndexUniqueVisitorIterator((FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, idQuery, this.getFidIndexName()) : new IndexIdIterator.IndexFeatureIdIterator((FeatureIterator<? extends Feature>)fc.features());
    }

    protected Query transformQueryToIdsOnly() {
        Query idsQuery = new Query(this.unrollIndexes(this.query));
        idsQuery.setProperties(this.getIndexQueryProperties());
        idsQuery.setTypeName(((SimpleFeatureType)this.mapping.getIndexSource().getSchema()).getTypeName());
        return idsQuery;
    }

    protected List<PropertyName> getIndexQueryProperties() {
        return Arrays.asList(this.ff.property(this.getFidIndexName()));
    }

    protected List<String> getNextSourceIdList() {
        ArrayList<String> ids = new ArrayList<String>();
        for (int numFeatures = 0; numFeatures < MAX_FEATURES_ROUND && this.getIndexIterator().hasNext(); ++numFeatures) {
            ids.add((String)this.indexIterator.next());
        }
        return ids;
    }

    protected static AttributeMapping getIndexedAttribute(FeatureTypeMapping mapping, String xpath) {
        return IndexQueryUtils.getIndexedAttribute(mapping, xpath);
    }
}

